/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class LoggingHelper {
    public static final int SPACING_LENGTH = 30;
    public static final String BLANK = " ";
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    public static final String CONSOLE_START_INDENT = "# ";
    public static final String CONSOLE_FOLLOW_INDENT = "#   ";
    public static final String CONSOLE_SPACE = "    ";

    public static String getSystemPropertiesAsString() {
        Properties p = System.getProperties();
        return LoggingHelper.mapToString(p);
    }

    private static String createSpacing(Object prefix) {
        StringBuffer buf = new StringBuffer();
        int border = 30 - prefix.toString().length();
        buf.append(": ");
        for (int i = 0; i < border; ++i) {
            buf.append(BLANK);
        }
        return buf.toString();
    }

    public static String mapToString(Map map) {
        StringBuffer buf = new StringBuffer();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Object k = it.next();
            Object v = map.get(k);
            buf.append(LINE_SEPARATOR + k + LoggingHelper.createSpacing(k) + v);
        }
        return buf.toString();
    }

    public static String collectionToString(Collection col) {
        StringBuffer buf = new StringBuffer();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            buf.append(LINE_SEPARATOR + obj.toString());
        }
        return buf.toString();
    }

    public static String traceObject(Object obj) {
        StringBuffer buf = new StringBuffer();
        if (obj == null) {
            return null;
        }
        buf.append(LINE_SEPARATOR + CONSOLE_START_INDENT + "Trace object of class " + obj.getClass().getName() + ": " + LINE_SEPARATOR);
        for (Class<?> trace = obj.getClass(); trace != null; trace = trace.getSuperclass()) {
            Field[] fields = trace.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                try {
                    buf.append(CONSOLE_FOLLOW_INDENT + field.getName() + CONSOLE_SPACE + field.get(obj) + LINE_SEPARATOR);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return buf.toString();
    }

    public static String traceObject(Object[] obj) {
        String s1 = "## object[";
        String s2 = "]";
        StringBuffer buf = new StringBuffer();
        buf.append(LINE_SEPARATOR + "## Start tracing array ##");
        for (int i = 0; i < obj.length; ++i) {
            buf.append(LINE_SEPARATOR + s1 + (i + 1) + s2);
            buf.append(LINE_SEPARATOR + LoggingHelper.traceObject(obj[i]));
        }
        buf.append("## Stop tracing array ##");
        return buf.toString();
    }

    public static String traceObject(Object[][] obj) {
        if (obj == null || obj.length == 0) {
            return "Matrix was null or empty";
        }
        String s1 = "## object[";
        String s2 = "][";
        String s3 = "]";
        StringBuffer buf = new StringBuffer();
        buf.append(LINE_SEPARATOR + "## Start tracing matrix ##");
        for (int i = 0; i < obj.length; ++i) {
            for (int j = 0; j < obj[0].length; ++j) {
                buf.append(LINE_SEPARATOR + s1 + (i + 1) + s2 + (j + 1) + s3);
                buf.append(LINE_SEPARATOR + LoggingHelper.traceObject(obj[i][j]));
            }
        }
        buf.append(LINE_SEPARATOR + "## Stop tracing matrix ##" + LINE_SEPARATOR);
        return buf.toString();
    }
}

