/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.util.HashMap;
import java.util.Map;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.CommonsLoggerImpl;
import org.apache.ojb.broker.util.logging.Log4jLoggerImpl;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;
import org.apache.ojb.broker.util.logging.PoorMansLoggerImpl;

public class LoggerFactoryImpl {
    public static final LoggerFactoryImpl INSTANCE = new LoggerFactoryImpl();
    Logger defaultLogger = null;
    Logger bootLogger = null;
    Map cache = new HashMap();
    static /* synthetic */ Class class$java$lang$String;

    private LoggerFactoryImpl() {
    }

    public static LoggerFactoryImpl getInstance() {
        return INSTANCE;
    }

    public Logger getBootLogger() {
        if (this.bootLogger == null) {
            this.bootLogger = new PoorMansLoggerImpl("BOOT");
            String level = System.getProperty("OJB.bootLogLevel", "WARN");
            ((PoorMansLoggerImpl)this.bootLogger).setLevel(level);
        }
        return this.bootLogger;
    }

    public Logger getDefaultLogger() {
        if (this.defaultLogger == null) {
            this.defaultLogger = this.getLogger("DEFAULT");
        }
        return this.defaultLogger;
    }

    public Logger getLogger(Class clazz) {
        return this.getLogger(clazz.getName());
    }

    public Logger getLogger(String loggerName) {
        if (this.cache.containsKey(loggerName)) {
            this.getBootLogger().debug("Returning cached version of Logger[" + loggerName + "]");
            return (Logger)this.cache.get(loggerName);
        }
        this.getBootLogger().debug("Logger[" + loggerName + "] not cached");
        Logger logger = null;
        Class loggerClass = null;
        try {
            OjbConfigurator configurator = OjbConfigurator.getInstance();
            LoggingConfiguration lc = (LoggingConfiguration)configurator.getConfigurationFor(null);
            loggerClass = lc.getLoggerClass();
            this.getBootLogger().debug("Using logger class : " + loggerClass + " for:" + loggerName);
            logger = (Logger)ClassHelper.newInstance(loggerClass, class$java$lang$String == null ? (class$java$lang$String = LoggerFactoryImpl.class$("java.lang.String")) : class$java$lang$String, (Object)loggerName);
            if (logger instanceof Log4jLoggerImpl) {
                this.getBootLogger().debug("Initializing Log4j logger instance " + loggerName);
                logger.configure(lc);
            } else if (logger instanceof PoorMansLoggerImpl) {
                this.getBootLogger().debug("Initializing PoorMans logger instance " + loggerName);
                logger.configure(lc);
            } else if (logger instanceof CommonsLoggerImpl) {
                this.getBootLogger().debug("Initializing Commons logger instance " + loggerName);
                logger.configure(lc);
            } else {
                try {
                    this.getBootLogger().debug("Initializing Custom logger instance " + loggerName);
                    logger.configure(lc);
                }
                catch (Exception x) {
                    throw new IllegalArgumentException("Don't know how to initialize : " + logger);
                }
            }
            this.cache.put(loggerName, logger);
        }
        catch (Throwable t) {
            logger = this.getBootLogger();
            logger.error("[" + this.getClass().getName() + "]   Could not set logger for class " + loggerClass, t);
        }
        return logger;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

