/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import org.apache.log4j.LogManager;
import org.apache.log4j.Priority;
import org.apache.log4j.PropertyConfigurator;
import org.apache.log4j.helpers.NullEnumeration;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;

public class Log4jLoggerImpl
implements Logger {
    private static HashMap priorityMap;
    private transient org.apache.log4j.Logger logger;
    private String name;
    private static final String FQCN;
    private static boolean log4jConfigured;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl;

    private static synchronized boolean isLog4JConfigured() {
        if (log4jConfigured) {
            return true;
        }
        Enumeration enumeration = org.apache.log4j.Logger.getRootLogger().getAllAppenders();
        if (!(enumeration instanceof NullEnumeration)) {
            log4jConfigured = true;
            return true;
        }
        Enumeration cats = LogManager.getCurrentLoggers();
        while (cats.hasMoreElements()) {
            org.apache.log4j.Logger c = (org.apache.log4j.Logger)cats.nextElement();
            if (c.getAllAppenders() instanceof NullEnumeration) continue;
            log4jConfigured = true;
            return true;
        }
        return false;
    }

    private static synchronized void initializeLog4JSubSystem(String configFile) {
        LoggerFactory.getBootLogger().info("Initializing Log4J using file:" + configFile);
        if (configFile != null) {
            URL url = Thread.currentThread().getContextClassLoader().getResource(configFile);
            LoggerFactory.getBootLogger().info("Initializing Log4J : resource from config file:" + url);
            if (url != null) {
                PropertyConfigurator.configure((URL)url);
            } else if (configFile != "") {
                PropertyConfigurator.configure((String)configFile);
            }
        }
    }

    public Log4jLoggerImpl(String name) {
        this.name = name;
        this.logger = org.apache.log4j.Logger.getLogger((String)name);
    }

    private org.apache.log4j.Logger getLogger() {
        if (this.logger == null) {
            this.logger = org.apache.log4j.Logger.getLogger((String)this.name);
        }
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    private Priority getPriority() {
        return this.getLogger().getEffectiveLevel();
    }

    public final void debug(Object pObject) {
        this.getLogger().log(FQCN, Priority.DEBUG, pObject, null);
    }

    public final void info(Object pObject) {
        this.getLogger().log(FQCN, Priority.INFO, pObject, null);
    }

    public final void warn(Object pObject) {
        this.getLogger().log(FQCN, Priority.WARN, pObject, null);
    }

    public final void error(Object pObject) {
        this.getLogger().log(FQCN, Priority.ERROR, pObject, null);
    }

    public final void fatal(Object pObject) {
        this.getLogger().log(FQCN, Priority.FATAL, pObject, null);
    }

    public void debug(Object message, Throwable obj) {
        this.getLogger().log(FQCN, Priority.DEBUG, message, obj);
    }

    public void error(Object message, Throwable obj) {
        this.getLogger().log(FQCN, Priority.ERROR, message, obj);
    }

    public void fatal(Object message, Throwable obj) {
        this.getLogger().log(FQCN, Priority.FATAL, message, obj);
    }

    public void info(Object message, Throwable obj) {
        this.getLogger().log(FQCN, Priority.INFO, message, obj);
    }

    public void warn(Object message, Throwable obj) {
        this.getLogger().log(FQCN, Priority.WARN, message, obj);
    }

    public void safeDebug(String message, Object obj) {
        if (Priority.DEBUG.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.debug(message + " : " + toString);
        }
    }

    public void safeDebug(String message, Object obj, Throwable throwable) {
        if (Priority.DEBUG.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.debug(message + " : " + toString, throwable);
        }
    }

    public void safeInfo(String message, Object obj) {
        if (Priority.INFO.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.info(message + " : " + toString);
        }
    }

    public void safeInfo(String message, Object obj, Throwable throwable) {
        if (Priority.INFO.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            if (obj != null) {
                try {
                    toString = obj.toString();
                }
                catch (Throwable t) {
                    toString = "BAD toString() impl for " + obj.getClass().getName();
                }
            }
            this.info(message + " : " + toString, throwable);
        }
    }

    public void safeWarn(String message, Object obj) {
        if (Priority.WARN.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.warn(message + " : " + toString);
        }
    }

    public void safeWarn(String message, Object obj, Throwable throwable) {
        if (Priority.WARN.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.warn(message + " : " + toString, throwable);
        }
    }

    public void safeError(String message, Object obj) {
        if (Priority.ERROR.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.error(message + " : " + toString);
        }
    }

    public void safeError(String message, Object obj, Throwable throwable) {
        if (Priority.ERROR.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.error(message + " : " + toString, throwable);
        }
    }

    public void safeFatal(String message, Object obj) {
        if (Priority.FATAL.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.fatal(message + " : " + toString);
        }
    }

    public void safeFatal(String message, Object obj, Throwable throwable) {
        if (Priority.FATAL.isGreaterOrEqual(this.getPriority())) {
            String toString = null;
            try {
                toString = obj.toString();
            }
            catch (Throwable t) {
                toString = "BAD toString() impl for " + obj.getClass().getName();
            }
            this.fatal(message + " : " + toString, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.getLogger().isDebugEnabled();
    }

    public boolean isEnabledFor(int priority) {
        return this.getLogger().isEnabledFor((Priority)priorityMap.get(new Integer(priority)));
    }

    public void configure(Configuration config) throws ConfigurationException {
        if (!Log4jLoggerImpl.isLog4JConfigured()) {
            LoggingConfiguration lc = (LoggingConfiguration)config;
            Log4jLoggerImpl.initializeLog4JSubSystem(lc.getLoggerConfigFile());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FQCN = (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl = Log4jLoggerImpl.class$("org.apache.ojb.broker.util.logging.Log4jLoggerImpl")) : class$org$apache$ojb$broker$util$logging$Log4jLoggerImpl).getName();
        log4jConfigured = false;
        priorityMap = new HashMap();
        priorityMap.put(new Integer(1), Priority.DEBUG);
        priorityMap.put(new Integer(2), Priority.INFO);
        priorityMap.put(new Integer(3), Priority.WARN);
        priorityMap.put(new Integer(4), Priority.ERROR);
        priorityMap.put(new Integer(5), Priority.FATAL);
    }
}

