/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.factory;

import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.interceptor.InterceptorFactory;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public abstract class ConfigurableFactory
implements Configurable {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Class classToServe = null;

    public ConfigurableFactory() {
        OjbConfigurator.getInstance().configure(this);
    }

    protected abstract String getConfigurationKey();

    public void configure(Configuration pConfig) throws ConfigurationException {
        if (this.getConfigurationKey() == null) {
            this.getLogger().error("ConfigurableFactory configuration key is 'null'");
            throw new PersistenceBrokerException("ConfigurableFactory configuration key is 'null'");
        }
        Class clazz = pConfig.getClass(this.getConfigurationKey(), null);
        if (clazz == null) {
            this.getLogger().error("ConfigurableFactory configuration key class for key'" + this.getConfigurationKey() + "' does not exist.");
            throw new PersistenceBrokerException("ConfigurableFactory configuration key class for key'" + this.getConfigurationKey() + "' does not exist.");
        }
        this.setClassToServe(clazz);
    }

    public Object createNewInstance(Class[] types, Object[] args) {
        try {
            Object result = types != null ? ClassHelper.newInstance(this.getClassToServe(), types, args) : ClassHelper.newInstance(this.getClassToServe());
            result = InterceptorFactory.getInstance().createInterceptorFor(result);
            return result;
        }
        catch (InstantiationException e) {
            this.getLogger().error("ConfigurableFactory can't instantiate class " + this.getClassToServe() + this.buildArgumentString(types, args), e);
            throw new PersistenceBrokerException(e);
        }
        catch (IllegalAccessException e) {
            this.getLogger().error("ConfigurableFactory can't access constructor for class " + this.getClassToServe() + this.buildArgumentString(types, args), e);
            throw new PersistenceBrokerException(e);
        }
        catch (Exception e) {
            this.getLogger().error("ConfigurableFactory instantiation failed for class " + this.getClassToServe() + this.buildArgumentString(types, args), e);
            throw new PersistenceBrokerException(e);
        }
    }

    protected String buildArgumentString(Class[] types, Object[] args) {
        int i;
        StringBuffer buf = new StringBuffer();
        String eol = SystemUtils.LINE_SEPARATOR;
        buf.append(eol + "* Factory types: ");
        if (types != null) {
            for (i = 0; i < types.length; ++i) {
                Class type = types[i];
                buf.append(eol + (i + 1) + " - Type: " + (type != null ? type.getName() : null));
            }
        } else {
            buf.append(eol + "none");
        }
        buf.append(eol + "* Factory arguments: ");
        if (args != null) {
            for (i = 0; i < args.length; ++i) {
                Object obj = args[i];
                buf.append(eol + (i + 1) + " - Argument: " + obj);
            }
        } else {
            buf.append(eol + "none");
        }
        return buf.toString();
    }

    public Object createNewInstance() {
        return this.createNewInstance((Class)null, (Object)null);
    }

    public Object createNewInstance(Class type, Object arg) {
        if (type != null) {
            return this.createNewInstance(new Class[]{type}, new Object[]{arg});
        }
        return this.createNewInstance((Class[])null, null);
    }

    public Class getClassToServe() {
        return this.classToServe;
    }

    public void setClassToServe(Class classToServe) {
        this.classToServe = classToServe;
    }

    protected Logger getLogger() {
        return this.log;
    }
}

