/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.configuration.impl;

import org.apache.ojb.broker.core.PBPoolConfiguration;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.MetadataConfiguration;
import org.apache.ojb.broker.util.configuration.impl.ConfigurationAbstractImpl;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;
import org.apache.ojb.odmg.OdmgConfiguration;
import org.apache.ojb.odmg.locking.AbstractLockStrategy;
import org.apache.ojb.odmg.locking.LockingConfiguration;

public class OjbConfiguration
extends ConfigurationAbstractImpl
implements LoggingConfiguration,
OdmgConfiguration,
LockingConfiguration,
PersistenceBrokerConfiguration,
PBPoolConfiguration,
MetadataConfiguration {
    private String repositoryFilename;
    private Class objectCacheClass;
    private String[] objectCacheFilter;
    private Class connectionFactoryClass;
    private Class loggerClass;
    private Class persistentFieldClass;
    private String loggerConfigFile;
    private Class persistenceBrokerClass;
    private Class collectionProxyClass;
    private int sqlInLimit;
    private int maxActive;
    private int maxIdle;
    private long maxWait;
    private long timeBetweenEvictionRunsMillis;
    private long minEvictableIdleTimeMillis;
    private byte whenExhaustedAction;
    private boolean useImplicitLocking;
    private boolean lockAssociationAsWrites;
    private Class oqlCollectionClass;
    private Class lockManagerClass;
    private Class lockMapClass;
    private boolean useSerializedRepository;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$ObjectCache;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactory;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockManagerDefaultImpl;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockManager;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$InMemoryLockMapImpl;
    static /* synthetic */ Class class$org$apache$ojb$odmg$locking$LockMap;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$logging$Logger;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$fieldaccess$PersistentField;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$PersistenceBroker;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DListImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$ManageableCollection;

    public boolean useSerializedRepository() {
        return this.useSerializedRepository;
    }

    public boolean lockAssociationAsWrites() {
        return this.lockAssociationAsWrites;
    }

    public String getRepositoryFilename() {
        return this.repositoryFilename;
    }

    public String getLoggerConfigFile() {
        return this.loggerConfigFile;
    }

    public String getLogLevel(String loggerName) {
        return this.getString(loggerName + ".LogLevel", this.getString("ROOT.LogLevel", "INFO"));
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public long getMaxWaitMillis() {
        return this.maxWait;
    }

    public long getTimeBetweenEvictionRunsMilli() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public long getMinEvictableIdleTimeMillis() {
        return this.minEvictableIdleTimeMillis;
    }

    public byte getWhenExhaustedAction() {
        return this.whenExhaustedAction;
    }

    public Class getObjectCacheClass() {
        return this.objectCacheClass;
    }

    public String[] getCacheFilters() {
        if (this.objectCacheFilter == null || this.objectCacheFilter.length == 0) {
            return null;
        }
        return this.objectCacheFilter;
    }

    public void setCacheFilters(String[] filters) {
        this.objectCacheFilter = filters;
    }

    public Class getConnectionFactoryClass() {
        return this.connectionFactoryClass;
    }

    public Class getLockManagerClass() {
        return this.lockManagerClass;
    }

    public Class getOqlCollectionClass() {
        return this.oqlCollectionClass;
    }

    public Class getLockMapClass() {
        return this.lockMapClass;
    }

    public Class getLoggerClass() {
        return this.loggerClass;
    }

    public Class getPersistentFieldClass() {
        return this.persistentFieldClass;
    }

    public Class getPersistenceBrokerClass() {
        return this.persistenceBrokerClass;
    }

    protected void load() {
        String fn = System.getProperty("OJB.properties", "OJB.properties");
        this.setFilename(fn);
        super.load();
        this.repositoryFilename = this.getString("repositoryFile", "repository.xml");
        this.objectCacheClass = this.getClass("ObjectCacheClass", class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl == null ? (class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl = OjbConfiguration.class$("org.apache.ojb.broker.cache.ObjectCacheDefaultImpl")) : class$org$apache$ojb$broker$cache$ObjectCacheDefaultImpl, class$org$apache$ojb$broker$cache$ObjectCache == null ? (class$org$apache$ojb$broker$cache$ObjectCache = OjbConfiguration.class$("org.apache.ojb.broker.cache.ObjectCache")) : class$org$apache$ojb$broker$cache$ObjectCache);
        this.objectCacheFilter = this.getStrings("ObjectCacheFilter", "", ",");
        this.connectionFactoryClass = this.getClass("ConnectionFactoryClass", class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl = OjbConfiguration.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryPooledImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl, class$org$apache$ojb$broker$accesslayer$ConnectionFactory == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactory = OjbConfiguration.class$("org.apache.ojb.broker.accesslayer.ConnectionFactory")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactory);
        this.lockManagerClass = this.getClass("LockManagerClass", class$org$apache$ojb$odmg$locking$LockManagerDefaultImpl == null ? (class$org$apache$ojb$odmg$locking$LockManagerDefaultImpl = OjbConfiguration.class$("org.apache.ojb.odmg.locking.LockManagerDefaultImpl")) : class$org$apache$ojb$odmg$locking$LockManagerDefaultImpl, class$org$apache$ojb$odmg$locking$LockManager == null ? (class$org$apache$ojb$odmg$locking$LockManager = OjbConfiguration.class$("org.apache.ojb.odmg.locking.LockManager")) : class$org$apache$ojb$odmg$locking$LockManager);
        this.lockMapClass = this.getClass("LockMapClass", class$org$apache$ojb$odmg$locking$InMemoryLockMapImpl == null ? (class$org$apache$ojb$odmg$locking$InMemoryLockMapImpl = OjbConfiguration.class$("org.apache.ojb.odmg.locking.InMemoryLockMapImpl")) : class$org$apache$ojb$odmg$locking$InMemoryLockMapImpl, class$org$apache$ojb$odmg$locking$LockMap == null ? (class$org$apache$ojb$odmg$locking$LockMap = OjbConfiguration.class$("org.apache.ojb.odmg.locking.LockMap")) : class$org$apache$ojb$odmg$locking$LockMap);
        this.loggerClass = this.getClass("LoggerClass", class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl == null ? (class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl = OjbConfiguration.class$("org.apache.ojb.broker.util.logging.PoorMansLoggerImpl")) : class$org$apache$ojb$broker$util$logging$PoorMansLoggerImpl, class$org$apache$ojb$broker$util$logging$Logger == null ? (class$org$apache$ojb$broker$util$logging$Logger = OjbConfiguration.class$("org.apache.ojb.broker.util.logging.Logger")) : class$org$apache$ojb$broker$util$logging$Logger);
        this.loggerConfigFile = this.getString("LoggerConfigFile", "");
        this.persistentFieldClass = this.getClass("PersistentFieldClass", class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl == null ? (class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl = OjbConfiguration.class$("org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldDirectAccessImpl")) : class$org$apache$ojb$broker$metadata$fieldaccess$PersistentFieldDirectAccessImpl, class$org$apache$ojb$broker$metadata$fieldaccess$PersistentField == null ? (class$org$apache$ojb$broker$metadata$fieldaccess$PersistentField = OjbConfiguration.class$("org.apache.ojb.broker.metadata.fieldaccess.PersistentField")) : class$org$apache$ojb$broker$metadata$fieldaccess$PersistentField);
        this.persistenceBrokerClass = this.getClass("PersistenceBrokerClass", class$org$apache$ojb$broker$core$PersistenceBrokerImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerImpl = OjbConfiguration.class$("org.apache.ojb.broker.core.PersistenceBrokerImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerImpl, class$org$apache$ojb$broker$PersistenceBroker == null ? (class$org$apache$ojb$broker$PersistenceBroker = OjbConfiguration.class$("org.apache.ojb.broker.PersistenceBroker")) : class$org$apache$ojb$broker$PersistenceBroker);
        this.collectionProxyClass = this.getClass("CollectionProxyClass", null);
        AbstractLockStrategy.DEFAULT_LOCK_TIMEOUT = this.getInteger("LockTimeout", 60000);
        this.useImplicitLocking = this.getBoolean("ImplicitLocking", false);
        this.lockAssociationAsWrites = this.getString("LockAssociations", "WRITE").equalsIgnoreCase("WRITE");
        this.oqlCollectionClass = this.getClass("OqlCollectionClass", class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = OjbConfiguration.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl, class$org$apache$ojb$broker$ManageableCollection == null ? (class$org$apache$ojb$broker$ManageableCollection = OjbConfiguration.class$("org.apache.ojb.broker.ManageableCollection")) : class$org$apache$ojb$broker$ManageableCollection);
        this.sqlInLimit = this.getInteger("SqlInLimit", -1);
        this.maxActive = this.getInteger("maxActive", 21);
        this.maxIdle = this.getInteger("maxIdle", -1);
        this.maxWait = this.getLong("maxWait", 5000L);
        this.timeBetweenEvictionRunsMillis = this.getLong("timeBetweenEvictionRunsMillis", -1L);
        this.minEvictableIdleTimeMillis = this.getLong("minEvictableIdleTimeMillis", 600000L);
        this.whenExhaustedAction = this.getByte("whenExhaustedAction", (byte)0);
        this.useSerializedRepository = this.getBoolean("useSerializedRepository", false);
    }

    public int getSqlInLimit() {
        return this.sqlInLimit;
    }

    public void setPersistentFieldClass(Class persistentFieldClass) {
        this.persistentFieldClass = persistentFieldClass;
    }

    public boolean useImplicitLocking() {
        return this.useImplicitLocking;
    }

    public void setUseImplicitLocking(boolean implicitLocking) {
        this.useImplicitLocking = implicitLocking;
    }

    public Class getCollectionProxyClass() {
        return this.collectionProxyClass;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

