/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.batch;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.util.WrappedConnection;
import org.apache.ojb.broker.util.batch.BatchPreparedStatement;
import org.apache.ojb.broker.util.batch.PreparedStatementInvocationHandler;

public class BatchConnection
extends WrappedConnection {
    private static final int MAX_COUNT = 100;
    private static HashMap _pbkeyToFKInfo = new HashMap();
    private boolean _useBatchInserts = true;
    private HashMap _statements = new HashMap();
    private ArrayList _order = new ArrayList();
    private HashMap _fkInfo;
    private HashSet _deleted;
    private HashSet _dontInsert;
    private HashSet _touched = new HashSet();
    private int count = 0;
    private JdbcConnectionDescriptor m_jcd;
    static /* synthetic */ Class class$java$sql$PreparedStatement;
    static /* synthetic */ Class class$java$sql$Statement;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$batch$BatchPreparedStatement;

    public BatchConnection(Connection conn, PersistenceBroker broker) {
        super(conn);
        this.m_jcd = broker.serviceConnectionManager().getConnectionDescriptor();
        this._fkInfo = (HashMap)_pbkeyToFKInfo.get(broker.getPBKey());
        if (this._fkInfo != null) {
            return;
        }
        DescriptorRepository repos = broker.getDescriptorRepository();
        this._fkInfo = new HashMap();
        Iterator it = repos.iterator();
        while (it.hasNext()) {
            Iterator it2;
            ClassDescriptor desc = (ClassDescriptor)it.next();
            Vector ordList = desc.getObjectReferenceDescriptors();
            if (!ordList.isEmpty()) {
                HashSet fkTables = this.getFKTablesFor(desc.getFullTableName());
                it2 = ordList.iterator();
                while (it2.hasNext()) {
                    ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)it2.next();
                    ClassDescriptor oneDesc = repos.getDescriptorFor(ord.getItemClass());
                    fkTables.addAll(this.getFullTableNames(oneDesc, repos));
                }
            }
            Vector codList = desc.getCollectionDescriptors();
            it2 = codList.iterator();
            while (it2.hasNext()) {
                CollectionDescriptor cod = (CollectionDescriptor)it2.next();
                ClassDescriptor manyDesc = repos.getDescriptorFor(cod.getItemClass());
                if (cod.isMtoNRelation()) {
                    HashSet fkTables = this.getFKTablesFor(cod.getIndirectionTable());
                    fkTables.addAll(this.getFullTableNames(desc, repos));
                    fkTables.addAll(this.getFullTableNames(manyDesc, repos));
                    continue;
                }
                HashSet manyTableNames = this.getFullTableNames(manyDesc, repos);
                Iterator it3 = manyTableNames.iterator();
                while (it3.hasNext()) {
                    HashSet fkTables = this.getFKTablesFor((String)it3.next());
                    fkTables.addAll(this.getFullTableNames(desc, repos));
                }
            }
        }
        _pbkeyToFKInfo.put(broker.getPBKey(), this._fkInfo);
    }

    private HashSet getFKTablesFor(String tableName) {
        HashSet fkTables = (HashSet)this._fkInfo.get(tableName);
        if (fkTables == null) {
            fkTables = new HashSet();
            this._fkInfo.put(tableName, fkTables);
        }
        return fkTables;
    }

    private HashSet getFullTableNames(ClassDescriptor desc, DescriptorRepository repos) {
        HashSet<String> tableNamesSet = new HashSet<String>();
        Vector extents = desc.getExtentClasses();
        String tableName = desc.getFullTableName();
        if (tableName != null) {
            tableNamesSet.add(tableName);
        }
        Iterator it = extents.iterator();
        while (it.hasNext()) {
            Class extClass = (Class)it.next();
            ClassDescriptor extDesc = repos.getDescriptorFor(extClass);
            tableName = extDesc.getFullTableName();
            if (tableName == null) continue;
            tableNamesSet.add(tableName);
        }
        return tableNamesSet;
    }

    public void setUseBatchInserts(boolean useBatchInserts) {
        this._useBatchInserts = useBatchInserts;
    }

    void nextExecuted(String sql) throws SQLException {
        ++this.count;
        if (this._order.contains(sql)) {
            return;
        }
        String sqlCmd = sql.substring(0, 7);
        String rest = sql.substring(sqlCmd.equals("UPDATE ") ? 7 : 12);
        String tableName = rest.substring(0, rest.indexOf(32));
        HashSet fkTables = (HashSet)this._fkInfo.get(tableName);
        if (this._touched.contains(tableName)) {
            this.executeBatch();
        }
        if (sqlCmd.equals("INSERT ")) {
            if (this._dontInsert != null && this._dontInsert.contains(tableName)) {
                this.executeBatch();
            }
        } else if (this._deleted != null && fkTables != null) {
            HashSet intersection = (HashSet)this._deleted.clone();
            intersection.retainAll(fkTables);
            if (!intersection.isEmpty()) {
                this.executeBatch();
            }
        }
        this._order.add(sql);
        this._touched.add(tableName);
        if (sqlCmd.equals("INSERT ")) {
            if (fkTables != null) {
                if (this._dontInsert == null) {
                    this._dontInsert = new HashSet();
                }
                this._dontInsert.addAll(fkTables);
            }
        } else if (sqlCmd.equals("DELETE ")) {
            if (this._deleted == null) {
                this._deleted = new HashSet();
            }
            this._deleted.add(tableName);
        }
    }

    private PreparedStatement prepareBatchStatement(String sql) throws PlatformException {
        String sqlCmd = sql.substring(0, 7);
        if (sqlCmd.equals("UPDATE ") || sqlCmd.equals("DELETE ") || this._useBatchInserts && sqlCmd.equals("INSERT ")) {
            PreparedStatement stmt = (PreparedStatement)this._statements.get(sql);
            if (stmt == null) {
                stmt = (PreparedStatement)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{class$java$sql$PreparedStatement == null ? (class$java$sql$PreparedStatement = BatchConnection.class$("java.sql.PreparedStatement")) : class$java$sql$PreparedStatement, class$java$sql$Statement == null ? (class$java$sql$Statement = BatchConnection.class$("java.sql.Statement")) : class$java$sql$Statement, class$org$apache$ojb$broker$util$batch$BatchPreparedStatement == null ? (class$org$apache$ojb$broker$util$batch$BatchPreparedStatement = BatchConnection.class$("org.apache.ojb.broker.util.batch.BatchPreparedStatement")) : class$org$apache$ojb$broker$util$batch$BatchPreparedStatement}, (InvocationHandler)new PreparedStatementInvocationHandler(this, sql, this.m_jcd));
                this._statements.put(sql, stmt);
            }
            return stmt;
        }
        return null;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareBatchStatement(sql);
        }
        catch (PlatformException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e.getMessage());
        }
        if (stmt == null) {
            stmt = this.getDelegate().prepareStatement(sql);
        }
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareBatchStatement(sql);
        }
        catch (PlatformException e) {
            if (e.getCause() instanceof SQLException) {
                throw (SQLException)e.getCause();
            }
            throw new SQLException(e.getMessage());
        }
        if (stmt == null) {
            stmt = this.getDelegate().prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        return stmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeBatch() throws SQLException {
        Connection conn = this.getDelegate();
        try {
            Iterator it = this._order.iterator();
            while (it.hasNext()) {
                BatchPreparedStatement batchStmt = (BatchPreparedStatement)this._statements.get(it.next());
                batchStmt.doExecute(conn);
            }
            Object var5_4 = null;
            this._order.clear();
            if (this._dontInsert != null) {
                this._dontInsert.clear();
            }
            if (this._deleted != null) {
                this._deleted.clear();
            }
            this._touched.clear();
            this.count = 0;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this._order.clear();
            if (this._dontInsert != null) {
                this._dontInsert.clear();
            }
            if (this._deleted != null) {
                this._deleted.clear();
            }
            this._touched.clear();
            this.count = 0;
            throw throwable;
        }
    }

    public void executeBatchIfNecessary() throws SQLException {
        if (this.count >= 100) {
            this.executeBatch();
        }
    }

    public void clearBatch() {
        this._order.clear();
        this._statements.clear();
        if (this._dontInsert != null) {
            this._dontInsert.clear();
        }
        if (this._deleted != null) {
            this._deleted.clear();
        }
    }

    public void commit() throws SQLException {
        this.executeBatch();
        this._statements.clear();
        this.getDelegate().commit();
    }

    public void rollback() throws SQLException {
        this.clearBatch();
        this.getDelegate().rollback();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

