/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Proxy;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ProxyHelper {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$ProxyHelper == null ? (class$org$apache$ojb$broker$util$ProxyHelper = ProxyHelper.class$("org.apache.ojb.broker.util.ProxyHelper")) : class$org$apache$ojb$broker$util$ProxyHelper);
    private static final Constructor listProxyConstructor;
    private static final Constructor setProxyConstructor;
    private static final Constructor collectionProxyConstructor;
    private static Constructor collectionProxyConstructorUserDefined;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$ProxyHelper;
    static /* synthetic */ Class class$org$apache$ojb$broker$PBKey;
    static /* synthetic */ Class class$java$lang$Class;
    static /* synthetic */ Class class$org$apache$ojb$broker$query$Query;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ListProxy;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$SetProxy;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$CollectionProxy;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$IndirectionHandler;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$java$util$Set;

    public static final Object getRealObject(Object objectOrProxy) {
        if (ProxyHelper.isNormalOjbProxy(objectOrProxy)) {
            try {
                return ((IndirectionHandler)Proxy.getInvocationHandler(objectOrProxy)).getRealSubject();
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$accesslayer$IndirectionHandler == null ? (class$org$apache$ojb$broker$accesslayer$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.IndirectionHandler")) : class$org$apache$ojb$broker$accesslayer$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for given Proxy: " + objectOrProxy);
                throw e;
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(objectOrProxy)) {
            try {
                return ((VirtualProxy)objectOrProxy).getRealSubject();
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for VirtualProxy: " + objectOrProxy);
                throw e;
            }
        }
        return objectOrProxy;
    }

    public static final Object getRealObjectIfMaterialized(Object objectOrProxy) {
        if (ProxyHelper.isNormalOjbProxy(objectOrProxy)) {
            try {
                IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(objectOrProxy);
                return handler.alreadyMaterialized() ? handler.getRealSubject() : null;
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$accesslayer$IndirectionHandler == null ? (class$org$apache$ojb$broker$accesslayer$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.IndirectionHandler")) : class$org$apache$ojb$broker$accesslayer$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for given Proxy: " + objectOrProxy);
                throw e;
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(objectOrProxy)) {
            try {
                VirtualProxy proxy = (VirtualProxy)objectOrProxy;
                return proxy.alreadyMaterialized() ? proxy.getRealSubject() : null;
            }
            catch (PersistenceBrokerException e) {
                log.error("Could not retrieve real object for VirtualProxy: " + objectOrProxy);
                throw e;
            }
        }
        return objectOrProxy;
    }

    public static final Class getRealClass(Object objectOrProxy) {
        if (ProxyHelper.isNormalOjbProxy(objectOrProxy)) {
            try {
                IndirectionHandler handler = (IndirectionHandler)Proxy.getInvocationHandler(objectOrProxy);
                return handler.getIdentity().getObjectsRealClass();
            }
            catch (ClassCastException e) {
                String msg = "The InvocationHandler for the provided Proxy was not an instance of " + (class$org$apache$ojb$broker$accesslayer$IndirectionHandler == null ? (class$org$apache$ojb$broker$accesslayer$IndirectionHandler = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.IndirectionHandler")) : class$org$apache$ojb$broker$accesslayer$IndirectionHandler).getName();
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not retrieve real object for given Proxy: " + objectOrProxy;
                log.error(msg);
                throw new PersistenceBrokerException(msg, e);
            }
        }
        if (ProxyHelper.isVirtualOjbProxy(objectOrProxy)) {
            IndirectionHandler handler = VirtualProxy.getIndirectionHandler((VirtualProxy)objectOrProxy);
            return handler.getIdentity().getObjectsRealClass();
        }
        return objectOrProxy.getClass();
    }

    public static final ManageableCollection createCollectionProxy(PersistenceBroker broker, Query query, Class collectionClass) {
        Object[] param = new Object[]{broker.getPBKey(), collectionClass, query};
        Constructor proxyConstructor = collectionProxyConstructorUserDefined;
        if (proxyConstructor == null) {
            proxyConstructor = ProxyHelper.getCollectionProxyConstructor(collectionClass);
        }
        try {
            return (ManageableCollection)proxyConstructor.newInstance(param);
        }
        catch (Throwable e) {
            throw new PersistenceBrokerException(e);
        }
    }

    private static Constructor getCollectionProxyConstructor(Class collectionClass) {
        if ((class$java$util$List == null ? (class$java$util$List = ProxyHelper.class$("java.util.List")) : class$java$util$List).isAssignableFrom(collectionClass)) {
            return listProxyConstructor;
        }
        if ((class$java$util$Set == null ? (class$java$util$Set = ProxyHelper.class$("java.util.Set")) : class$java$util$Set).isAssignableFrom(collectionClass)) {
            return setProxyConstructor;
        }
        return collectionProxyConstructor;
    }

    public static boolean isNormalOjbProxy(Object proxyOrObject) {
        return proxyOrObject instanceof Proxy && Proxy.isProxyClass(proxyOrObject.getClass()) && Proxy.getInvocationHandler(proxyOrObject) instanceof IndirectionHandler;
    }

    public static boolean isVirtualOjbProxy(Object proxyOrObject) {
        return proxyOrObject instanceof VirtualProxy;
    }

    public static boolean isProxy(Object proxyOrObject) {
        return ProxyHelper.isNormalOjbProxy(proxyOrObject) || ProxyHelper.isVirtualOjbProxy(proxyOrObject);
    }

    public static IndirectionHandler getIndirectionHandler(Object obj) {
        if (obj == null) {
            return null;
        }
        if (ProxyHelper.isNormalOjbProxy(obj)) {
            return (IndirectionHandler)Proxy.getInvocationHandler(obj);
        }
        if (ProxyHelper.isVirtualOjbProxy(obj)) {
            return VirtualProxy.getIndirectionHandler((VirtualProxy)obj);
        }
        return null;
    }

    public static boolean isMaterialized(Object object) {
        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(object);
        return handler == null ? true : handler.alreadyMaterialized();
    }

    public static String toString(Object object) {
        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(object);
        if (handler != null && handler.alreadyMaterialized()) {
            return "unmaterialized proxy for " + handler.getIdentity();
        }
        return object.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Class[] paramType = new Class[]{class$org$apache$ojb$broker$PBKey == null ? (class$org$apache$ojb$broker$PBKey = ProxyHelper.class$("org.apache.ojb.broker.PBKey")) : class$org$apache$ojb$broker$PBKey, class$java$lang$Class == null ? (class$java$lang$Class = ProxyHelper.class$("java.lang.Class")) : class$java$lang$Class, class$org$apache$ojb$broker$query$Query == null ? (class$org$apache$ojb$broker$query$Query = ProxyHelper.class$("org.apache.ojb.broker.query.Query")) : class$org$apache$ojb$broker$query$Query};
        try {
            listProxyConstructor = (class$org$apache$ojb$broker$accesslayer$ListProxy == null ? (class$org$apache$ojb$broker$accesslayer$ListProxy = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.ListProxy")) : class$org$apache$ojb$broker$accesslayer$ListProxy).getConstructor(paramType);
            setProxyConstructor = (class$org$apache$ojb$broker$accesslayer$SetProxy == null ? (class$org$apache$ojb$broker$accesslayer$SetProxy = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.SetProxy")) : class$org$apache$ojb$broker$accesslayer$SetProxy).getConstructor(paramType);
            collectionProxyConstructor = (class$org$apache$ojb$broker$accesslayer$CollectionProxy == null ? (class$org$apache$ojb$broker$accesslayer$CollectionProxy = ProxyHelper.class$("org.apache.ojb.broker.accesslayer.CollectionProxy")) : class$org$apache$ojb$broker$accesslayer$CollectionProxy).getConstructor(paramType);
        }
        catch (Throwable t) {
            throw new PersistenceBrokerException("Error accessing constructor for collection proxy class.", t);
        }
        Class collectionProxyClass = null;
        try {
            PersistenceBrokerConfiguration config = (PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null));
            collectionProxyClass = config.getCollectionProxyClass();
            if (collectionProxyClass != null) {
                collectionProxyConstructorUserDefined = collectionProxyClass.getConstructor(paramType);
            }
        }
        catch (Exception e) {
            throw new PersistenceBrokerException("Could not build constructor for collectionProxy class [" + collectionProxyClass + "] defined in configuration", e);
        }
    }
}

