/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;

public final class JdbcTypesHelper {
    private static Map jdbcObjectTypesFromType = new HashMap();
    private static Map jdbcObjectTypesFromName = new HashMap();
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$sql$Time;
    static /* synthetic */ Class class$java$sql$Timestamp;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$sql$Ref;
    static /* synthetic */ Class class$java$sql$Struct;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$sql$Types;

    public static JdbcType getJdbcTypeByTypesIndex(Integer type) {
        return (JdbcType)jdbcObjectTypesFromType.get(type);
    }

    public static JdbcType getJdbcTypeByName(String typeName) {
        JdbcType result = null;
        result = (JdbcType)jdbcObjectTypesFromName.get(typeName.toLowerCase());
        if (result == null) {
            throw new OJBRuntimeException("The type " + typeName + " can not be handled by OJB." + " Please specify only types as defined by java.sql.Types.");
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public static JdbcType getJdbcTypeByReflection(String fieldType) {
        void var1_1;
        JdbcType result;
        if (fieldType.equalsIgnoreCase((class$java$lang$Character == null ? (class$java$lang$Character = JdbcTypesHelper.class$("java.lang.Character")) : class$java$lang$Character).getName()) || fieldType.equalsIgnoreCase("char")) {
            result = JdbcTypesHelper.getJdbcTypeByName("char");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$Short == null ? (class$java$lang$Short = JdbcTypesHelper.class$("java.lang.Short")) : class$java$lang$Short).getName()) || fieldType.equalsIgnoreCase("short")) {
            result = JdbcTypesHelper.getJdbcTypeByName("smallint");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$Integer == null ? (class$java$lang$Integer = JdbcTypesHelper.class$("java.lang.Integer")) : class$java$lang$Integer).getName()) || fieldType.equalsIgnoreCase("int")) {
            result = JdbcTypesHelper.getJdbcTypeByName("integer");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$Long == null ? (class$java$lang$Long = JdbcTypesHelper.class$("java.lang.Long")) : class$java$lang$Long).getName()) || fieldType.equalsIgnoreCase("long")) {
            result = JdbcTypesHelper.getJdbcTypeByName("bigint");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$Byte == null ? (class$java$lang$Byte = JdbcTypesHelper.class$("java.lang.Byte")) : class$java$lang$Byte).getName()) || fieldType.equalsIgnoreCase("byte")) {
            result = JdbcTypesHelper.getJdbcTypeByName("tinyint");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$Float == null ? (class$java$lang$Float = JdbcTypesHelper.class$("java.lang.Float")) : class$java$lang$Float).getName()) || fieldType.equalsIgnoreCase("float")) {
            result = JdbcTypesHelper.getJdbcTypeByName("real");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$Double == null ? (class$java$lang$Double = JdbcTypesHelper.class$("java.lang.Double")) : class$java$lang$Double).getName()) || fieldType.equalsIgnoreCase("double")) {
            result = JdbcTypesHelper.getJdbcTypeByName("float");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$String == null ? (class$java$lang$String = JdbcTypesHelper.class$("java.lang.String")) : class$java$lang$String).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("varchar");
        } else if (fieldType.equalsIgnoreCase((class$java$util$Date == null ? (class$java$util$Date = JdbcTypesHelper.class$("java.util.Date")) : class$java$util$Date).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("date");
        } else if (fieldType.equalsIgnoreCase((class$java$sql$Date == null ? (class$java$sql$Date = JdbcTypesHelper.class$("java.sql.Date")) : class$java$sql$Date).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("date");
        } else if (fieldType.equalsIgnoreCase((class$java$sql$Time == null ? (class$java$sql$Time = JdbcTypesHelper.class$("java.sql.Time")) : class$java$sql$Time).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("time");
        } else if (fieldType.equalsIgnoreCase((class$java$sql$Timestamp == null ? (class$java$sql$Timestamp = JdbcTypesHelper.class$("java.sql.Timestamp")) : class$java$sql$Timestamp).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("timestamp");
        } else if (fieldType.equalsIgnoreCase((class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JdbcTypesHelper.class$("java.math.BigDecimal")) : class$java$math$BigDecimal).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("decimal");
        } else if (fieldType.equalsIgnoreCase((class$java$sql$Ref == null ? (class$java$sql$Ref = JdbcTypesHelper.class$("java.sql.Ref")) : class$java$sql$Ref).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("ref");
        } else if (fieldType.equalsIgnoreCase((class$java$sql$Struct == null ? (class$java$sql$Struct = JdbcTypesHelper.class$("java.sql.Struct")) : class$java$sql$Struct).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("struct");
        } else if (fieldType.equalsIgnoreCase((class$java$lang$Boolean == null ? (class$java$lang$Boolean = JdbcTypesHelper.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName()) || fieldType.equalsIgnoreCase("boolean")) {
            result = JdbcTypesHelper.getJdbcTypeByName("bit");
        } else if (fieldType.equalsIgnoreCase((class$java$net$URL == null ? (class$java$net$URL = JdbcTypesHelper.class$("java.net.URL")) : class$java$net$URL).getName())) {
            result = JdbcTypesHelper.getJdbcTypeByName("datalink");
        } else {
            throw new OJBRuntimeException("The type " + fieldType + " can not be handled by OJB automatically." + " Please specify a type as defined by java.sql.Types in your field-descriptor");
        }
        return var1_1;
    }

    public static Object getObjectFromColumn(ResultSet rs, Integer jdbcType, int columnId) throws SQLException {
        return JdbcTypesHelper.getObjectFromColumn(rs, null, jdbcType, null, columnId);
    }

    private static Object getObjectFromColumn(ResultSet rs, CallableStatement stmt, Integer jdbcType, String columnName, int columnId) throws SQLException {
        return JdbcTypesHelper.getJdbcTypeByTypesIndex(jdbcType).getObjectFromColumn(rs, stmt, columnName, columnId);
    }

    public static String getJdbcTypeAsString(int jdbcType) {
        Field[] fields = (class$java$sql$Types == null ? (class$java$sql$Types = JdbcTypesHelper.class$("java.sql.Types")) : class$java$sql$Types).getFields();
        for (int i = 0; i < fields.length; ++i) {
            try {
                Field field = fields[i];
                int temp = field.getInt(null);
                if (temp != jdbcType) continue;
                return field.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "UNKNOWN_TYPE";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        jdbcObjectTypesFromType.put(new Integer(2003), new T_Array());
        jdbcObjectTypesFromType.put(new Integer(-5), new T_BigInt());
        jdbcObjectTypesFromType.put(new Integer(-2), new T_Binary());
        jdbcObjectTypesFromType.put(new Integer(-7), new T_Bit());
        jdbcObjectTypesFromType.put(new Integer(2004), new T_Blob());
        jdbcObjectTypesFromType.put(new Integer(1), new T_Char());
        jdbcObjectTypesFromType.put(new Integer(2005), new T_Clob());
        jdbcObjectTypesFromType.put(new Integer(91), new T_Date());
        jdbcObjectTypesFromType.put(new Integer(3), new T_Decimal());
        jdbcObjectTypesFromType.put(new Integer(8), new T_Double());
        jdbcObjectTypesFromType.put(new Integer(6), new T_Float());
        jdbcObjectTypesFromType.put(new Integer(4), new T_Integer());
        jdbcObjectTypesFromType.put(new Integer(-4), new T_LongVarBinary());
        jdbcObjectTypesFromType.put(new Integer(-1), new T_LongVarChar());
        jdbcObjectTypesFromType.put(new Integer(2), new T_Numeric());
        jdbcObjectTypesFromType.put(new Integer(7), new T_Real());
        jdbcObjectTypesFromType.put(new Integer(2006), new T_Ref());
        jdbcObjectTypesFromType.put(new Integer(5), new T_SmallInt());
        jdbcObjectTypesFromType.put(new Integer(2002), new T_Struct());
        jdbcObjectTypesFromType.put(new Integer(92), new T_Time());
        jdbcObjectTypesFromType.put(new Integer(93), new T_Timestamp());
        jdbcObjectTypesFromType.put(new Integer(-6), new T_TinyInt());
        jdbcObjectTypesFromType.put(new Integer(-3), new T_VarBinary());
        jdbcObjectTypesFromType.put(new Integer(12), new T_Varchar());
        jdbcObjectTypesFromType.put(new Integer(16), new T_Boolean());
        jdbcObjectTypesFromType.put(new Integer(70), new T_Datalink());
        jdbcObjectTypesFromName.put("array", jdbcObjectTypesFromType.get(new Integer(2003)));
        jdbcObjectTypesFromName.put("bigint", jdbcObjectTypesFromType.get(new Integer(-5)));
        jdbcObjectTypesFromName.put("binary", jdbcObjectTypesFromType.get(new Integer(-2)));
        jdbcObjectTypesFromName.put("bit", jdbcObjectTypesFromType.get(new Integer(-7)));
        jdbcObjectTypesFromName.put("blob", jdbcObjectTypesFromType.get(new Integer(2004)));
        jdbcObjectTypesFromName.put("char", jdbcObjectTypesFromType.get(new Integer(1)));
        jdbcObjectTypesFromName.put("clob", jdbcObjectTypesFromType.get(new Integer(2005)));
        jdbcObjectTypesFromName.put("date", jdbcObjectTypesFromType.get(new Integer(91)));
        jdbcObjectTypesFromName.put("decimal", jdbcObjectTypesFromType.get(new Integer(3)));
        jdbcObjectTypesFromName.put("double", jdbcObjectTypesFromType.get(new Integer(8)));
        jdbcObjectTypesFromName.put("float", jdbcObjectTypesFromType.get(new Integer(6)));
        jdbcObjectTypesFromName.put("integer", jdbcObjectTypesFromType.get(new Integer(4)));
        jdbcObjectTypesFromName.put("longvarbinary", jdbcObjectTypesFromType.get(new Integer(-4)));
        jdbcObjectTypesFromName.put("longvarchar", jdbcObjectTypesFromType.get(new Integer(-1)));
        jdbcObjectTypesFromName.put("numeric", jdbcObjectTypesFromType.get(new Integer(2)));
        jdbcObjectTypesFromName.put("real", jdbcObjectTypesFromType.get(new Integer(7)));
        jdbcObjectTypesFromName.put("ref", jdbcObjectTypesFromType.get(new Integer(2006)));
        jdbcObjectTypesFromName.put("smallint", jdbcObjectTypesFromType.get(new Integer(5)));
        jdbcObjectTypesFromName.put("struct", jdbcObjectTypesFromType.get(new Integer(2002)));
        jdbcObjectTypesFromName.put("time", jdbcObjectTypesFromType.get(new Integer(92)));
        jdbcObjectTypesFromName.put("timestamp", jdbcObjectTypesFromType.get(new Integer(93)));
        jdbcObjectTypesFromName.put("tinyint", jdbcObjectTypesFromType.get(new Integer(-6)));
        jdbcObjectTypesFromName.put("varbinary", jdbcObjectTypesFromType.get(new Integer(-3)));
        jdbcObjectTypesFromName.put("varchar", jdbcObjectTypesFromType.get(new Integer(12)));
        jdbcObjectTypesFromName.put("boolean", jdbcObjectTypesFromType.get(new Integer(16)));
        jdbcObjectTypesFromName.put("datalink", jdbcObjectTypesFromType.get(new Integer(70)));
    }

    public static final class T_Datalink
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'DATALINK'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getURL(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getURL(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getURL(columnIndex);
        }

        public int getType() {
            return 70;
        }
    }

    public static final class T_Ref
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'REF'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getRef(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getRef(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getRef(columnIndex);
        }

        public int getType() {
            return 2006;
        }
    }

    public static final class T_Struct
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'STRUCT'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getObject(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getObject(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getObject(columnIndex);
        }

        public int getType() {
            return 2002;
        }
    }

    public static final class T_Array
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'ARRAY'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getArray(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getArray(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getArray(columnIndex);
        }

        public int getType() {
            return 2003;
        }
    }

    public static final class T_Blob
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BLOB'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            Blob aBlob = stmt.getBlob(columnIndex);
            return stmt.wasNull() ? null : aBlob.getBytes(1L, (int)aBlob.length());
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            Blob aBlob = rs.getBlob(columnName);
            return rs.wasNull() ? null : aBlob.getBytes(1L, (int)aBlob.length());
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            Blob aBlob = rs.getBlob(columnIndex);
            return rs.wasNull() ? null : aBlob.getBytes(1L, (int)aBlob.length());
        }

        public int getType() {
            return 2004;
        }
    }

    public static final class T_Clob
    extends BaseType {
        protected static final int BUFSZ = 32768;

        protected static String safeClobToString(Clob aClob) throws SQLException {
            long length = aClob.length();
            if (length == 0L) {
                return "";
            }
            StringBuffer sb = new StringBuffer();
            char[] buf = new char[32768];
            Reader stream = aClob.getCharacterStream();
            try {
                int numRead;
                while ((numRead = stream.read(buf)) != -1) {
                    sb.append(buf, 0, numRead);
                }
                stream.close();
            }
            catch (IOException e) {
                throw new SQLException(e.getLocalizedMessage());
            }
            return sb.toString();
        }

        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'CLOB'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            Clob aClob = stmt.getClob(columnIndex);
            return stmt.wasNull() ? null : T_Clob.safeClobToString(aClob);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            Clob aClob = rs.getClob(columnName);
            return rs.wasNull() ? null : T_Clob.safeClobToString(aClob);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            Clob aClob = rs.getClob(columnIndex);
            return rs.wasNull() ? null : T_Clob.safeClobToString(aClob);
        }

        public int getType() {
            return 2005;
        }
    }

    public static final class T_Timestamp
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Timestamp(identifier);
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getTimestamp(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getTimestamp(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getTimestamp(columnIndex);
        }

        public int getType() {
            return 93;
        }
    }

    public static final class T_Time
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Time(identifier);
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getTime(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getTime(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getTime(columnIndex);
        }

        public int getType() {
            return 92;
        }
    }

    public static final class T_Date
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Date(identifier);
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getDate(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getDate(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getDate(columnIndex);
        }

        public int getType() {
            return 91;
        }
    }

    public static final class T_LongVarBinary
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return identifier.toString().getBytes();
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getBytes(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getBytes(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBytes(columnIndex);
        }

        public int getType() {
            return -4;
        }
    }

    public static final class T_VarBinary
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return identifier.toString().getBytes();
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getBytes(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getBytes(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBytes(columnIndex);
        }

        public int getType() {
            return -3;
        }
    }

    public static final class T_Binary
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return identifier.toString().getBytes();
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getBytes(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getBytes(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBytes(columnIndex);
        }

        public int getType() {
            return -2;
        }
    }

    public static final class T_Double
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Double(identifier.doubleValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            double temp = stmt.getDouble(columnIndex);
            return stmt.wasNull() ? null : new Double(temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            double temp = rs.getDouble(columnName);
            return rs.wasNull() ? null : new Double(temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            double temp = rs.getDouble(columnIndex);
            return rs.wasNull() ? null : new Double(temp);
        }

        public int getType() {
            return 8;
        }
    }

    public static final class T_Float
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Double(identifier.doubleValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            double temp = stmt.getDouble(columnIndex);
            return stmt.wasNull() ? null : new Double(temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            double temp = rs.getDouble(columnName);
            return rs.wasNull() ? null : new Double(temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            double temp = rs.getDouble(columnIndex);
            return rs.wasNull() ? null : new Double(temp);
        }

        public int getType() {
            return 6;
        }
    }

    public static final class T_Real
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Float(identifier.floatValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            float temp = stmt.getFloat(columnIndex);
            return stmt.wasNull() ? null : new Float(temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            float temp = rs.getFloat(columnName);
            return rs.wasNull() ? null : new Float(temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            float temp = rs.getFloat(columnIndex);
            return rs.wasNull() ? null : new Float(temp);
        }

        public int getType() {
            return 7;
        }
    }

    public static final class T_BigInt
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return identifier;
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            long temp = stmt.getLong(columnIndex);
            return stmt.wasNull() ? null : new Long(temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            long temp = rs.getLong(columnName);
            return rs.wasNull() ? null : new Long(temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            long temp = rs.getLong(columnIndex);
            return rs.wasNull() ? null : new Long(temp);
        }

        public int getType() {
            return -5;
        }
    }

    public static final class T_Integer
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Integer(identifier.intValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            int temp = stmt.getInt(columnIndex);
            return stmt.wasNull() ? null : new Integer(temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            int temp = rs.getInt(columnName);
            return rs.wasNull() ? null : new Integer(temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            int temp = rs.getInt(columnIndex);
            return rs.wasNull() ? null : new Integer(temp);
        }

        public int getType() {
            return 4;
        }
    }

    public static final class T_SmallInt
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Short(identifier.shortValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            short temp = stmt.getShort(columnIndex);
            return stmt.wasNull() ? null : new Short(temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            short temp = rs.getShort(columnName);
            return rs.wasNull() ? null : new Short(temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            short temp = rs.getShort(columnIndex);
            return rs.wasNull() ? null : new Short(temp);
        }

        public int getType() {
            return 5;
        }
    }

    public static final class T_TinyInt
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new Byte(identifier.byteValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            byte temp = stmt.getByte(columnIndex);
            return stmt.wasNull() ? null : new Byte(temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            byte temp = rs.getByte(columnName);
            return rs.wasNull() ? null : new Byte(temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            byte temp = rs.getByte(columnIndex);
            return rs.wasNull() ? null : new Byte(temp);
        }

        public int getType() {
            return -6;
        }
    }

    public static final class T_Boolean
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BOOLEAN'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            boolean temp = stmt.getBoolean(columnIndex);
            return stmt.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            boolean temp = rs.getBoolean(columnName);
            return rs.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            boolean temp = rs.getBoolean(columnIndex);
            return rs.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)temp);
        }

        public int getType() {
            return 16;
        }
    }

    public static final class T_Bit
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            throw new SequenceManagerException("Not supported sequence key type 'BIT'");
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            boolean temp = stmt.getBoolean(columnIndex);
            return stmt.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)temp);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            boolean temp = rs.getBoolean(columnName);
            return rs.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)temp);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            boolean temp = rs.getBoolean(columnIndex);
            return rs.wasNull() ? null : BooleanUtils.toBooleanObject((boolean)temp);
        }

        public int getType() {
            return -7;
        }
    }

    public static final class T_Decimal
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new BigDecimal((double)identifier.longValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getBigDecimal(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getBigDecimal(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBigDecimal(columnIndex);
        }

        public int getType() {
            return 3;
        }
    }

    public static final class T_Numeric
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return new BigDecimal((double)identifier.longValue());
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getBigDecimal(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getBigDecimal(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getBigDecimal(columnIndex);
        }

        public int getType() {
            return 2;
        }
    }

    public static final class T_LongVarChar
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return identifier.toString();
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getString(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getString(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getString(columnIndex);
        }

        public int getType() {
            return -1;
        }
    }

    public static final class T_Varchar
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return identifier.toString();
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getString(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getString(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getString(columnIndex);
        }

        public int getType() {
            return 12;
        }
    }

    public static final class T_Char
    extends BaseType {
        public Object sequenceKeyConversion(Long identifier) throws SequenceManagerException {
            return identifier.toString();
        }

        Object readValueFromStatement(CallableStatement stmt, int columnIndex) throws SQLException {
            return stmt.getString(columnIndex);
        }

        Object readValueFromResultSet(ResultSet rs, String columnName) throws SQLException {
            return rs.getString(columnName);
        }

        Object readValueFromResultSet(ResultSet rs, int columnIndex) throws SQLException {
            return rs.getString(columnIndex);
        }

        public int getType() {
            return 1;
        }
    }

    public static abstract class BaseType
    implements JdbcType {
        abstract Object readValueFromResultSet(ResultSet var1, String var2) throws SQLException;

        abstract Object readValueFromResultSet(ResultSet var1, int var2) throws SQLException;

        abstract Object readValueFromStatement(CallableStatement var1, int var2) throws SQLException;

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            boolean result = false;
            if (obj instanceof JdbcType) {
                result = this.getType() == ((JdbcType)obj).getType();
            }
            return result;
        }

        public int hashCode() {
            return this.getType();
        }

        public Object getObjectFromColumn(CallableStatement stmt, int columnId) throws SQLException {
            return this.getObjectFromColumn(null, stmt, null, columnId);
        }

        public Object getObjectFromColumn(ResultSet rs, String columnName) throws SQLException {
            return this.getObjectFromColumn(rs, null, columnName, Integer.MIN_VALUE);
        }

        public Object getObjectFromColumn(ResultSet rs, CallableStatement stmt, String columnName, int columnIndex) throws SQLException {
            if (stmt != null) {
                if (columnIndex == Integer.MIN_VALUE) {
                    throw new UnsupportedOperationException("Not implemented yet");
                }
                return this.readValueFromStatement(stmt, columnIndex);
            }
            return columnIndex == Integer.MIN_VALUE ? this.readValueFromResultSet(rs, columnName) : this.readValueFromResultSet(rs, columnIndex);
        }

        public String toString() {
            return super.toString() + "[" + JdbcTypesHelper.getJdbcTypeAsString(this.getType()) + " JDBC TYPE]";
        }
    }
}

