/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.util.Map;
import org.apache.ojb.broker.util.IdentityHashMap;

public final class IdentityMapFactory {
    private static boolean HAS_JDK_IDENTITY_MAP = true;
    private static final String CLASS_NAME = "java.util.IdentityHashMap";
    private static Class JDK_IDENTITY_MAP;

    private IdentityMapFactory() {
    }

    public static Map getIdentityMap() {
        Map retval = null;
        if (HAS_JDK_IDENTITY_MAP) {
            try {
                retval = (Map)JDK_IDENTITY_MAP.newInstance();
            }
            catch (InstantiationException e) {
                HAS_JDK_IDENTITY_MAP = false;
            }
            catch (IllegalAccessException e) {
                HAS_JDK_IDENTITY_MAP = false;
            }
        }
        if (!HAS_JDK_IDENTITY_MAP) {
            retval = new IdentityHashMap();
        }
        return retval;
    }

    static {
        try {
            JDK_IDENTITY_MAP = Thread.currentThread().getContextClassLoader().loadClass(CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            HAS_JDK_IDENTITY_MAP = false;
        }
    }
}

