/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.lang.reflect.Constructor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;

public class ConstructorHelper {
    private static final Object[] NO_ARGS = new Object[0];

    private ConstructorHelper() {
    }

    public static Object instantiate(Class clazz) throws InstantiationException {
        Object result = null;
        try {
            result = clazz.newInstance();
        }
        catch (IllegalAccessException e) {
            Constructor constructor;
            Class[] params = new Class[]{};
            try {
                constructor = clazz.getDeclaredConstructor(params);
            }
            catch (NoSuchMethodException ex) {
                throw new ClassNotPersistenceCapableException(clazz.getName() + " does not provide a zero argument constructor!", ex);
            }
            constructor.setAccessible(true);
            Object[] args = new Object[]{};
            try {
                result = constructor.newInstance(args);
            }
            catch (Throwable t) {
                throw new ClassNotPersistenceCapableException("Could not instantiate " + clazz.getName() + ": " + t.getMessage() + ")", t);
            }
        }
        return result;
    }

    public static Object instantiate(Constructor constructor) throws InstantiationException {
        if (constructor == null) {
            throw new ClassNotPersistenceCapableException("A zero argument constructor was not provided!");
        }
        Object result = null;
        try {
            result = constructor.newInstance(NO_ARGS);
        }
        catch (Throwable t) {
            throw new ClassNotPersistenceCapableException("(Could not instantiate " + constructor.getDeclaringClass().getName() + ": " + t.getMessage() + ")", t);
        }
        return result;
    }
}

