/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class ClassHelper {
    public static Class getClass(String className, boolean initialize) throws ClassNotFoundException {
        return Class.forName(className, initialize, Thread.currentThread().getContextClassLoader());
    }

    public static Object newInstance(Class target) throws InstantiationException, IllegalAccessException {
        return target.newInstance();
    }

    public static Object newInstance(Class target, Class[] types, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return target.getConstructor(types).newInstance(args);
    }

    public static Method getMethod(Class clazz, String methodName, Class[] params) {
        Method method;
        try {
            method = clazz.getMethod(methodName, params);
        }
        catch (Exception ignore) {
            method = null;
        }
        return method;
    }

    public static Field getField(Class clazz, String fieldName) {
        Field field;
        try {
            field = clazz.getField(fieldName);
        }
        catch (Exception ignore) {
            field = null;
        }
        return field;
    }

    public static Class getClass(String name) throws ClassNotFoundException {
        return ClassHelper.getClass(name, true);
    }

    public static Object newInstance(String className) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return ClassHelper.newInstance(ClassHelper.getClass(className));
    }

    public static Object newInstance(String className, Class[] types, Object[] args) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        return ClassHelper.newInstance(ClassHelper.getClass(className), types, args);
    }

    public static Object newInstance(Class target, Class type, Object arg) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        return ClassHelper.newInstance(target, new Class[]{type}, new Object[]{arg});
    }

    public static Object newInstance(String className, Class type, Object arg) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException {
        return ClassHelper.newInstance(className, new Class[]{type}, new Object[]{arg});
    }

    public static Method getMethod(Object object, String methodName, Class[] params) {
        return ClassHelper.getMethod(object.getClass(), methodName, params);
    }

    public static Method getMethod(String className, String methodName, Class[] params) {
        Method method = null;
        try {
            Class clazz = ClassHelper.getClass(className, false);
            method = ClassHelper.getMethod(clazz, methodName, params);
        }
        catch (Exception ignore) {
            // empty catch block
        }
        return method;
    }
}

