/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.DBHandling;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.SQLExec;
import org.apache.tools.ant.types.FileSet;
import org.apache.torque.task.TorqueDataModelTask;
import org.apache.torque.task.TorqueSQLExec;
import org.apache.torque.task.TorqueSQLTask;

public class TorqueDBHandling
implements DBHandling {
    protected static final String TORQUE_PLATFORM_DB2 = "db2";
    protected static final String TORQUE_PLATFORM_HYPERSONIC = "hypersonic";
    protected static final String TORQUE_PLATFORM_INTERBASE = "interbase";
    protected static final String TORQUE_PLATFORM_MSSQL = "mssql";
    protected static final String TORQUE_PLATFORM_MYSQL = "mysql";
    protected static final String TORQUE_PLATFORM_ORACLE = "oracle";
    protected static final String TORQUE_PLATFORM_POSTGRESQL = "postgresql";
    protected static final String TORQUE_PLATFORM_SAPDB = "sapdb";
    protected static final String TORQUE_PLATFORM_SYBASE = "sybase";
    private static final String CREATION_SCRIPT_NAME = "create-db.sql";
    private static final String SQL_DB_MAP_NAME = "sqldb.map";
    private static HashMap _dbmsToTorqueDb = new HashMap();
    private JdbcConnectionDescriptor _jcd;
    private String _targetDatabase;
    private File _workDir;
    private HashMap _torqueSchemata = new HashMap();
    private byte[] _creationScript;
    private HashMap _initScripts = new HashMap();

    public void setConnection(JdbcConnectionDescriptor jcd) throws PlatformException {
        this._jcd = jcd;
        String targetDatabase = (String)_dbmsToTorqueDb.get(this._jcd.getDbms().toLowerCase());
        if (targetDatabase == null) {
            throw new PlatformException("Database " + this._jcd.getDbms() + " is not supported by torque");
        }
        if (!targetDatabase.equals(this._targetDatabase)) {
            this._targetDatabase = targetDatabase;
            this._creationScript = null;
            this._initScripts.clear();
        }
    }

    public JdbcConnectionDescriptor getConnection() {
        return this._jcd;
    }

    public String getTargetTorquePlatform() {
        return this._targetDatabase;
    }

    public void addDBDefinitionFiles(String srcDir, String listOfFilenames) throws IOException {
        StringTokenizer tokenizer = new StringTokenizer(listOfFilenames, ",");
        File dir = new File(srcDir);
        while (tokenizer.hasMoreTokens()) {
            String filename = tokenizer.nextToken().trim();
            if (filename.length() <= 0) continue;
            this._torqueSchemata.put("schema" + this._torqueSchemata.size() + ".xml", this.readTextCompressed(new File(dir, filename)));
        }
    }

    public void addDBDefinitionFile(InputStream schemaStream) throws IOException {
        this._torqueSchemata.put("schema" + this._torqueSchemata.size() + ".xml", this.readStreamCompressed(schemaStream));
    }

    private String writeSchemata(File dir) throws IOException {
        this.writeCompressedTexts(dir, this._torqueSchemata);
        StringBuffer includes = new StringBuffer();
        Iterator it = this._torqueSchemata.keySet().iterator();
        while (it.hasNext()) {
            includes.append((String)it.next());
            if (!it.hasNext()) continue;
            includes.append(",");
        }
        return includes.toString();
    }

    public void createCreationScript() throws PlatformException {
        Project project = new Project();
        TorqueDataModelTask modelTask = new TorqueDataModelTask();
        File tmpDir = null;
        File scriptFile = null;
        this._creationScript = null;
        try {
            tmpDir = new File(this.getWorkDir(), "schemas");
            tmpDir.mkdir();
            String includes = this.writeSchemata(tmpDir);
            scriptFile = new File(tmpDir, CREATION_SCRIPT_NAME);
            project.setBasedir(tmpDir.getAbsolutePath());
            modelTask.setProject(project);
            modelTask.setUseClasspath(true);
            modelTask.setControlTemplate("sql/db-init/Control.vm");
            modelTask.setOutputDirectory(tmpDir);
            modelTask.setOutputFile(CREATION_SCRIPT_NAME);
            modelTask.setTargetDatabase(this._targetDatabase);
            FileSet files = new FileSet();
            files.setDir(tmpDir);
            files.setIncludes(includes);
            modelTask.addFileset(files);
            modelTask.execute();
            this._creationScript = this.readTextCompressed(scriptFile);
            this.deleteDir(tmpDir);
        }
        catch (Exception ex) {
            if (tmpDir != null && tmpDir.exists()) {
                this.deleteDir(tmpDir);
            }
            throw new PlatformException(ex);
        }
    }

    public void createDB() throws PlatformException {
        if (this._creationScript == null) {
            this.createCreationScript();
        }
        Project project = new Project();
        TorqueDataModelTask modelTask = new TorqueDataModelTask();
        File tmpDir = null;
        File scriptFile = null;
        try {
            tmpDir = new File(this.getWorkDir(), "schemas");
            tmpDir.mkdir();
            scriptFile = new File(tmpDir, CREATION_SCRIPT_NAME);
            this.writeCompressedText(scriptFile, this._creationScript);
            project.setBasedir(tmpDir.getAbsolutePath());
            SQLExec sqlTask = new SQLExec();
            SQLExec.OnError onError = new SQLExec.OnError();
            onError.setValue("continue");
            sqlTask.setProject(project);
            sqlTask.setAutocommit(true);
            sqlTask.setDriver(this._jcd.getDriver());
            sqlTask.setOnerror(onError);
            sqlTask.setUserid(this._jcd.getUserName());
            sqlTask.setPassword(this._jcd.getPassWord() == null ? "" : this._jcd.getPassWord());
            sqlTask.setUrl(this.getDBCreationUrl());
            sqlTask.setSrc(scriptFile);
            sqlTask.execute();
            this.deleteDir(tmpDir);
        }
        catch (Exception ex) {
            if (tmpDir != null && tmpDir.exists()) {
                scriptFile.delete();
            }
            throw new PlatformException(ex);
        }
    }

    public void createInitScripts() throws PlatformException {
        Project project = new Project();
        TorqueSQLTask sqlTask = new TorqueSQLTask();
        File schemaDir = null;
        File sqlDir = null;
        this._initScripts.clear();
        try {
            File tmpDir = this.getWorkDir();
            schemaDir = new File(tmpDir, "schemas");
            sqlDir = new File(tmpDir, "sql");
            schemaDir.mkdir();
            sqlDir.mkdir();
            String includes = this.writeSchemata(schemaDir);
            File sqlDbMapFile = new File(sqlDir, SQL_DB_MAP_NAME);
            sqlDbMapFile.createNewFile();
            project.setBasedir(sqlDir.getAbsolutePath());
            sqlTask.setProject(project);
            sqlTask.setUseClasspath(true);
            sqlTask.setBasePathToDbProps("sql/base/");
            sqlTask.setControlTemplate("sql/base/Control.vm");
            sqlTask.setOutputDirectory(sqlDir);
            sqlTask.setOutputFile("../report.sql.generation");
            sqlTask.setSqlDbMap(SQL_DB_MAP_NAME);
            sqlTask.setTargetDatabase(this._targetDatabase);
            FileSet files = new FileSet();
            files.setDir(schemaDir);
            files.setIncludes(includes);
            sqlTask.addFileset(files);
            sqlTask.execute();
            this.readTextsCompressed(sqlDir, this._initScripts);
            this.deleteDir(schemaDir);
            this.deleteDir(sqlDir);
        }
        catch (Exception ex) {
            if (schemaDir != null && schemaDir.exists()) {
                this.deleteDir(schemaDir);
            }
            if (sqlDir != null && sqlDir.exists()) {
                this.deleteDir(sqlDir);
            }
            throw new PlatformException(ex);
        }
    }

    public void initDB() throws PlatformException {
        if (this._initScripts.isEmpty()) {
            this.createInitScripts();
        }
        Project project = new Project();
        TorqueSQLTask sqlTask = new TorqueSQLTask();
        File outputDir = null;
        try {
            outputDir = new File(this.getWorkDir(), "sql");
            outputDir.mkdir();
            this.writeCompressedTexts(outputDir, this._initScripts);
            project.setBasedir(outputDir.getAbsolutePath());
            TorqueSQLExec sqlExec = new TorqueSQLExec();
            TorqueSQLExec.OnError onError = new TorqueSQLExec.OnError();
            sqlExec.setProject(project);
            onError.setValue("continue");
            sqlExec.setAutocommit(true);
            sqlExec.setDriver(this._jcd.getDriver());
            sqlExec.setOnerror(onError);
            sqlExec.setUserid(this._jcd.getUserName());
            sqlExec.setPassword(this._jcd.getPassWord() == null ? "" : this._jcd.getPassWord());
            sqlExec.setUrl(this.getDBManipulationUrl());
            sqlExec.setSrcDir(outputDir.getAbsolutePath());
            sqlExec.setSqlDbMap(SQL_DB_MAP_NAME);
            sqlExec.execute();
            this.deleteDir(outputDir);
        }
        catch (Exception ex) {
            if (outputDir != null) {
                this.deleteDir(outputDir);
            }
            throw new PlatformException(ex);
        }
    }

    protected String getDBCreationUrl() {
        JdbcConnectionDescriptor jcd = this.getConnection();
        if (TORQUE_PLATFORM_MYSQL.equals(this.getTargetTorquePlatform())) {
            int slashPos;
            String dbAliasPrefix = jcd.getDbAlias();
            String dbAliasSuffix = "";
            int questionPos = dbAliasPrefix.indexOf(63);
            if (questionPos > 0) {
                dbAliasSuffix = dbAliasPrefix.substring(questionPos);
                dbAliasPrefix = dbAliasPrefix.substring(0, questionPos);
            }
            if ((slashPos = dbAliasPrefix.lastIndexOf(47)) > 0) {
                dbAliasPrefix = dbAliasPrefix.substring(0, slashPos + 1);
            }
            return jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + dbAliasPrefix + dbAliasSuffix;
        }
        if (TORQUE_PLATFORM_POSTGRESQL.equals(this.getTargetTorquePlatform())) {
            int slashPos;
            String dbAliasPrefix = jcd.getDbAlias();
            String dbAliasSuffix = "";
            int questionPos = dbAliasPrefix.indexOf(63);
            if (questionPos > 0) {
                dbAliasSuffix = dbAliasPrefix.substring(questionPos);
                dbAliasPrefix = dbAliasPrefix.substring(0, questionPos);
            }
            dbAliasPrefix = (slashPos = dbAliasPrefix.lastIndexOf(47)) > 0 ? dbAliasPrefix.substring(0, slashPos + 1) : dbAliasPrefix + "/";
            dbAliasPrefix = dbAliasPrefix + "template1";
            if (dbAliasSuffix.length() > 0) {
                dbAliasPrefix = dbAliasPrefix + "/";
            }
            return jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + dbAliasPrefix + dbAliasSuffix;
        }
        return jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + jcd.getDbAlias();
    }

    protected String getDBManipulationUrl() {
        JdbcConnectionDescriptor jcd = this.getConnection();
        return jcd.getProtocol() + ":" + jcd.getSubProtocol() + ":" + jcd.getDbAlias();
    }

    private byte[] readTextCompressed(File file) throws IOException {
        return this.readStreamCompressed(new FileInputStream(file));
    }

    private byte[] readStreamCompressed(InputStream stream) throws IOException {
        String line;
        ByteArrayOutputStream bao = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(bao);
        OutputStreamWriter output = new OutputStreamWriter(gos);
        BufferedReader input = new BufferedReader(new InputStreamReader(stream));
        while ((line = input.readLine()) != null) {
            output.write(line);
            output.write(10);
        }
        input.close();
        stream.close();
        output.close();
        gos.close();
        bao.close();
        return bao.toByteArray();
    }

    private void readTextsCompressed(File dir, HashMap results) throws IOException {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                if (files[idx].isDirectory()) continue;
                results.put(files[idx].getName(), this.readTextCompressed(files[idx]));
            }
        }
    }

    private void writeCompressedText(File file, byte[] compressedContent) throws IOException {
        String line;
        ByteArrayInputStream bais = new ByteArrayInputStream(compressedContent);
        GZIPInputStream gis = new GZIPInputStream(bais);
        BufferedReader input = new BufferedReader(new InputStreamReader(gis));
        BufferedWriter output = new BufferedWriter(new FileWriter(file));
        while ((line = input.readLine()) != null) {
            output.write(line);
            output.write(10);
        }
        input.close();
        gis.close();
        bais.close();
        output.close();
    }

    private void writeCompressedTexts(File dir, HashMap contents) throws IOException {
        Iterator nameIt = contents.keySet().iterator();
        while (nameIt.hasNext()) {
            String filename = (String)nameIt.next();
            this.writeCompressedText(new File(dir, filename), (byte[])contents.get(filename));
        }
    }

    public void setWorkDir(String dir) throws IOException {
        File workDir = new File(dir);
        if (!(workDir.exists() && workDir.canWrite() && workDir.canRead())) {
            throw new IOException("Cannot access directory " + dir);
        }
        this._workDir = workDir;
    }

    private File getWorkDir() throws IOException {
        if (this._workDir == null) {
            File dummy = File.createTempFile("dummy", ".log");
            String workDir = dummy.getPath().substring(0, dummy.getPath().lastIndexOf(File.separatorChar));
            if (workDir == null || workDir.length() == 0) {
                workDir = ".";
            }
            dummy.delete();
            this._workDir = new File(workDir);
        }
        return this._workDir;
    }

    private void deleteDir(File dir) {
        if (dir.exists() && dir.isDirectory()) {
            File[] files = dir.listFiles();
            for (int idx = 0; idx < files.length; ++idx) {
                if (!files[idx].exists()) continue;
                if (files[idx].isDirectory()) {
                    this.deleteDir(files[idx]);
                    continue;
                }
                files[idx].delete();
            }
            dir.delete();
        }
    }

    static {
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_DB2, TORQUE_PLATFORM_DB2);
        _dbmsToTorqueDb.put("hsqldb", TORQUE_PLATFORM_HYPERSONIC);
        _dbmsToTorqueDb.put("firebird", TORQUE_PLATFORM_INTERBASE);
        _dbmsToTorqueDb.put("mssqlserver", TORQUE_PLATFORM_MSSQL);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_MYSQL, TORQUE_PLATFORM_MYSQL);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_ORACLE, TORQUE_PLATFORM_ORACLE);
        _dbmsToTorqueDb.put("oracle9i", TORQUE_PLATFORM_ORACLE);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_POSTGRESQL, TORQUE_PLATFORM_POSTGRESQL);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_SAPDB, TORQUE_PLATFORM_SAPDB);
        _dbmsToTorqueDb.put("sybaseasa", TORQUE_PLATFORM_SYBASE);
        _dbmsToTorqueDb.put("sybasease", TORQUE_PLATFORM_SYBASE);
        _dbmsToTorqueDb.put(TORQUE_PLATFORM_SYBASE, TORQUE_PLATFORM_SYBASE);
    }
}

