/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.AbstractPersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PersistentFieldIntrospectorImpl
extends AbstractPersistentField {
    private static final long serialVersionUID = 8805309492150404444L;
    private transient PropertyDescriptor propertyDescriptor;

    public PersistentFieldIntrospectorImpl() {
    }

    public PersistentFieldIntrospectorImpl(Class aClass, String aPropertyName) {
        super(aClass, aPropertyName);
    }

    public String getName() {
        return this.fieldName;
    }

    public Class getType() {
        return this.getPropertyDescriptor().getPropertyType();
    }

    public Class getDeclaringClass() {
        return this.rootObjectType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doSet(Object anObject, Object aValue) throws MetadataException {
        Method m = this.getPropertyDescriptor().getWriteMethod();
        Object[] args = new Object[]{aValue};
        if (m != null) {
            try {
                if (aValue == null && m.getParameterTypes()[0].isPrimitive()) return;
                m.invoke(anObject, args);
                return;
            }
            catch (Throwable e) {
                this.logProblem(anObject, aValue, e.getClass().getName());
                throw new MetadataException("Error invoking method:" + m.getName() + " in object:" + anObject.getClass().getName(), e);
            }
        } else {
            this.logProblem(anObject, aValue, "set: getWriteMethod returned null");
            throw new MetadataException("Can't get WriteMethod for property:" + this.getPropertyDescriptor().getName() + " in object:" + anObject.getClass().getName());
        }
    }

    public Object doGet(Object anObject) throws MetadataException {
        Method m = this.getPropertyDescriptor().getReadMethod();
        Object[] args = null;
        if (m != null) {
            try {
                Object result = m.invoke(anObject, args);
                return result;
            }
            catch (Throwable e) {
                this.logProblem(anObject, null, e.getClass().getName());
                throw new MetadataException("Error invoking method:" + m.getName() + " in object:" + anObject.getClass().getName(), e);
            }
        }
        this.logProblem(anObject, null, "get: getReadMethod returned null");
        throw new MetadataException("Can't get ReadMethod for property:" + this.getPropertyDescriptor().getName() + " in object:" + anObject.getClass().getName());
    }

    protected static PropertyDescriptor findPropertyDescriptor(Class aClass, String aPropertyName) {
        PropertyDescriptor descriptor = null;
        try {
            BeanInfo info = Introspector.getBeanInfo(aClass);
            PropertyDescriptor[] pd = info.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                if (!pd[i].getName().equals(aPropertyName)) continue;
                descriptor = pd[i];
                break;
            }
            if (descriptor == null) {
                throw new MetadataException("Can't find property " + aPropertyName + " in " + aClass.getName());
            }
            return descriptor;
        }
        catch (IntrospectionException ex) {
            throw new MetadataException("Can't find property " + aPropertyName + " in " + aClass.getName(), ex);
        }
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        if (this.propertyDescriptor == null) {
            this.setPropertyDescriptor(PersistentFieldIntrospectorImpl.findPropertyDescriptor(this.getDeclaringClass(), this.getName()));
        }
        return this.propertyDescriptor;
    }

    protected void setPropertyDescriptor(PropertyDescriptor newPropertyDescriptor) {
        this.propertyDescriptor = newPropertyDescriptor;
    }

    public boolean makeAccessible() {
        return false;
    }

    public boolean usesAccessorsAndMutators() {
        return true;
    }

    protected void logProblem(Object anObject, Object aValue, String msg) {
        Logger logger = LoggerFactory.getDefaultLogger();
        logger.error("Error in [PersistentFieldPropertyImpl], " + msg);
        logger.error("Declaring class [" + this.getDeclaringClass().getName() + "]");
        logger.error("Property Name [" + this.getName() + "]");
        logger.error("Property Type [" + this.getPropertyDescriptor().getPropertyType().getName() + "]");
        if (anObject != null) {
            logger.error("anObject was class [" + anObject.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
        if (aValue != null) {
            logger.error("aValue was class [" + aValue.getClass().getName() + "]");
        } else {
            logger.error("aValue was null");
        }
    }
}

