/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.lang.reflect.Field;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.ojb.broker.metadata.AnonymousFieldDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.AnonymousPersistentFieldForInheritance;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;

public class AnonymousPersistentFieldHelper {
    static /* synthetic */ Class class$java$lang$Object;

    public static Field getFieldIterative(Class c, String fieldname) {
        Field f = null;
        Class clazz = c;
        while (true) {
            try {
                f = clazz.getDeclaredField(fieldname);
            }
            catch (NoSuchFieldException e) {
                if ((clazz = clazz.getSuperclass()) != (class$java$lang$Object == null ? AnonymousPersistentFieldHelper.class$("java.lang.Object") : class$java$lang$Object)) continue;
            }
            break;
        }
        return f;
    }

    public static Vector getPkFieldNames(ClassDescriptor cld) {
        FieldDescriptor[] pks = cld.getPkFields();
        Vector<String> v = new Vector<String>(pks.length);
        for (int i = pks.length - 1; i >= 0; --i) {
            v.add(pks[i].getPersistentField().getName());
        }
        return v;
    }

    public static void computeInheritedPersistentFields(DescriptorRepository repository) {
        Map descriptorTable = repository.getDescriptorTable();
        String OBJECT = (class$java$lang$Object == null ? (class$java$lang$Object = AnonymousPersistentFieldHelper.class$("java.lang.Object")) : class$java$lang$Object).getName();
        Iterator iter = descriptorTable.keySet().iterator();
        while (iter.hasNext()) {
            ClassDescriptor tempCld;
            String key = (String)iter.next();
            ClassDescriptor cld = (ClassDescriptor)descriptorTable.get(key);
            String baseClass = cld.getBaseClass();
            if (null == baseClass) continue;
            Vector<PersistentField> v = new Vector<PersistentField>();
            do {
                tempCld = repository.getDescriptorFor(baseClass);
                FieldDescriptor[] fields = tempCld.getFieldDescriptions();
                Vector pkFields = AnonymousPersistentFieldHelper.getPkFieldNames(tempCld);
                for (int i = fields.length - 1; i >= 0; --i) {
                    PersistentField pf;
                    FieldDescriptor f = fields[i];
                    if (f instanceof AnonymousFieldDescriptor || pkFields.contains((pf = f.getPersistentField()).getName())) continue;
                    v.add(f.getPersistentField());
                }
                Vector ords = tempCld.getObjectReferenceDescriptors();
                for (int i = ords.size() - 1; i >= 0; --i) {
                    ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)ords.get(i);
                    PersistentField pf = ord.getPersistentField();
                    if (pf instanceof AnonymousPersistentFieldForInheritance) continue;
                    v.add(pf);
                }
                Vector cds = tempCld.getCollectionDescriptors();
                for (int i = cds.size() - 1; i >= 0; --i) {
                    CollectionDescriptor cd = (CollectionDescriptor)cds.get(i);
                    v.add(cd.getPersistentField());
                }
            } while (null != (baseClass = tempCld.getBaseClass()) && !baseClass.equals(OBJECT));
            cld.setSuperPersistentFieldDescriptors(v);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

