/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.metadata.ConnectionDescriptorXmlHandler;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.MetadataConfiguration;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.RepositoryXmlHandler;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class RepositoryPersistor
implements Configurable {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$RepositoryPersistor == null ? (class$org$apache$ojb$broker$metadata$RepositoryPersistor = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.RepositoryPersistor")) : class$org$apache$ojb$broker$metadata$RepositoryPersistor);
    private static final String SER_FILE_SUFFIX = "serialized";
    private static final String SERIALIZED_REPOSITORY_PATH = "serializedRepositoryPath";
    private boolean useSerializedRepository = false;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$RepositoryPersistor;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$DescriptorRepository;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ConnectionRepository;

    public RepositoryPersistor() {
        OjbConfigurator.getInstance().configure(this);
    }

    public void configure(Configuration pConfig) throws ConfigurationException {
        this.useSerializedRepository = ((MetadataConfiguration)((Object)pConfig)).useSerializedRepository();
    }

    public void writeToFile(DescriptorRepository repository, ConnectionRepository conRepository, OutputStream out) {
        RepositoryTags tags = RepositoryTags.getInstance();
        try {
            if (log.isDebugEnabled()) {
                log.debug("## Write repository file ##" + repository.toXML() + "## End of repository file ##");
            }
            String eol = SystemUtils.LINE_SEPARATOR;
            StringBuffer buf = new StringBuffer();
            buf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + eol);
            buf.append("<!DOCTYPE descriptor-repository SYSTEM \"repository.dtd\" >" + eol + eol);
            buf.append("<!-- OJB RepositoryPersistor generated this file on " + new Date().toString() + " -->" + eol);
            buf.append(tags.getOpeningTagNonClosingById(0) + eol);
            buf.append("  " + tags.getAttribute(67, DescriptorRepository.getVersion()) + eol);
            buf.append("  " + tags.getAttribute(34, repository.getIsolationLevelAsString()) + eol);
            buf.append(">" + eol);
            if (conRepository != null) {
                buf.append(eol + eol + conRepository.toXML() + eol + eol);
            }
            if (repository != null) {
                buf.append(repository.toXML());
            }
            buf.append(tags.getClosingTagById(0));
            PrintWriter pw = new PrintWriter(out);
            pw.print(buf.toString());
            pw.flush();
            pw.close();
        }
        catch (Exception e) {
            log.error("Could not write to output stream" + out, e);
        }
    }

    public DescriptorRepository readDescriptorRepository(String filename) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        DescriptorRepository result;
        if (this.useSerializedRepository) {
            Configuration config = OjbConfigurator.getInstance().getConfigurationFor(null);
            String pathPrefix = config.getString(SERIALIZED_REPOSITORY_PATH, ".");
            File serFile = new File(pathPrefix + File.separator + filename + "." + SER_FILE_SUFFIX);
            if (serFile.exists() && serFile.length() > 0L) {
                try {
                    long duration = System.currentTimeMillis();
                    result = this.deserialize(serFile);
                    log.info("Read serialized repository in " + (System.currentTimeMillis() - duration) + " ms");
                }
                catch (Exception e) {
                    log.error("error in loading serialized repository. Will try to use XML version.", e);
                    result = (DescriptorRepository)this.buildRepository(filename, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
                }
            } else {
                long duration = System.currentTimeMillis();
                result = (DescriptorRepository)this.buildRepository(filename, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
                log.info("Read repository from file took " + (System.currentTimeMillis() - duration) + " ms");
                this.serialize(result, serFile);
            }
        } else {
            long duration = System.currentTimeMillis();
            result = (DescriptorRepository)this.buildRepository(filename, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
            log.info("Read class descriptors took " + (System.currentTimeMillis() - duration) + " ms");
        }
        return result;
    }

    public DescriptorRepository readDescriptorRepository(InputStream inst) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        long duration = System.currentTimeMillis();
        InputSource inSource = new InputSource(inst);
        DescriptorRepository result = (DescriptorRepository)this.readMetadataFromXML(inSource, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
        log.info("Read class descriptors took " + (System.currentTimeMillis() - duration) + " ms");
        return result;
    }

    public ConnectionRepository readConnectionRepository(String filename) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        long duration = System.currentTimeMillis();
        ConnectionRepository result = (ConnectionRepository)this.buildRepository(filename, class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository);
        log.info("Read connection repository took " + (System.currentTimeMillis() - duration) + " ms");
        return result;
    }

    public ConnectionRepository readConnectionRepository(InputStream inst) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        long duration = System.currentTimeMillis();
        InputSource inSource = new InputSource(inst);
        ConnectionRepository result = (ConnectionRepository)this.readMetadataFromXML(inSource, class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository);
        log.info("Read connection repository took " + (System.currentTimeMillis() - duration) + " ms");
        return result;
    }

    protected DescriptorRepository deserialize(File serFile) {
        DescriptorRepository result = null;
        try {
            FileInputStream fis = new FileInputStream(serFile);
            result = (DescriptorRepository)SerializationUtils.deserialize((InputStream)fis);
        }
        catch (Exception e) {
            log.error("Deserialisation failed, using input path: " + serFile.getAbsolutePath(), e);
        }
        return result;
    }

    protected void serialize(DescriptorRepository repository, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            SerializationUtils.serialize((Serializable)repository, (OutputStream)fos);
        }
        catch (Exception e) {
            log.error("Serialization failed, using output path: " + file.getAbsolutePath(), e);
        }
    }

    private Object buildRepository(String repositoryFileName, Class targetRepository) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        URL url = this.buildURL(repositoryFileName);
        String pathName = url.toString();
        log.info("Building repository from :" + pathName);
        InputSource source = new InputSource(pathName);
        return this.readMetadataFromXML(source, targetRepository);
    }

    private Object readMetadataFromXML(InputSource source, Class target) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        SAXParser p = SAXParserFactory.newInstance().newSAXParser();
        log.debug("RespostoryPersistor using SAXParser : " + p.getClass().getName());
        XMLReader reader = p.getXMLReader();
        try {
            if (reader.getClass().getName().indexOf("crimson") != -1) {
                reader.setFeature("http://xml.org/sax/features/validation", true);
            }
        }
        catch (SAXNotSupportedException snse) {
            // empty catch block
        }
        Serializable result = null;
        if ((class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository).equals(target)) {
            DescriptorRepository repository = new DescriptorRepository();
            RepositoryXmlHandler handler = new RepositoryXmlHandler(repository);
            reader.setContentHandler(handler);
            reader.parse(source);
            result = repository;
        } else if ((class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository).equals(target)) {
            ConnectionRepository repository = new ConnectionRepository();
            ConnectionDescriptorXmlHandler handler = new ConnectionDescriptorXmlHandler(repository);
            reader.setContentHandler(handler);
            reader.parse(source);
            result = repository;
        } else {
            throw new MetadataException("Could not build a repository instance for '" + target + "', using source " + source);
        }
        return result;
    }

    private URL buildURL(String repositoryFileName) throws MalformedURLException {
        URL url = Thread.currentThread().getContextClassLoader().getResource(repositoryFileName);
        if (url == null) {
            try {
                url = new File(repositoryFileName).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null) {
            throw new MalformedURLException("did not find resource " + repositoryFileName);
        }
        log.info("OJB Descriptor Repository: " + url);
        return url;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

