/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.Iterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ProcedureDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.XmlCapable;

public class InsertProcedureDescriptor
extends ProcedureDescriptor
implements Serializable,
XmlCapable {
    private static final long serialVersionUID = -3808311052971075269L;
    private boolean includeAllFields;

    public InsertProcedureDescriptor(ClassDescriptor classDescriptor, String name, boolean includeAllFields) {
        super(classDescriptor, name);
        this.includeAllFields = includeAllFields;
        if (this.includeAllFields) {
            this.addArguments(this.getClassDescriptor().getFieldDescriptions());
        }
    }

    public boolean getIncludeAllFields() {
        return this.includeAllFields;
    }

    public final void addArgument(ArgumentDescriptor argument) {
        if (!this.getIncludeAllFields()) {
            super.addArgument(argument);
        }
    }

    public String toXML() {
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = System.getProperty("line.separator");
        String result = eol + "   ";
        result = result + " " + tags.getOpeningTagNonClosingById(103);
        result = result + " " + tags.getAttribute(97, this.getName());
        if (this.hasReturnValue()) {
            result = result + " " + tags.getAttribute(108, this.getReturnValueFieldRefName());
        }
        result = result + " " + tags.getAttribute(109, String.valueOf(this.getIncludeAllFields()));
        result = result + ">" + eol;
        if (!this.getIncludeAllFields()) {
            Iterator args = this.getArguments().iterator();
            while (args.hasNext()) {
                result = result + ((ArgumentDescriptor)args.next()).toXML();
            }
        }
        result = result + "    " + tags.getClosingTagById(103);
        return result + eol;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append("name", (Object)this.getName());
        buf.append("includeAllFields", this.getIncludeAllFields());
        if (this.hasReturnValue()) {
            buf.append("returnFieldRefName", (Object)this.getReturnValueFieldRefName());
        }
        return buf.toString();
    }
}

