/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.QueryCustomizer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.RepositoryTags;

public class CollectionDescriptor
extends ObjectReferenceDescriptor {
    private static final long serialVersionUID = -8570280662286424937L;
    private Class collectionClass = null;
    private Collection m_orderby = new ArrayList();
    private String indirectionTable = null;
    private Vector fksToItemClass = null;
    private Vector fksToThisClass = null;
    private String[] fksToItemClassAry;
    private String[] fksToThisClassAry;
    private boolean m_refresh = false;
    private QueryCustomizer m_queryCustomizer;
    private Boolean m_hasProxyItems;

    public CollectionDescriptor(ClassDescriptor descriptor) {
        super(descriptor);
    }

    public String[] getFksToThisClass() {
        if (this.fksToThisClassAry == null) {
            this.fksToThisClassAry = this.fksToThisClass.toArray(new String[this.fksToThisClass.size()]);
        }
        return this.fksToThisClassAry;
    }

    public void setFksToThisClass(Vector fksToThisClass) {
        this.fksToThisClass = fksToThisClass;
        this.fksToThisClassAry = null;
    }

    public void addFkToThisClass(String column) {
        if (this.fksToThisClass == null) {
            this.fksToThisClass = new Vector();
        }
        this.fksToThisClass.add(column);
        this.fksToThisClassAry = null;
    }

    public void addFkToItemClass(String column) {
        if (this.fksToItemClass == null) {
            this.fksToItemClass = new Vector();
        }
        this.fksToItemClass.add(column);
        this.fksToItemClassAry = null;
    }

    public Class getCollectionClass() {
        return this.collectionClass;
    }

    public void setCollectionClass(Class c) {
        this.collectionClass = c;
    }

    public String getCollectionClassName() {
        return this.collectionClass != null ? this.collectionClass.getName() : null;
    }

    public String getIndirectionTable() {
        return this.indirectionTable;
    }

    public void setIndirectionTable(String indirectionTable) {
        this.indirectionTable = indirectionTable;
    }

    public String[] getFksToItemClass() {
        if (this.fksToItemClassAry == null) {
            this.fksToItemClassAry = this.fksToItemClass.toArray(new String[this.fksToItemClass.size()]);
        }
        return this.fksToItemClassAry;
    }

    public void setFksToItemClass(Vector fksToItemClass) {
        this.fksToItemClass = fksToItemClass;
        this.fksToItemClassAry = null;
    }

    public boolean isMtoNRelation() {
        return this.indirectionTable != null;
    }

    public void addOrderBy(String fieldName, boolean sortAscending) {
        if (fieldName != null) {
            this.m_orderby.add(new FieldHelper(fieldName, sortAscending));
        }
    }

    public Collection getOrderBy() {
        return this.m_orderby;
    }

    public void setCascadeDelete(boolean cascade) {
        this.setCascadingDelete(!cascade ? 17 : 23);
    }

    public String toXML() {
        int i;
        RepositoryTags tags = RepositoryTags.getInstance();
        String eol = SystemUtils.LINE_SEPARATOR;
        String result = "      " + tags.getOpeningTagNonClosingById(27) + eol;
        result = result + "        " + tags.getAttribute(16, this.getAttributeName()) + eol;
        if (this.getCollectionClassName() != null) {
            result = result + "        " + tags.getAttribute(37, this.getCollectionClassName()) + eol;
        }
        result = result + "        " + tags.getAttribute(29, this.getItemClassName()) + eol;
        if (this.isMtoNRelation()) {
            result = result + "        " + tags.getAttribute(39, this.getIndirectionTable()) + eol;
        }
        if (this.isLazy()) {
            result = result + "        " + tags.getAttribute(48, "true") + eol;
            result = result + "        " + tags.getAttribute(114, "" + this.getProxyPrefetchingLimit()) + eol;
        }
        if (this.isRefresh()) {
            result = result + "        " + tags.getAttribute(47, "true") + eol;
        }
        result = result + "        " + tags.getAttribute(24, "" + this.getCascadeRetrieve()) + eol;
        result = result + "        " + tags.getAttribute(25, this.getCascadeAsString(this.getCascadingStore())) + eol;
        result = result + "        " + tags.getAttribute(26, this.getCascadeAsString(this.getCascadingDelete())) + eol;
        if (this.getOtmDependent()) {
            result = result + "        " + tags.getAttribute(102, "true") + eol;
        }
        result = result + "      >" + eol;
        for (i = 0; i < this.getForeignKeyFields().size(); ++i) {
            Object obj = this.getForeignKeyFields().get(i);
            if (obj instanceof Integer) {
                String fkId = obj.toString();
                result = result + "        " + tags.getOpeningTagNonClosingById(38) + " ";
                result = result + tags.getAttribute(70, fkId) + "/>" + eol;
                continue;
            }
            String fk = (String)obj;
            result = result + "        " + tags.getOpeningTagNonClosingById(38) + " ";
            result = result + tags.getAttribute(84, fk) + "/>" + eol;
        }
        if (this.isMtoNRelation()) {
            String fkId;
            for (i = 0; i < this.getFksToThisClass().length; ++i) {
                fkId = this.getFksToThisClass()[i];
                result = result + "        " + tags.getOpeningTagNonClosingById(41) + " ";
                result = result + tags.getAttribute(17, fkId) + "/>" + eol;
            }
            for (i = 0; i < this.getFksToItemClass().length; ++i) {
                fkId = this.getFksToItemClass()[i];
                result = result + "        " + tags.getOpeningTagNonClosingById(40) + " ";
                result = result + tags.getAttribute(17, fkId) + "/>" + eol;
            }
        }
        result = result + "      " + tags.getClosingTagById(27) + eol;
        return result;
    }

    public QueryCustomizer getQueryCustomizer() {
        return this.m_queryCustomizer;
    }

    public void setQueryCustomizer(QueryCustomizer queryCustomizer) {
        this.m_queryCustomizer = queryCustomizer;
    }

    public boolean hasProxyItems() throws PersistenceBrokerException {
        if (this.m_hasProxyItems == null) {
            DescriptorRepository repo = this.getClassDescriptor().getRepository();
            ClassDescriptor cld = repo.getDescriptorFor(this.getItemClass());
            if (cld.getProxyClass() != null) {
                this.m_hasProxyItems = Boolean.TRUE;
            } else {
                Vector extents = cld.getExtentClasses();
                this.m_hasProxyItems = Boolean.FALSE;
                Iterator it = extents.iterator();
                while (it.hasNext()) {
                    Class ext = (Class)it.next();
                    ClassDescriptor cldExt = repo.getDescriptorFor(ext);
                    if (cldExt.getProxyClass() == null) continue;
                    this.m_hasProxyItems = Boolean.TRUE;
                    break;
                }
            }
        }
        return this.m_hasProxyItems;
    }
}

