/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.accesslayer.CollectionProxy;
import org.apache.ojb.broker.accesslayer.CollectionProxyListener;
import org.apache.ojb.broker.accesslayer.IndirectionHandler;
import org.apache.ojb.broker.accesslayer.MaterializationListener;
import org.apache.ojb.broker.accesslayer.OJBIterator;
import org.apache.ojb.broker.accesslayer.PlainPrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcher;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherFactory;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ClassNotPersistenceCapableException;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.FieldHelper;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class QueryReferenceBroker {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$QueryReferenceBroker == null ? (class$org$apache$ojb$broker$core$QueryReferenceBroker = QueryReferenceBroker.class$("org.apache.ojb.broker.core.QueryReferenceBroker")) : class$org$apache$ojb$broker$core$QueryReferenceBroker);
    private PersistenceBrokerImpl pb;
    private HashMap m_retrievalTasks;
    private ArrayList prefetchingListeners;
    private final boolean batchRetrieval = true;
    private final boolean prefetchProxies = true;
    private Class classToPrefetch;
    static /* synthetic */ Class class$org$apache$ojb$broker$core$QueryReferenceBroker;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;

    public QueryReferenceBroker(PersistenceBrokerImpl pb) {
        this.pb = pb;
    }

    private ManageableCollection getCollectionByQuery(Class collectionClass, Class itemClass, Query query) throws ClassNotPersistenceCapableException, PersistenceBrokerException {
        boolean isRetrievalTasksCreated;
        if (this.log.isDebugEnabled()) {
            this.log.debug("getCollectionByQuery (" + collectionClass + ", " + itemClass + ", " + query + ")");
        }
        ClassDescriptor cld = this.pb.getClassDescriptor(itemClass);
        ManageableCollection result = null;
        OJBIterator iter = null;
        boolean bl = isRetrievalTasksCreated = this.m_retrievalTasks == null;
        if (isRetrievalTasksCreated) {
            this.m_retrievalTasks = new HashMap();
        }
        try {
            block14: {
                try {
                    result = (ManageableCollection)collectionClass.newInstance();
                    iter = this.pb.getIteratorFromQuery(query, cld);
                    while (iter.hasNext()) {
                        Object candidate = iter.next();
                        if (candidate == null) continue;
                        IndirectionHandler handler = ProxyHelper.getIndirectionHandler(candidate);
                        if (handler != null || itemClass.isAssignableFrom(candidate.getClass())) {
                            result.ojbAdd(candidate);
                        } else {
                            this.log.warn("Candidate object [" + candidate + "] class [" + candidate.getClass().getName() + "] is not a subtype of [" + itemClass.getName() + "] or any type of proxy. NOT INCLUDED in result collection");
                        }
                        if (handler == null || cld.getProxyPrefetchingLimit() <= 0 || !this.addRetrievalTask(candidate, this)) continue;
                        new PBMaterializationListener(candidate, this.m_retrievalTasks, this, cld.getProxyPrefetchingLimit());
                    }
                    if (!isRetrievalTasksCreated) break block14;
                    Class saveClassToPrefetch = this.classToPrefetch;
                    this.classToPrefetch = null;
                    this.performRetrievalTasks();
                    this.classToPrefetch = saveClassToPrefetch;
                }
                catch (InstantiationException ex) {
                    this.log.error(ex);
                    throw new PersistenceBrokerException(ex);
                }
                catch (IllegalAccessException ex) {
                    this.log.error(ex);
                    throw new PersistenceBrokerException(ex);
                }
            }
            Object var11_12 = null;
            if (iter != null) {
                iter.releaseDbResources();
            }
            if (isRetrievalTasksCreated) {
                this.m_retrievalTasks = null;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (iter != null) {
                iter.releaseDbResources();
            }
            if (isRetrievalTasksCreated) {
                this.m_retrievalTasks = null;
            }
            throw throwable;
        }
        return result;
    }

    public ManageableCollection getCollectionByQuery(Class collectionClass, Query query, boolean lazy) throws PersistenceBrokerException {
        try {
            ManageableCollection result = query == null ? (ManageableCollection)collectionClass.newInstance() : (lazy ? ProxyHelper.createCollectionProxy(this.pb, query, collectionClass) : this.getCollectionByQuery(collectionClass, query.getSearchClass(), query));
            return result;
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new PersistenceBrokerException(e);
        }
    }

    public Collection getCollectionByQuery(Query query, boolean lazy) throws PersistenceBrokerException {
        return (Collection)((Object)this.getCollectionByQuery(class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = QueryReferenceBroker.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, query, lazy));
    }

    private boolean addRetrievalTask(Object obj, Object key) {
        ArrayList<Object> owners = (ArrayList<Object>)this.m_retrievalTasks.get(key);
        boolean isFirst = false;
        if (owners == null) {
            owners = new ArrayList<Object>();
            this.m_retrievalTasks.put(key, owners);
            isFirst = true;
        }
        owners.add(obj);
        return isFirst;
    }

    private void performRetrievalTasks() {
        if (this.m_retrievalTasks == null) {
            return;
        }
        while (this.m_retrievalTasks.size() > 0) {
            HashMap tmp = this.m_retrievalTasks;
            this.m_retrievalTasks = new HashMap();
            Iterator it = tmp.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Object key = entry.getKey();
                if (!(key instanceof ObjectReferenceDescriptor)) continue;
                ObjectReferenceDescriptor ord = (ObjectReferenceDescriptor)key;
                ArrayList owners = (ArrayList)entry.getValue();
                if (ord.isLazy() || ord.getItemProxyClass() != null) continue;
                RelationshipPrefetcher prefetcher = RelationshipPrefetcherFactory.createRelationshipPrefetcher(this.pb, ord);
                prefetcher.prefetchRelationship(owners);
                it.remove();
            }
        }
    }

    public void retrieveReference(Object obj, ClassDescriptor cld, ObjectReferenceDescriptor rds, boolean forced) {
        Object refObj = null;
        if (forced || rds.getCascadeRetrieve()) {
            Identity id = this.getReferencedObjectIdentity(obj, rds, cld);
            boolean isRefObjDefined = true;
            if (id == null) {
                refObj = null;
            } else if (this.pb.serviceObjectCache().lookup(id) != null) {
                refObj = this.pb.doGetObjectByIdentity(id);
            } else if (this.m_retrievalTasks != null && !rds.isLazy() && rds.getItemProxyClass() == null) {
                this.addRetrievalTask(obj, rds);
                isRefObjDefined = false;
            } else {
                refObj = this.getReferencedObject(id, rds, cld);
            }
            if (isRefObjDefined) {
                IndirectionHandler handler;
                PersistentField refField = rds.getPersistentField();
                refField.set(obj, refObj);
                if (refObj != null && this.m_retrievalTasks != null && rds.getProxyPrefetchingLimit() > 0 && (handler = ProxyHelper.getIndirectionHandler(refObj)) != null && this.addRetrievalTask(obj, rds)) {
                    new PBMaterializationListener(obj, this.m_retrievalTasks, rds, rds.getProxyPrefetchingLimit());
                }
            }
        }
    }

    public void retrieveReferences(Object newObj, ClassDescriptor cld, boolean forced) throws PersistenceBrokerException {
        Iterator i = cld.getObjectReferenceDescriptors().iterator();
        ObjectReferenceDescriptor rds = null;
        Class saveClassToPrefetch = this.classToPrefetch;
        this.classToPrefetch = null;
        while (i.hasNext()) {
            rds = (ObjectReferenceDescriptor)i.next();
            this.retrieveReference(newObj, cld, rds, forced);
        }
        this.classToPrefetch = saveClassToPrefetch;
    }

    private Identity getReferencedObjectIdentity(Object obj, ObjectReferenceDescriptor rds, ClassDescriptor cld) {
        Object[] fkValues = rds.getForeignKeyValues(obj, cld);
        boolean allFkValuesNull = true;
        for (int i = 0; i < fkValues.length; ++i) {
            if (fkValues[i] == null) continue;
            allFkValuesNull = false;
            break;
        }
        if (allFkValuesNull) {
            return null;
        }
        return new Identity(rds.getItemClass(), this.pb.getTopLevelClass(rds.getItemClass()), fkValues);
    }

    private Object getReferencedObject(Identity id, ObjectReferenceDescriptor rds, ClassDescriptor cld) {
        Class referencedProxy = rds.isLazy() ? this.pb.getClassDescriptor(rds.getItemClass()).getDynamicProxyClass() : rds.getItemProxyClass();
        if (referencedProxy != null) {
            try {
                return VirtualProxy.createProxy(this.pb.getPBKey(), referencedProxy, id);
            }
            catch (Exception e) {
                this.log.error("Error instantiating obj: " + e.getMessage(), e);
                throw new PersistenceBrokerException(e);
            }
        }
        return this.pb.doGetObjectByIdentity(id);
    }

    public void retrieveCollection(Object obj, ClassDescriptor cld, CollectionDescriptor cds, boolean forced) {
        if (forced || cds.getCascadeRetrieve()) {
            if (this.m_retrievalTasks != null && !cds.isLazy() && !cds.hasProxyItems() && cds.getQueryCustomizer() == null) {
                this.addRetrievalTask(obj, cds);
            } else {
                Object value;
                Class collectionClass = cds.getCollectionClass();
                PersistentField collectionField = cds.getPersistentField();
                Query fkQuery = this.getFKQuery(obj, cld, cds);
                if (collectionClass == null) {
                    Collection result = this.getCollectionByQuery(fkQuery, cds.isLazy());
                    if (collectionField.getType().isArray()) {
                        int length = result.size();
                        Class<?> itemtype = collectionField.getType().getComponentType();
                        Object resultArray = Array.newInstance(itemtype, length);
                        int j = 0;
                        Iterator iter = result.iterator();
                        while (iter.hasNext()) {
                            Array.set(resultArray, j, iter.next());
                            ++j;
                        }
                        collectionField.set(obj, resultArray);
                    } else {
                        collectionField.set(obj, result);
                    }
                    value = result;
                } else {
                    ManageableCollection result = this.getCollectionByQuery(collectionClass, fkQuery, cds.isLazy());
                    collectionField.set(obj, result);
                    value = result;
                }
                if (this.m_retrievalTasks != null && cds.getProxyPrefetchingLimit() > 0 && cds.getQueryCustomizer() == null && value instanceof CollectionProxy && this.addRetrievalTask(obj, cds)) {
                    new PBCollectionProxyListener(obj, this.m_retrievalTasks, cds, cds.getProxyPrefetchingLimit());
                }
            }
        }
    }

    private Query getFKQuery(Object obj, ClassDescriptor cld, CollectionDescriptor cds) {
        Query fkQuery = null;
        QueryByCriteria fkQueryCrit = null;
        fkQueryCrit = cds.isMtoNRelation() ? this.getFKQueryMtoN(obj, cld, cds) : this.getFKQuery1toN(obj, cld, cds);
        if (!cds.getOrderBy().isEmpty()) {
            Iterator iter = cds.getOrderBy().iterator();
            while (iter.hasNext()) {
                fkQueryCrit.addOrderBy((FieldHelper)iter.next());
            }
        }
        fkQuery = cds.getQueryCustomizer() != null ? cds.getQueryCustomizer().customizeQuery(obj, this.pb, cds, fkQueryCrit) : fkQueryCrit;
        return fkQuery;
    }

    private QueryByCriteria getFKQueryMtoN(Object obj, ClassDescriptor cld, CollectionDescriptor cod) {
        int i;
        ValueContainer[] values = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        String[] thisClassFks = cod.getFksToThisClass();
        String[] itemClassFks = cod.getFksToItemClass();
        ClassDescriptor refCld = this.pb.getClassDescriptor(cod.getItemClass());
        Criteria criteria = new Criteria();
        for (i = 0; i < thisClassFks.length; ++i) {
            criteria.addColumnEqualTo(cod.getIndirectionTable() + "." + thisClassFks[i], values[i].getValue());
        }
        for (i = 0; i < itemClassFks.length; ++i) {
            criteria.addColumnEqualToField(cod.getIndirectionTable() + "." + itemClassFks[i].toString(), refCld.getPkFields()[i].getAttributeName());
        }
        return QueryFactory.newQuery(refCld.getClassOfObject(), cod.getIndirectionTable(), criteria);
    }

    private QueryByCriteria getFKQuery1toN(Object obj, ClassDescriptor cld, CollectionDescriptor cod) {
        ValueContainer[] container = this.pb.serviceBrokerHelper().getKeyValues(cld, obj);
        ClassDescriptor refCld = this.pb.getClassDescriptor(cod.getItemClass());
        FieldDescriptor[] fields = cod.getForeignKeyFieldDescriptors(refCld);
        Criteria criteria = new Criteria();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fld = fields[i];
            criteria.addEqualTo(fld.getAttributeName(), container[i].getValue());
        }
        return QueryFactory.newQuery(refCld.getClassOfObject(), criteria);
    }

    public Query getPKQuery(Identity oid) {
        Object[] values = oid.getPrimaryKeyValues();
        ClassDescriptor cld = this.pb.getClassDescriptor(oid.getObjectsTopLevelClass());
        FieldDescriptor[] fields = cld.getPkFields();
        Criteria criteria = new Criteria();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fld = fields[i];
            criteria.addEqualTo(fld.getAttributeName(), values[i]);
        }
        return QueryFactory.newQuery(cld.getClassOfObject(), criteria);
    }

    public void retrieveCollections(Object newObj, ClassDescriptor cld, boolean forced) throws PersistenceBrokerException {
        Iterator i = cld.getCollectionDescriptors().iterator();
        Class saveClassToPrefetch = this.classToPrefetch;
        this.classToPrefetch = null;
        while (i.hasNext()) {
            CollectionDescriptor cds = (CollectionDescriptor)i.next();
            this.retrieveCollection(newObj, cld, cds, forced);
        }
        this.classToPrefetch = saveClassToPrefetch;
    }

    public void removePrefetchingListeners() {
        if (this.prefetchingListeners != null) {
            Iterator it = this.prefetchingListeners.iterator();
            while (it.hasNext()) {
                PBPrefetchingListener listener = (PBPrefetchingListener)it.next();
                listener.removeThisListener();
            }
            this.prefetchingListeners.clear();
        }
    }

    public Class getClassToPrefetch() {
        return this.classToPrefetch;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PBCollectionProxyListener
    extends PBPrefetchingListener
    implements CollectionProxyListener {
        CollectionProxy _listenedCollection;

        PBCollectionProxyListener(Object owner, HashMap retrievalTasks, CollectionDescriptor key, int limit) {
            super(owner, retrievalTasks, key, limit);
        }

        protected void addThisListenerTo(Object owner) {
            PersistentField collectionField = ((CollectionDescriptor)this._key).getPersistentField();
            this._listenedCollection = (CollectionProxy)collectionField.get(owner);
            this._listenedCollection.addListener(this);
        }

        protected void removeThisListener() {
            if (this._listenedCollection != null) {
                this._listenedCollection.removeListener(this);
                this._listenedCollection = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object listenedObject) {
            return RelationshipPrefetcherFactory.createRelationshipPrefetcher(QueryReferenceBroker.this.pb, (CollectionDescriptor)this._key);
        }

        public void beforeLoading(CollectionProxy col) {
            this.prefetch(col);
        }

        public void afterLoading(CollectionProxy col) {
        }
    }

    abstract class PBPrefetchingListener {
        private HashMap _retrievalTasks;
        private int _limit;
        protected Object _key;

        PBPrefetchingListener(Object owner, HashMap retrievalTasks, Object key, int limit) {
            this._retrievalTasks = retrievalTasks;
            this._key = key;
            this._limit = limit + 1;
            if (QueryReferenceBroker.this.prefetchingListeners == null) {
                QueryReferenceBroker.this.prefetchingListeners = new ArrayList();
            }
            this.addThisListenerTo(owner);
            QueryReferenceBroker.this.prefetchingListeners.add(this);
        }

        protected abstract void addThisListenerTo(Object var1);

        protected abstract void removeThisListener();

        protected abstract RelationshipPrefetcher getPrefetcher(Object var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void prefetch(Object listenedObject) {
            boolean prefetchingAll;
            List toPrefetch;
            ArrayList owners = (ArrayList)this._retrievalTasks.get(this._key);
            this.removeThisListener();
            if (owners == null) {
                return;
            }
            RelationshipPrefetcher prefetcher = this.getPrefetcher(listenedObject);
            if (owners.size() <= this._limit) {
                toPrefetch = owners;
                prefetchingAll = true;
            } else {
                toPrefetch = owners.subList(0, this._limit);
                prefetchingAll = false;
            }
            Class saveClassToPrefetch = QueryReferenceBroker.this.classToPrefetch;
            QueryReferenceBroker.this.classToPrefetch = prefetcher.getItemClassDescriptor().getClassOfObject();
            try {
                prefetcher.prefetchRelationship(toPrefetch);
            }
            finally {
                QueryReferenceBroker.this.classToPrefetch = saveClassToPrefetch;
            }
            if (prefetchingAll) {
                this._retrievalTasks.remove(this._key);
            } else {
                toPrefetch.clear();
                this.addThisListenerTo(owners.get(0));
            }
        }
    }

    class PBMaterializationListener
    extends PBPrefetchingListener
    implements MaterializationListener {
        private IndirectionHandler _listenedHandler;

        PBMaterializationListener(Object owner, HashMap retrievalTasks, Object key, int limit) {
            super(owner, retrievalTasks, key, limit);
        }

        protected void addThisListenerTo(Object owner) {
            this._listenedHandler = ProxyHelper.getIndirectionHandler(owner);
            if (this._listenedHandler != null) {
                this._listenedHandler.addListener(this);
            }
        }

        protected void removeThisListener() {
            if (this._listenedHandler != null) {
                this._listenedHandler.removeListener(this);
                this._listenedHandler = null;
            }
        }

        protected RelationshipPrefetcher getPrefetcher(Object listenedObject) {
            if (this._key instanceof ObjectReferenceDescriptor) {
                return RelationshipPrefetcherFactory.createRelationshipPrefetcher(QueryReferenceBroker.this.pb, (ObjectReferenceDescriptor)this._key);
            }
            IndirectionHandler handler = (IndirectionHandler)listenedObject;
            return new PlainPrefetcher(QueryReferenceBroker.this.pb, handler.getIdentity().getObjectsTopLevelClass());
        }

        public void beforeMaterialization(IndirectionHandler handler, Identity oid) {
            this.prefetch(handler);
        }

        public void afterMaterialization(IndirectionHandler handler, Object materializedObject) {
        }
    }
}

