/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.core;

import java.util.Properties;
import org.apache.commons.pool.KeyedObjectPool;
import org.apache.commons.pool.KeyedPoolableObjectFactory;
import org.apache.commons.pool.impl.GenericKeyedObjectPool;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBState;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.core.PBPoolInfo;
import org.apache.ojb.broker.core.PersistenceBrokerFactoryBaseImpl;
import org.apache.ojb.broker.core.PersistenceBrokerHandle;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.core.PoolablePersistenceBroker;
import org.apache.ojb.broker.util.BrokerHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.logging.LoggingHelper;

public class PersistenceBrokerFactoryDefaultImpl
extends PersistenceBrokerFactoryBaseImpl {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl == null ? (class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl = PersistenceBrokerFactoryDefaultImpl.class$("org.apache.ojb.broker.core.PersistenceBrokerFactoryDefaultImpl")) : class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl);
    private GenericKeyedObjectPool brokerPool;
    private PBPoolInfo poolConfig = new PBPoolInfo();
    static /* synthetic */ Class class$org$apache$ojb$broker$core$PersistenceBrokerFactoryDefaultImpl;

    public PersistenceBrokerFactoryDefaultImpl() {
        this.brokerPool = this.createPool();
        log.info("Create PersistenceBroker instance pool, pool configuration was " + this.getPoolConfiguration());
    }

    public PersistenceBroker createPersistenceBroker(PBKey pbKey) throws PBFactoryException {
        if (log.isDebugEnabled()) {
            log.debug("Obtain broker from pool, used PBKey is " + pbKey);
        }
        PersistenceBroker broker = null;
        pbKey = BrokerHelper.crossCheckPBKey(pbKey);
        try {
            broker = (PersistenceBroker)this.brokerPool.borrowObject((Object)pbKey);
            broker = this.wrapRequestedBrokerInstance(broker);
        }
        catch (Exception e) {
            try {
                if (broker != null) {
                    broker.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw new PBFactoryException("Borrow broker from pool failed, using PBKey " + pbKey, e);
        }
        return broker;
    }

    protected PersistenceBroker wrapBrokerWithPoolingHandle(PersistenceBroker broker, KeyedObjectPool pool) {
        return new PoolablePersistenceBroker(broker, pool);
    }

    protected PersistenceBroker wrapRequestedBrokerInstance(PersistenceBroker broker) {
        return new PersistenceBrokerHandle(broker);
    }

    public synchronized void releaseAllInstances() {
        log.warn("Release all instances referenced by this object");
        super.releaseAllInstances();
        try {
            this.brokerPool.clear();
        }
        catch (Exception e) {
            log.error("Clearing of broker pool failed", e);
        }
    }

    public int activePersistenceBroker() {
        return this.brokerPool.getNumActive();
    }

    public Properties getPoolConfiguration() {
        return this.poolConfig;
    }

    public void setPoolConfiguration(Properties prop) {
        this.poolConfig = new PBPoolInfo(prop);
        log.info("Change pooling configuration properties: " + this.poolConfig.getKeyedObjectPoolConfig());
        this.brokerPool.setConfig(this.poolConfig.getKeyedObjectPoolConfig());
    }

    private GenericKeyedObjectPool createPool() {
        GenericKeyedObjectPool.Config conf = this.poolConfig.getKeyedObjectPoolConfig();
        if (log.isDebugEnabled()) {
            log.debug("PersistenceBroker pool will be setup with the following configuration " + LoggingHelper.traceObject(conf));
        }
        GenericKeyedObjectPool pool = new GenericKeyedObjectPool(null, conf);
        pool.setFactory((KeyedPoolableObjectFactory)new PBKeyedPoolableObjectFactory(this, (KeyedObjectPool)pool));
        return pool;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class PBKeyedPoolableObjectFactory
    implements KeyedPoolableObjectFactory {
        private PersistenceBrokerFactoryDefaultImpl pbf;
        private KeyedObjectPool pool;

        public PBKeyedPoolableObjectFactory(PersistenceBrokerFactoryDefaultImpl pbf, KeyedObjectPool pool) {
            this.pbf = pbf;
            this.pool = pool;
        }

        public Object makeObject(Object key) throws Exception {
            return PersistenceBrokerFactoryDefaultImpl.this.wrapBrokerWithPoolingHandle(this.pbf.createNewBrokerInstance((PBKey)key), this.pool);
        }

        public void destroyObject(Object key, Object obj) throws Exception {
            PoolablePersistenceBroker pb = (PoolablePersistenceBroker)obj;
            PersistenceBroker broker = pb.getInnermostDelegate();
            if (broker instanceof PersistenceBrokerImpl) {
                log.info("Destroy PersistenceBroker instance " + obj);
                ((PersistenceBrokerImpl)broker).destroy();
            }
            pb.destroy();
        }

        public boolean validateObject(Object key, Object obj) {
            if (((PersistenceBroker)obj).isInTransaction()) {
                log.error("Illegal broker state! This broker instance was already in transaction.");
                return false;
            }
            return true;
        }

        public void activateObject(Object key, Object obj) throws Exception {
            ((PBState)obj).setClosed(false);
        }

        public void passivateObject(Object key, Object obj) throws Exception {
            ((PBState)obj).setClosed(true);
        }
    }
}

