/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PBStateEvent;
import org.apache.ojb.broker.PBStateListener;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.VirtualProxy;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.ObjectCacheDefaultImpl;
import org.apache.ojb.broker.core.PersistenceBrokerImpl;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class TwoLevelCache
implements ObjectCache,
PBStateListener {
    protected Map objectTable = null;
    private static ObjectCache secondLevelCache = new ObjectCacheDefaultImpl(null, null);
    private int secondLevelFoundCount;
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private DescriptorRepository descriptorRepository;
    private PBKey pbKey;
    private PersistenceBroker myBroker;
    private int hitCount = 0;
    private int failCount = 0;
    private int gcCount = 0;

    public TwoLevelCache(PersistenceBroker broker, Properties props) {
        this.objectTable = new HashMap();
        this.descriptorRepository = broker.getDescriptorRepository();
        this.myBroker = broker;
        this.pbKey = broker.getPBKey();
        broker.addListener(this, true);
    }

    private PBKey getPbKey() {
        return this.pbKey;
    }

    protected final DescriptorRepository getDescriptorRepository() {
        return this.descriptorRepository;
    }

    public void clear() {
        this.objectTable.clear();
    }

    public static void clearSecondLevel() {
        secondLevelCache.clear();
    }

    public void cache(Identity oid, Object obj) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Caching object with identity " + oid);
        }
        if (obj != null) {
            SoftReference<Object> ref = new SoftReference<Object>(obj);
            this.objectTable.put(oid, ref);
        }
    }

    private void insertInto2ndLevel(Identity oid, Object obj) {
        try {
            Object clone = this.clone(obj);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("inserting clone into 2. level cache " + oid);
            }
            this.unsetReferences(clone, obj);
            secondLevelCache.cache(oid, clone);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("cache insert: " + this.myBroker + ": " + oid);
            }
        }
        catch (CloneNotSupportedException exc) {
            this.logger.error("second level caching failed: " + exc);
        }
    }

    private Object lookupFrom2ndLevel(Identity oid) {
        Object cacheObj = secondLevelCache.lookup(oid);
        if (cacheObj != null) {
            try {
                Object obj = this.clone(cacheObj);
                this.initReferences(obj);
                this.initLookedUpCollections(obj, cacheObj);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("+++ retrieved object from second level cache.");
                }
                this.objectTable.put(oid, new SoftReference<Object>(obj));
                ++this.secondLevelFoundCount;
                return obj;
            }
            catch (CloneNotSupportedException exc) {
                this.logger.error("Cannot clone object from 2nd level cache: " + cacheObj);
            }
        } else {
            ++this.failCount;
        }
        return null;
    }

    private Object getReferenceProxy(ClassDescriptor cld, ObjectReferenceDescriptor rds, Object obj) {
        Object[] pkVals = rds.getForeignKeyValues(obj, cld);
        boolean allPkNull = true;
        for (int j = 0; j < pkVals.length; ++j) {
            if (pkVals[j] == null) continue;
            allPkNull = false;
            break;
        }
        if (allPkNull) {
            return null;
        }
        Class referencedProxy = rds.getItemProxyClass();
        if (referencedProxy == null) {
            referencedProxy = this.descriptorRepository.getDescriptorFor(rds.getItemClass()).getDynamicProxyClass();
        }
        return this.getProxy(rds.getItemClass(), referencedProxy, pkVals);
    }

    protected final Object getProxy(Class referencedClass, Class referencedProxy, Object[] pkVals) {
        Class topLevelReferencedClass = this.descriptorRepository.getTopLevelClass(referencedClass);
        Object ret = VirtualProxy.createProxy(this.getPbKey(), referencedProxy, new Identity(null, topLevelReferencedClass, pkVals));
        return ret;
    }

    private Method getCloneMethod(Object in) {
        Class<?> clazz = in.getClass();
        while (true) {
            try {
                return clazz.getDeclaredMethod("clone", null);
            }
            catch (NoSuchMethodException exc) {
                if ((clazz = clazz.getSuperclass()) != null) continue;
                throw new NoCloneMethod(in.getClass());
            }
            break;
        }
    }

    protected Object clone(Object in) throws CloneNotSupportedException {
        Method cloneMethod = this.getCloneMethod(in);
        try {
            return cloneMethod.invoke(in, null);
        }
        catch (IllegalAccessException exc) {
            throw new OJBRuntimeException(exc);
        }
        catch (InvocationTargetException exc) {
            throw new OJBRuntimeException(exc);
        }
    }

    private void initReferences(Object obj) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initializing references");
        }
        ClassDescriptor cld = this.descriptorRepository.getDescriptorFor(obj.getClass());
        Iterator i = cld.getObjectReferenceDescriptors().iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            Object refObj = this.getReferenceProxy(cld, rds, obj);
            PersistentField refField = rds.getPersistentField();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("setting reference: " + refField.getName() + ", " + (refObj == null ? "<null>" : refObj.getClass().getName()));
            }
            refField.set(obj, refObj);
        }
    }

    protected void initLookedUpCollections(Object obj, Object cacheObj) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("initializing collections");
        }
        ClassDescriptor cld = this.descriptorRepository.getDescriptorFor(obj.getClass());
        ((PersistenceBrokerImpl)this.myBroker).getReferenceBroker().retrieveCollections(obj, cld, false);
    }

    private void unsetReferences(Object cacheObj, Object origObj) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("unsetting references");
        }
        ClassDescriptor cld = this.descriptorRepository.getDescriptorFor(cacheObj.getClass());
        Iterator i = cld.getObjectReferenceDescriptors().iterator();
        while (i.hasNext()) {
            ObjectReferenceDescriptor rds = (ObjectReferenceDescriptor)i.next();
            PersistentField refField = rds.getPersistentField();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("unsetting reference: " + refField.getName());
            }
            refField.set(cacheObj, null);
        }
        i = cld.getCollectionDescriptors().iterator();
        while (i.hasNext()) {
            CollectionDescriptor colDesc = (CollectionDescriptor)i.next();
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("unsetting collection: " + colDesc.getAttributeName());
            }
            this.initCacheCollectionField(colDesc, cacheObj, origObj);
        }
    }

    protected void initCacheCollectionField(CollectionDescriptor colDesc, Object cacheObj, Object origObject) {
        PersistentField refField = colDesc.getPersistentField();
        refField.set(cacheObj, null);
    }

    public Object lookup(Identity oid) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("****** lookup " + this.myBroker + ": " + oid);
        }
        ++this.hitCount;
        Object obj = null;
        SoftReference ref = (SoftReference)this.objectTable.get(oid);
        if (ref != null) {
            obj = ref.get();
            if (obj == null) {
                ++this.gcCount;
                this.objectTable.remove(oid);
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug("cache hit: " + this.myBroker + ": " + oid);
            }
        }
        if (obj == null) {
            obj = this.lookupFrom2ndLevel(oid);
        }
        return obj;
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.MULTI_LINE_STYLE);
        buf.append((Object)"CACHE STATISTICS");
        buf.append("Count of cached objects", this.objectTable.keySet().size());
        buf.append("lookups", this.hitCount);
        buf.append("failures", this.failCount);
        buf.append("reclaimed", this.gcCount);
        buf.append("2. level success", this.secondLevelFoundCount);
        buf.append((Object)secondLevelCache.toString());
        return buf.toString();
    }

    public void remove(Identity oid) {
        if (oid != null) {
            this.objectTable.remove(oid);
            secondLevelCache.remove(oid);
        }
    }

    public void beforeClose(PBStateEvent event) {
        this.clear();
    }

    public void afterOpen(PBStateEvent event) {
    }

    public void beforeBegin(PBStateEvent event) {
    }

    public void afterBegin(PBStateEvent event) {
    }

    public void beforeCommit(PBStateEvent event) {
    }

    public void afterCommit(PBStateEvent event) {
        Iterator iter = this.objectTable.keySet().iterator();
        while (iter.hasNext()) {
            Identity oid = (Identity)iter.next();
            SoftReference ref = (SoftReference)this.objectTable.get(oid);
            Object obj = ref.get();
            if (obj == null) continue;
            this.insertInto2ndLevel(oid, obj);
        }
    }

    public void beforeRollback(PBStateEvent event) {
        this.clear();
    }

    public void afterRollback(PBStateEvent event) {
        this.clear();
    }

    static class NoCloneMethod
    extends OJBRuntimeException {
        NoCloneMethod(Class clazz) {
            super(clazz.toString() + " has no clone method.");
        }
    }
}

