/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.ObjectCache;

public final class ObjectCacheSoftImpl
implements ObjectCache {
    private final SoftHashMap m_map;
    int m_hardSize = 100;

    public ObjectCacheSoftImpl() {
        this.m_map = new SoftHashMap(this.m_hardSize);
    }

    public ObjectCacheSoftImpl(int hardSize) {
        this.m_hardSize = hardSize;
        this.m_map = new SoftHashMap(this.m_hardSize);
    }

    public final void cache(Identity oid, Object obj) {
        this.m_map.put(oid, obj);
    }

    public final Object lookup(Identity oid) {
        return this.m_map.get(oid);
    }

    public final void remove(Identity oid) {
        this.m_map.remove(oid);
    }

    public final synchronized void clear() {
        this.m_map.clear();
    }

    public final class SoftHashMap
    extends AbstractMap {
        private final HashMap hash = new HashMap();
        private final int HARD_SIZE;
        private FixSizedLinkedHashMap hardCacheMap = null;
        private final ReferenceQueue queue = new ReferenceQueue();

        public SoftHashMap() {
            this(100);
            this.hardCacheMap = new FixSizedLinkedHashMap(100);
        }

        public SoftHashMap(int hardSize) {
            this.HARD_SIZE = hardSize;
            this.hardCacheMap = new FixSizedLinkedHashMap(hardSize);
        }

        public final void clear() {
            this.processQueue();
            this.hash.clear();
            this.hardCacheMap.clear();
        }

        public final Object get(Object key) {
            if (key == null) {
                return null;
            }
            Object result = null;
            SoftReference soft_ref = (SoftReference)this.hash.get(key);
            if (soft_ref != null) {
                result = soft_ref.get();
                if (result == null) {
                    this.hash.remove(key);
                } else if (!this.hardCacheMap.containsKey(key)) {
                    this.hardCacheMap.put(key, result);
                } else {
                    this.hardCacheMap.get(key);
                }
            }
            return result;
        }

        private void processQueue() {
            SoftValue sv;
            while ((sv = (SoftValue)this.queue.poll()) != null) {
                this.hash.remove(sv.key);
            }
        }

        public final Object put(Object key, Object value) {
            if (key == null || value == null) {
                return null;
            }
            this.processQueue();
            this.hardCacheMap.put(key, value);
            return this.hash.put(key, new SoftValue(value, key, this.queue));
        }

        public final Object remove(Object key) {
            this.processQueue();
            Object retval = null;
            Object value = this.hash.remove(key);
            if (value != null && value instanceof SoftValue) {
                retval = ((SoftValue)value).get();
            }
            return retval;
        }

        public final int size() {
            this.processQueue();
            return this.hash.size();
        }

        public final Set entrySet() {
            throw new UnsupportedOperationException();
        }

        public final Enumeration elements() {
            throw new UnsupportedOperationException();
        }

        private final class SoftValue
        extends SoftReference {
            private final Object key;

            private SoftValue(Object k, Object key, ReferenceQueue q) {
                super(k, q);
                this.key = key;
            }
        }
    }

    public static final class FixSizedLinkedHashMap
    extends LinkedHashMap {
        private int capacity = 0;

        public FixSizedLinkedHashMap(int size) {
            super(size, 1.0f, true);
            this.capacity = size;
        }

        protected final boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.capacity;
        }
    }
}

