/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.Properties;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.apache.jcs.JCS;
import org.apache.jcs.access.exception.CacheException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.cache.JCSHelper;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.cache.RuntimeCacheException;

public class ObjectCacheJCSImpl
implements ObjectCache {
    private JCS jcsCache;
    private String regionName = "ojbDefault";

    public ObjectCacheJCSImpl(PersistenceBroker broker, Properties prop) {
        this(null);
    }

    public ObjectCacheJCSImpl(String name) {
        this.regionName = name != null ? name : this.regionName;
        this.jcsCache = JCSHelper.newInstance(this.regionName);
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void cache(Identity oid, Object obj) {
        try {
            this.jcsCache.put((Object)oid, obj);
        }
        catch (CacheException e) {
            throw new RuntimeCacheException(e);
        }
    }

    public Object lookup(Identity oid) {
        return this.jcsCache.get((Object)oid);
    }

    public void remove(Identity oid) {
        try {
            this.jcsCache.remove((Object)oid);
        }
        catch (CacheException e) {
            throw new RuntimeCacheException(e.getMessage());
        }
    }

    public void clear() {
        if (this.jcsCache != null) {
            try {
                this.jcsCache.remove();
            }
            catch (CacheException e) {
                throw new RuntimeCacheException(e);
            }
        }
    }

    public String toString() {
        ToStringBuilder buf = new ToStringBuilder((Object)this, ToStringStyle.DEFAULT_STYLE);
        buf.append("JCS region name", (Object)this.regionName);
        buf.append("JCS region", (Object)this.jcsCache);
        return buf.toString();
    }
}

