/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.cache;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class InternalCache
implements ObjectCache {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$cache$InternalCache == null ? (class$org$apache$ojb$broker$cache$InternalCache = InternalCache.class$("org.apache.ojb.broker.cache.InternalCache")) : class$org$apache$ojb$broker$cache$InternalCache);
    private ObjectCache realCache;
    private HashMap localCache;
    private boolean enabledReadCache;
    static /* synthetic */ Class class$org$apache$ojb$broker$cache$InternalCache;

    public InternalCache(ObjectCache realCache) {
        this.realCache = realCache;
        this.localCache = new HashMap();
        this.enabledReadCache = false;
    }

    public void enableMaterializationCache() {
        this.enabledReadCache = true;
    }

    public void disableMaterializationCache() {
        this.enabledReadCache = false;
        this.pushToRealCache();
    }

    private void pushToRealCache() {
        Iterator it = this.localCache.keySet().iterator();
        while (it.hasNext()) {
            Identity oid = (Identity)it.next();
            this.realCache.cache(oid, this.localCache.get(oid));
        }
        this.localCache.clear();
    }

    public void cache(Identity oid, Object obj) {
        if (this.enabledReadCache) {
            this.localCache.put(oid, obj);
        } else {
            this.realCache.cache(oid, obj);
        }
    }

    public Object lookup(Identity oid) {
        Object result = null;
        if (this.enabledReadCache) {
            result = this.localCache.get(oid);
        }
        if (result == null) {
            result = this.realCache.lookup(oid);
        }
        return result;
    }

    public void remove(Identity oid) {
        if (this.enabledReadCache && !this.localCache.isEmpty()) {
            this.localCache.remove(oid);
        }
        this.realCache.remove(oid);
    }

    public void localClear() {
        if (this.localCache.size() > 0) {
            log.error("Found " + this.localCache.size() + " abandoned objects in local cache, check code to force" + " push to real ObjectCache");
        }
        this.localCache.clear();
    }

    public void clear() {
        this.localCache.clear();
        this.realCache.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

