/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.ant;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.Hashtable;

public class DBUtility {
    private Connection m_connection = null;
    private String m_url = null;
    private String m_user = null;
    private String m_pwd = null;
    private static String m_ORA_EXCEPTION_1000 = "ORA-01000";
    private static String m_ORA_EXCEPTION_604 = "ORA-00604";
    private Hashtable m_columnCache = new Hashtable(79);

    public DBUtility(String url, String user, String pwd) throws SQLException, ClassNotFoundException {
        this.m_url = url;
        this.m_user = user;
        this.m_pwd = pwd;
        this.m_connection = this.connect(url, user, pwd);
    }

    public void release() throws SQLException {
        if (this.m_connection != null) {
            this.m_connection.close();
        }
    }

    private void resetConnection() {
        try {
            this.release();
            this.connect(this.m_url, this.m_user, this.m_pwd);
        }
        catch (Exception e) {
            System.out.println("Could not reconnect to database!!!! " + e.getMessage());
        }
    }

    private Connection connect(String url, String user, String pwd) throws SQLException, ClassNotFoundException {
        this.m_connection = DriverManager.getConnection(url, user, pwd);
        return this.m_connection;
    }

    public boolean exists(String tableName) {
        boolean bReturn = false;
        if (tableName == null) {
            return bReturn;
        }
        PreparedStatement checkTable = null;
        try {
            checkTable = this.m_connection.prepareStatement("Select * from " + tableName + " where 1=0");
            checkTable.executeQuery();
            bReturn = true;
        }
        catch (Exception e) {
            if (e.getMessage().startsWith(m_ORA_EXCEPTION_1000) || e.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                this.resetConnection();
                return this.exists(tableName);
            }
            bReturn = false;
        }
        return bReturn;
    }

    private ResultSet getColumns(String tableName) {
        return (ResultSet)this.m_columnCache.get(tableName);
    }

    private void putColumns(String tableName, ResultSet columns) {
        this.m_columnCache.put(tableName, columns);
    }

    public void exists(String tableName, String columnName, String jdbcType, boolean ignoreCase) throws SQLException {
        if (tableName == null) {
            throw new SQLException("TableName was null.  You must specify a valid table name.");
        }
        if (columnName == null) {
            throw new SQLException("Column name was null.  You must specify a valid column name.");
        }
        ResultSet columns = this.getColumns(tableName);
        if (columns == null) {
            PreparedStatement checkTable = null;
            try {
                checkTable = this.m_connection.prepareStatement("Select * from " + tableName + " where 1=0");
                columns = checkTable.executeQuery();
                this.putColumns(tableName, columns);
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().startsWith(m_ORA_EXCEPTION_1000) || sqle.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                    System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                    this.resetConnection();
                    this.exists(tableName, columnName, jdbcType, ignoreCase);
                }
                throw sqle;
            }
        }
        ResultSetMetaData rsMeta = columns.getMetaData();
        int iColumns = rsMeta.getColumnCount();
        int jdbcTypeConst = this.getJdbcType(jdbcType);
        for (int i = 1; i <= iColumns; ++i) {
            if (ignoreCase) {
                if (!columnName.equalsIgnoreCase(rsMeta.getColumnName(i))) continue;
                if (jdbcTypeConst != rsMeta.getColumnType(i)) {
                    throw new SQLException("The column '" + tableName + "." + columnName + "' is of type '" + rsMeta.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + jdbcType + "'.");
                }
                return;
            }
            if (!columnName.equals(rsMeta.getColumnName(i))) continue;
            if (jdbcTypeConst != rsMeta.getColumnType(i)) {
                throw new SQLException("The column '" + tableName + "." + columnName + "' is of type '" + rsMeta.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + jdbcType + "'.");
            }
            return;
        }
        throw new SQLException("The column '" + columnName + "' was not found in table '" + tableName + "'.");
    }

    public void existsUseWarnings(String tableName, String columnName, String jdbcType, boolean ignoreCase) throws SQLException, SQLWarning {
        if (tableName == null) {
            throw new SQLException("TableName was null.  You must specify a valid table name.");
        }
        if (columnName == null) {
            throw new SQLException("Column name was null.  You must specify a valid column name.");
        }
        ResultSet columns = this.getColumns(tableName);
        if (columns == null) {
            try {
                PreparedStatement checkTable = this.m_connection.prepareStatement("Select * from " + tableName + " where 1=0");
                columns = checkTable.executeQuery();
                this.putColumns(tableName, columns);
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().startsWith(m_ORA_EXCEPTION_1000) || sqle.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                    System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                    this.resetConnection();
                    this.existsUseWarnings(tableName, columnName, jdbcType, ignoreCase);
                }
                throw sqle;
            }
        }
        ResultSetMetaData rsMeta = columns.getMetaData();
        int iColumns = rsMeta.getColumnCount();
        int jdbcTypeConst = this.getJdbcType(jdbcType);
        for (int i = 1; i <= iColumns; ++i) {
            if (ignoreCase) {
                if (!columnName.equalsIgnoreCase(rsMeta.getColumnName(i))) continue;
                if (jdbcTypeConst != rsMeta.getColumnType(i)) {
                    throw new SQLWarning("The column '" + tableName + "." + columnName + "' is of type '" + rsMeta.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + jdbcType + "'.");
                }
                return;
            }
            if (!columnName.equals(rsMeta.getColumnName(i))) continue;
            if (jdbcTypeConst != rsMeta.getColumnType(i)) {
                throw new SQLWarning("The column '" + tableName + "." + columnName + "' is of type '" + rsMeta.getColumnTypeName(i) + "' and cannot be mapped to the jdbc type '" + jdbcType + "'.");
            }
            return;
        }
        throw new SQLException("The column '" + columnName + "' was not found in table '" + tableName + "'.");
    }

    public void exists(String tableName, String columnName, boolean ignoreCase) throws SQLException {
        if (tableName == null) {
            throw new SQLException("TableName was null.  You must specify a valid table name.");
        }
        if (columnName == null) {
            throw new SQLException("Column name was null.  You must specify a valid column name.");
        }
        ResultSet columns = this.getColumns(tableName);
        if (columns == null) {
            try {
                PreparedStatement checkTable = this.m_connection.prepareStatement("Select * from " + tableName + " where 1=0");
                columns = checkTable.executeQuery();
                this.putColumns(tableName, columns);
            }
            catch (SQLException sqle) {
                if (sqle.getMessage().startsWith(m_ORA_EXCEPTION_1000) || sqle.getMessage().startsWith(m_ORA_EXCEPTION_604)) {
                    System.out.println("Exceeded available Oracle cursors.  Resetting connection and trying the SQL statement again...");
                    this.resetConnection();
                    this.exists(tableName, columnName, ignoreCase);
                }
                System.out.println(sqle.getMessage());
                throw sqle;
            }
        }
        ResultSetMetaData rsMeta = columns.getMetaData();
        int iColumns = rsMeta.getColumnCount();
        for (int i = 1; i <= iColumns; ++i) {
            if (!(ignoreCase ? columnName.equalsIgnoreCase(rsMeta.getColumnName(i)) : columnName.equals(rsMeta.getColumnName(i)))) continue;
            return;
        }
        throw new SQLException("The column '" + columnName + "' was not found in table '" + tableName + "'.");
    }

    /*
     * WARNING - void declaration
     */
    public int getJdbcType(String ojbType) throws SQLException {
        void var2_2;
        int result;
        if (ojbType == null) {
            ojbType = "";
        }
        if ((ojbType = ojbType.toLowerCase()).equals("bit")) {
            result = -7;
        } else if (ojbType.equals("tinyint")) {
            result = -6;
        } else if (ojbType.equals("smallint")) {
            result = 5;
        } else if (ojbType.equals("integer")) {
            result = 4;
        } else if (ojbType.equals("bigint")) {
            result = -5;
        } else if (ojbType.equals("float")) {
            result = 6;
        } else if (ojbType.equals("real")) {
            result = 7;
        } else if (ojbType.equals("double")) {
            result = 8;
        } else if (ojbType.equals("numeric")) {
            result = 2;
        } else if (ojbType.equals("decimal")) {
            result = 3;
        } else if (ojbType.equals("char")) {
            result = 1;
        } else if (ojbType.equals("varchar")) {
            result = 12;
        } else if (ojbType.equals("longvarchar")) {
            result = -1;
        } else if (ojbType.equals("date")) {
            result = 91;
        } else if (ojbType.equals("time")) {
            result = 92;
        } else if (ojbType.equals("timestamp")) {
            result = 93;
        } else if (ojbType.equals("binary")) {
            result = -2;
        } else if (ojbType.equals("varbinary")) {
            result = -3;
        } else if (ojbType.equals("longvarbinary")) {
            result = -4;
        } else if (ojbType.equals("clob")) {
            result = 2005;
        } else if (ojbType.equals("blob")) {
            result = 2004;
        } else {
            throw new SQLException("The type '" + ojbType + "' is not a valid jdbc type.");
        }
        return (int)var2_2;
    }

    protected void finalize() {
        try {
            this.release();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

