/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.StatementsForClassIF;
import org.apache.ojb.broker.accesslayer.sql.SqlGenerator;
import org.apache.ojb.broker.accesslayer.sql.SqlGeneratorFactory;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.platforms.Platform;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.platforms.PlatformFactory;
import org.apache.ojb.broker.util.ProxyHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class StatementsForClassImpl
implements StatementsForClassIF {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl == null ? (class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl = StatementsForClassImpl.class$("org.apache.ojb.broker.accesslayer.StatementsForClassImpl")) : class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl);
    protected final ClassDescriptor classDescriptor;
    protected SqlGenerator sqlGenerator;
    protected Platform platform;
    protected Class clazz;
    private String deleteSql;
    private String insertSql;
    private String updateSql;
    private String selectByPKSql;
    protected boolean FORCEJDBC1_0 = false;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$StatementsForClassImpl;

    public StatementsForClassImpl(JdbcConnectionDescriptor jcd, ClassDescriptor classDescriptor) {
        this.classDescriptor = classDescriptor;
        this.clazz = classDescriptor.getClassOfObject();
        this.platform = PlatformFactory.getPlatformFor(jcd);
        this.sqlGenerator = SqlGeneratorFactory.getInstance().createSqlGenerator(this.platform);
        double level = jcd.getJdbcLevel();
        this.FORCEJDBC1_0 = level == 1.0;
    }

    public boolean isCached(Statement stmt) {
        return false;
    }

    protected boolean usePreparedStatement() {
        return this.classDescriptor.getUpdateProcedure() == null || !this.classDescriptor.getUpdateProcedure().hasReturnValues();
    }

    public PreparedStatement getDeleteStmt(Connection con) throws SQLException {
        if (this.deleteSql == null) {
            this.deleteSql = this.sqlGenerator.getPreparedDeleteStatement(this.classDescriptor);
        }
        try {
            return this.prepareStatement(con, this.deleteSql, false, this.usePreparedStatement());
        }
        catch (SQLException ex) {
            this.log.error(ex);
            throw ex;
        }
    }

    public Statement getGenericStmt(Connection con, boolean scrollable) throws PersistenceBrokerSQLException {
        Statement stmt = null;
        try {
            stmt = this.createStatement(con, scrollable);
        }
        catch (SQLException ex) {
            this.log.error(ex);
            throw new PersistenceBrokerSQLException(ex);
        }
        return stmt;
    }

    public PreparedStatement getInsertStmt(Connection con) throws SQLException {
        if (this.insertSql == null) {
            this.insertSql = this.sqlGenerator.getPreparedInsertStatement(this.classDescriptor);
        }
        try {
            return this.prepareStatement(con, this.insertSql, false, this.usePreparedStatement());
        }
        catch (SQLException ex) {
            this.log.error(ex);
            throw ex;
        }
    }

    public PreparedStatement getPreparedStmt(Connection con, String sql, boolean scrollable) throws PersistenceBrokerSQLException {
        PreparedStatement stmt = null;
        try {
            stmt = this.prepareStatement(con, sql, scrollable);
        }
        catch (SQLException ex) {
            this.log.error(ex);
            throw new PersistenceBrokerSQLException(ex);
        }
        return stmt;
    }

    public PreparedStatement getSelectByPKStmt(Connection con) throws SQLException {
        if (this.selectByPKSql == null) {
            this.selectByPKSql = this.sqlGenerator.getPreparedSelectByPkStatement(this.classDescriptor);
        }
        try {
            return this.prepareStatement(con, this.selectByPKSql, false);
        }
        catch (SQLException ex) {
            this.log.error(ex);
            throw ex;
        }
    }

    public PreparedStatement getUpdateStmt(Connection con) throws SQLException {
        if (this.updateSql == null) {
            this.updateSql = this.sqlGenerator.getPreparedUpdateStatement(this.classDescriptor);
        }
        try {
            return this.prepareStatement(con, this.updateSql, false, this.usePreparedStatement());
        }
        catch (SQLException ex) {
            this.log.error(ex);
            throw ex;
        }
    }

    protected PreparedStatement prepareStatement(Connection con, String sql, boolean scrollable) throws SQLException {
        return this.prepareStatement(con, sql, scrollable, true);
    }

    protected PreparedStatement prepareStatement(Connection con, String sql, boolean scrollable, boolean createPreparedStatement) throws SQLException {
        PreparedStatement result = null;
        try {
            result = !this.FORCEJDBC1_0 ? (createPreparedStatement ? con.prepareStatement(sql, scrollable ? 1004 : 1003, 1007) : con.prepareCall(sql, scrollable ? 1004 : 1003, 1007)) : (createPreparedStatement ? con.prepareStatement(sql) : con.prepareCall(sql));
        }
        catch (AbstractMethodError err) {
            this.log.warn("Used driver seems not JDBC 2.0 compatible, use the JDBC 1.0 mode", err);
            result = createPreparedStatement ? con.prepareStatement(sql) : con.prepareCall(sql);
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException eSql) {
            if (eSql.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                this.log.warn("JDBC 2.0 problems with this interbase driver, we use the JDBC 1.0 mode");
                result = createPreparedStatement ? con.prepareStatement(sql) : con.prepareCall(sql);
                this.FORCEJDBC1_0 = true;
            }
            throw eSql;
        }
        try {
            if (!ProxyHelper.isNormalOjbProxy(result)) {
                this.platform.afterStatementCreate(result);
            }
        }
        catch (PlatformException e) {
            this.log.error("Platform dependend failure", (Throwable)((Object)e));
        }
        return result;
    }

    private Statement createStatement(Connection con, boolean scrollable) throws SQLException {
        Statement result = null;
        try {
            result = !this.FORCEJDBC1_0 ? con.createStatement(scrollable ? 1004 : 1003, 1007) : con.createStatement();
        }
        catch (AbstractMethodError err) {
            this.log.warn("Used driver seems not JDBC 2.0 compatible, use the JDBC 1.0 mode", err);
            result = con.createStatement();
            this.FORCEJDBC1_0 = true;
        }
        catch (SQLException eSql) {
            if (eSql.getClass().getName().equals("interbase.interclient.DriverNotCapableException")) {
                this.log.warn("JDBC 2.0 problems with this interbase driver, we use the JDBC 1.0 mode");
                this.FORCEJDBC1_0 = true;
                result = con.createStatement();
            }
            throw eSql;
        }
        try {
            this.platform.afterStatementCreate(result);
        }
        catch (PlatformException e) {
            this.log.error("Platform dependend failure", (Throwable)((Object)e));
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

