/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.accesslayer.RowReader;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ConstructorHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class RowReaderDefaultImpl
implements RowReader {
    private ClassDescriptor m_cld;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl;

    public RowReaderDefaultImpl(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public Object readObjectFrom(Map row) throws PersistenceBrokerException {
        ClassDescriptor cld = this.selectClassDescriptor(row);
        return this.buildWithReflection(row, cld);
    }

    public void readObjectArrayFrom(ResultSet rs, Map row) {
        FieldDescriptor[] fields = null;
        fields = this.m_cld.getSuperClass() != null ? this.m_cld.getFieldDescriptorsInHeirarchy() : this.m_cld.getRepository().getFieldDescriptorsForMultiMappedTable(this.m_cld);
        int size = fields.length;
        Object val = null;
        try {
            for (int j = 0; j < size; ++j) {
                FieldDescriptor fld = fields[j];
                val = fld.getJdbcType().getObjectFromColumn(rs, fld.getColumnName());
                row.put(fld.getColumnName(), fld.getFieldConversion().sqlToJava(val));
            }
        }
        catch (SQLException t) {
            throw new PersistenceBrokerException("Error reading class type: " + this.m_cld.getClassNameOfObject() + " from result set", t);
        }
    }

    protected ClassDescriptor selectClassDescriptor(Map row) throws PersistenceBrokerException {
        FieldDescriptor concreteClassFD = this.m_cld.getOjbConcreteClassField();
        if (concreteClassFD == null) {
            return this.m_cld;
        }
        try {
            String concreteClass = (String)row.get(concreteClassFD.getColumnName());
            if (concreteClass == null || concreteClass.trim().length() == 0) {
                throw new PersistenceBrokerException("ojbConcreteClass field returned null or 0-length string");
            }
            concreteClass = concreteClass.trim();
            ClassDescriptor result = this.m_cld.getRepository().getDescriptorFor(concreteClass);
            if (result == null) {
                LoggerFactory.getDefaultLogger().warn("[" + (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl == null ? (class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl = RowReaderDefaultImpl.class$("org.apache.ojb.broker.accesslayer.RowReaderDefaultImpl")) : class$org$apache$ojb$broker$accesslayer$RowReaderDefaultImpl).getName() + "] Can not find class-descriptor for ojbConcreteClass " + concreteClass + ", use given class-descriptor '" + this.m_cld.getClassNameOfObject() + "' instead");
                result = this.m_cld;
            }
            return result;
        }
        catch (PBFactoryException e) {
            throw new PersistenceBrokerException((Throwable)((Object)e));
        }
    }

    protected Object buildWithReflection(Map row, ClassDescriptor targetClassDescriptor) {
        Object result = null;
        FieldDescriptor fmd = null;
        if (null == targetClassDescriptor.getFactoryClass() || null == targetClassDescriptor.getFactoryMethod()) {
            try {
                Constructor con = targetClassDescriptor.getZeroArgumentConstructor();
                result = ConstructorHelper.instantiate(con);
            }
            catch (Exception ex) {
                throw new PersistenceBrokerException("Unable to build object instance (MAYBE you don't have a constructor available):" + this.m_cld.getClassOfObject(), ex);
            }
        }
        try {
            Method method = targetClassDescriptor.getFactoryMethod();
            if (Modifier.isStatic(method.getModifiers())) {
                result = method.invoke(null, null);
            } else {
                Object factoryInstance = targetClassDescriptor.getFactoryClass().newInstance();
                result = method.invoke(factoryInstance, null);
            }
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException("Unable to build object instance of class " + this.m_cld.getClassOfObject() + " from factory:" + this.m_cld.getFactoryClass() + "." + this.m_cld.getFactoryMethod(), ex);
        }
        if (null != result) {
            FieldDescriptor[] fields = targetClassDescriptor.getFieldDescriptions();
            for (int i = 0; i < fields.length; ++i) {
                fmd = fields[i];
                fmd.getPersistentField().set(result, row.get(fmd.getColumnName()));
            }
            Method initializationMethod = targetClassDescriptor.getInitializationMethod();
            Object[] noArgs = new Object[]{};
            if (initializationMethod != null) {
                try {
                    initializationMethod.invoke(result, noArgs);
                }
                catch (Exception ex) {
                    throw new PersistenceBrokerException("Unable to invoke initialization method:" + initializationMethod.getName() + " for class:" + this.m_cld.getClassOfObject(), ex);
                }
            }
        }
        return result;
    }

    protected Object buildWithMultiArgsConstructor(Map row, Constructor multiArgsConstructor) throws SQLException, InstantiationException, IllegalAccessException, InvocationTargetException, PersistenceBrokerException {
        Object[] rowArray = row.values().toArray();
        Object result = multiArgsConstructor.newInstance(rowArray);
        return result;
    }

    public void readPkValuesFrom(ResultSet rs, Map row) {
        try {
            FieldDescriptor[] pkFields = this.m_cld.getPkFields();
            for (int i = 0; i < pkFields.length; ++i) {
                FieldDescriptor fld = pkFields[i];
                Object val = fld.getJdbcType().getObjectFromColumn(rs, fld.getColumnName());
                row.put(fld.getColumnName(), fld.getFieldConversion().sqlToJava(val));
            }
        }
        catch (SQLException t) {
            throw new PersistenceBrokerException("Error reading from result set", t);
        }
    }

    public void setClassDescriptor(ClassDescriptor cld) {
        this.m_cld = cld;
    }

    public ClassDescriptor getClassDescriptor() {
        return this.m_cld;
    }

    public void refreshObject(Object instance, Map row) {
        ClassDescriptor targetClassDescriptor = this.selectClassDescriptor(row);
        FieldDescriptor[] fields = targetClassDescriptor.getFieldDescriptions();
        for (int i = 0; i < fields.length; ++i) {
            FieldDescriptor fmd = fields[i];
            fmd.getPersistentField().set(instance, row.get(fmd.getColumnName()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

