/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.accesslayer.RelationshipPrefetcherImpl;
import org.apache.ojb.broker.cache.ObjectCache;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ObjectReferenceDescriptor;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentField;
import org.apache.ojb.broker.query.Query;

public class ReferencePrefetcher
extends RelationshipPrefetcherImpl {
    public ReferencePrefetcher(PersistenceBroker aBroker, ObjectReferenceDescriptor anOrd) {
        super(aBroker, anOrd);
    }

    protected void associateBatched(Collection owners, Collection children) {
        Object relatedObject;
        ObjectReferenceDescriptor ord = this.getObjectReferenceDescriptor();
        ClassDescriptor cld = this.getOwnerClassDescriptor();
        PersistenceBroker pb = this.getBroker();
        PersistentField field = ord.getPersistentField();
        Class topLevelClass = pb.getTopLevelClass(ord.getItemClass());
        HashMap childrenMap = new HashMap();
        Iterator it = children.iterator();
        while (it.hasNext()) {
            relatedObject = it.next();
            childrenMap.put(new Identity(relatedObject, pb), relatedObject);
        }
        it = owners.iterator();
        while (it.hasNext()) {
            Object owner = it.next();
            Object[] fkValues = ord.getForeignKeyValues(owner, cld);
            if (this.isNull(fkValues)) {
                field.set(owner, null);
                continue;
            }
            Identity id = new Identity(null, topLevelClass, fkValues);
            relatedObject = childrenMap.get(id);
            field.set(owner, relatedObject);
        }
    }

    private boolean isNull(Object[] arr) {
        for (int i = 0; i < arr.length; ++i) {
            if (arr[i] == null) continue;
            return false;
        }
        return true;
    }

    protected Query[] buildPrefetchQueries(Collection owners, Collection children) {
        ClassDescriptor cld = this.getOwnerClassDescriptor();
        ObjectReferenceDescriptor ord = this.getObjectReferenceDescriptor();
        ArrayList<Query> queries = new ArrayList<Query>();
        HashSet<Identity> idsSubset = new HashSet<Identity>();
        Iterator iter = owners.iterator();
        Class topLevelClass = this.getBroker().getTopLevelClass(ord.getItemClass());
        PersistenceBroker pb = this.getBroker();
        ObjectCache cache = pb.serviceObjectCache();
        while (iter.hasNext()) {
            Object owner = iter.next();
            Object[] fkValues = ord.getForeignKeyValues(owner, cld);
            if (this.isNull(fkValues)) continue;
            Identity id = new Identity(null, topLevelClass, fkValues);
            if (cache.lookup(id) != null) {
                children.add(pb.getObjectByIdentity(id));
                continue;
            }
            idsSubset.add(id);
            if (idsSubset.size() != this.pkLimit) continue;
            queries.add(this.buildPrefetchQuery(idsSubset));
            idsSubset.clear();
        }
        if (idsSubset.size() > 0) {
            queries.add(this.buildPrefetchQuery(idsSubset));
        }
        return queries.toArray(new Query[queries.size()]);
    }

    protected Query buildPrefetchQuery(Collection ids) {
        return this.buildPrefetchQuery(ids, this.getItemClassDescriptor().getPkFields());
    }
}

