/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerSQLException;
import org.apache.ojb.broker.accesslayer.ResultSetAndStatement;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.util.ConstructorHelper;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class PkEnumeration
implements Enumeration,
Serializable {
    static final long serialVersionUID = -834955711995869884L;
    protected boolean hasCalledCheck = false;
    protected boolean hasNext = false;
    protected PersistenceBroker broker;
    protected ResultSetAndStatement resultSetAndStatment;
    protected ClassDescriptor classDescriptor;
    protected Constructor constructor;
    static /* synthetic */ Class class$org$apache$ojb$broker$Identity;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$PkEnumeration;

    public PkEnumeration(Query query, ClassDescriptor cld, Class primaryKeyClass, PersistenceBroker broker) {
        this.resultSetAndStatment = broker.serviceJdbcAccess().executeQuery(query, cld);
        this.classDescriptor = cld;
        this.broker = broker;
        try {
            Class[] argArray = new Class[]{class$org$apache$ojb$broker$Identity == null ? (class$org$apache$ojb$broker$Identity = PkEnumeration.class$("org.apache.ojb.broker.Identity")) : class$org$apache$ojb$broker$Identity};
            this.constructor = primaryKeyClass.getConstructor(argArray);
        }
        catch (NoSuchMethodException e) {
            LoggerFactory.getDefaultLogger().error(primaryKeyClass.getName() + " must implement a Constructor with one argument of type org.apache.ojb.broker.Identity");
            throw new PersistenceBrokerException(e);
        }
        catch (SecurityException e) {
            LoggerFactory.getDefaultLogger().error(e);
            throw new PersistenceBrokerException(e);
        }
    }

    private Identity getIdentityFromResultSet() {
        try {
            Constructor con = this.classDescriptor.getZeroArgumentConstructor();
            Object obj = ConstructorHelper.instantiate(con);
            FieldDescriptor[] pkfields = this.classDescriptor.getPkFields();
            for (int i = 0; i < pkfields.length; ++i) {
                FieldDescriptor fld = pkfields[i];
                Object colValue = fld.getJdbcType().getObjectFromColumn(this.resultSetAndStatment.m_rs, fld.getColumnName());
                fld.getPersistentField().set(obj, colValue);
            }
            Identity result = new Identity(obj, this.broker, this.classDescriptor);
            return result;
        }
        catch (SQLException e) {
            throw new PersistenceBrokerSQLException("Error reading object from column", e);
        }
        catch (Exception e) {
            throw new PersistenceBrokerException("Error reading Identity from result set", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMoreElements() {
        try {
            if (!this.hasCalledCheck) {
                this.hasCalledCheck = true;
                this.hasNext = this.resultSetAndStatment.m_rs.next();
            }
        }
        catch (SQLException e) {
            LoggerFactory.getDefaultLogger().error(e);
            this.hasNext = false;
        }
        finally {
            if (!this.hasNext) {
                this.releaseDbResources();
            }
        }
        return this.hasNext;
    }

    private void releaseDbResources() {
        this.resultSetAndStatment.close();
        this.resultSetAndStatment = null;
    }

    public Object nextElement() {
        try {
            if (!this.hasCalledCheck) {
                this.hasMoreElements();
            }
            this.hasCalledCheck = false;
            if (this.hasNext) {
                Identity oid = this.getIdentityFromResultSet();
                Object[] args = new Identity[]{oid};
                return this.constructor.newInstance(args);
            }
            throw new NoSuchElementException();
        }
        catch (Exception ex) {
            LoggerFactory.getDefaultLogger().error(ex);
            throw new NoSuchElementException();
        }
    }

    protected void finalize() {
        if (this.resultSetAndStatment != null) {
            LoggerFactory.getDefaultLogger().error("[" + (class$org$apache$ojb$broker$accesslayer$PkEnumeration == null ? (class$org$apache$ojb$broker$accesslayer$PkEnumeration = PkEnumeration.class$("org.apache.ojb.broker.accesslayer.PkEnumeration")) : class$org$apache$ojb$broker$accesslayer$PkEnumeration).getName() + "] Found unclosed resources while finalize");
            this.releaseDbResources();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

