/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.MaterializationListener;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class IndirectionHandler
implements InvocationHandler,
Serializable {
    static final long serialVersionUID = -1993879565033755826L;
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$IndirectionHandler == null ? (class$org$apache$ojb$broker$accesslayer$IndirectionHandler = IndirectionHandler.class$("org.apache.ojb.broker.accesslayer.IndirectionHandler")) : class$org$apache$ojb$broker$accesslayer$IndirectionHandler);
    private transient PersistenceBroker m_broker = null;
    private PBKey brokerKey;
    private Object realSubject = null;
    private Identity id = null;
    private transient ArrayList listeners;
    private boolean needsClose;
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$IndirectionHandler;

    public IndirectionHandler(PBKey key, Identity oid) {
        this.id = oid;
        this.setBrokerKey(key);
    }

    public synchronized void addListener(MaterializationListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public synchronized void removeListener(MaterializationListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    protected void beforeMaterialization() {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                MaterializationListener l = (MaterializationListener)this.listeners.get(i);
                l.beforeMaterialization(this, this.id);
            }
        }
    }

    protected void afterMaterialization() {
        if (this.listeners != null) {
            for (int i = this.listeners.size() - 1; i >= 0; --i) {
                MaterializationListener l = (MaterializationListener)this.listeners.get(i);
                l.afterMaterialization(this, this.realSubject);
            }
        }
    }

    public Identity getIdentity() {
        return this.id;
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker broker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (broker == null && this.m_broker == null) {
            this.m_broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this.needsClose = true;
            broker = this.m_broker;
        }
        return broker;
    }

    protected void releaseBroker() {
        if (this.m_broker != null && this.needsClose) {
            this.needsClose = false;
            this.m_broker.close();
            this.m_broker = null;
        }
    }

    public Object invoke(Object proxy, Method method, Object[] args) {
        Object subject = null;
        String methodName = method.getName();
        try {
            if ("hashCode".equals(methodName)) {
                return new Integer(this.id.hashCode());
            }
            if (this.realSubject == null && "toString".equals(methodName)) {
                return "unmaterialized proxy for " + this.id;
            }
            subject = this.getRealSubject();
            return method.invoke(subject, args);
        }
        catch (Exception e) {
            log.error("Method invoking failed for method *" + method.getName() + "* on object " + subject, e);
            throw new PersistenceBrokerException("Error invoking:" + method.getName(), e);
        }
    }

    public Object getRealSubject() throws PersistenceBrokerException {
        if (this.realSubject == null) {
            this.materializeSubject();
        }
        return this.realSubject;
    }

    public void setRealSubject(Object object) {
        this.realSubject = object;
    }

    private synchronized void materializeSubject() throws PersistenceBrokerException {
        try {
            this.beforeMaterialization();
            this.realSubject = this.getBroker().getObjectByIdentity(this.id);
            if (this.realSubject == null) {
                log.warn("Can not materialize object for Identity " + this.id + " - using PBKey " + this.brokerKey);
            }
            this.afterMaterialization();
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker();
        }
    }

    public boolean alreadyMaterialized() {
        return this.realSubject != null;
    }

    protected PBKey getBrokerKey() {
        return this.brokerKey;
    }

    protected void setBrokerKey(PBKey brokerKey) {
        this.brokerKey = brokerKey;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

