/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryPooledImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryPooledImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl);
    private Map connectionPools = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryPooledImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor;

    public void returnConnectionToPool(JdbcConnectionDescriptor jcd, Connection con) throws LookupException {
        try {
            ((ObjectPool)this.connectionPools.get(jcd.getPBKey())).returnObject((Object)con);
        }
        catch (Exception e) {
            throw new LookupException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnectionFromPool(JdbcConnectionDescriptor jcd) throws LookupException {
        ObjectPool op = (ObjectPool)this.connectionPools.get(jcd.getPBKey());
        if (op == null) {
            this.log.info("Create new connection pool:" + jcd);
            op = this.createConnectionPool(jcd);
            Map map = this.connectionPools;
            synchronized (map) {
                this.connectionPools.put(jcd.getPBKey(), op);
            }
        }
        try {
            return (Connection)op.borrowObject();
        }
        catch (Exception e) {
            throw new LookupException("Could not borrow connection from pool - " + (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor == null ? (class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor = ConnectionFactoryPooledImpl.class$("org.apache.ojb.broker.metadata.JdbcConnectionDescriptor")) : class$org$apache$ojb$broker$metadata$JdbcConnectionDescriptor).getName() + ":  " + jcd, e);
        }
    }

    public ObjectPool createConnectionPool(JdbcConnectionDescriptor jcd) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("createPool was called");
        }
        ConPoolFactory pof = new ConPoolFactory(this, jcd);
        GenericObjectPool.Config conf = jcd.getConnectionPoolDescriptor().getObjectPoolConfig();
        GenericObjectPool op = new GenericObjectPool((PoolableObjectFactory)pof, conf);
        return op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAllResources() {
        super.releaseAllResources();
        Map map = this.connectionPools;
        synchronized (map) {
            Collection pools = this.connectionPools.values();
            this.connectionPools = new HashMap();
            ObjectPool op = null;
            Iterator iterator = pools.iterator();
            while (iterator.hasNext()) {
                try {
                    op = (ObjectPool)iterator.next();
                    op.close();
                }
                catch (Exception e) {
                    this.log.error("Exception occured while closing pool " + op, e);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class ConPoolFactory
    extends BasePoolableObjectFactory {
        int failedValidationQuery;
        JdbcConnectionDescriptor jcd;
        ConnectionFactoryPooledImpl cf;

        public ConPoolFactory(ConnectionFactoryPooledImpl cf, JdbcConnectionDescriptor jcd) {
            this.cf = cf;
            this.jcd = jcd;
        }

        public boolean validateObject(Object obj) {
            Connection con = (Connection)obj;
            String query = this.jcd.getConnectionPoolDescriptor().getValidationQuery();
            if (query == null || query.trim().equals("")) {
                try {
                    return !con.isClosed();
                }
                catch (SQLException e) {
                    ConnectionFactoryPooledImpl.this.log.warn("Connection validation failed: " + e.getMessage());
                    if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                        ConnectionFactoryPooledImpl.this.log.debug(e);
                    }
                    return false;
                }
            }
            return this.validateConnection(con, query);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean validateConnection(Connection conn, String query) {
            Statement stmt = null;
            ResultSet rset = null;
            if (this.failedValidationQuery > 100) {
                throw new OJBRuntimeException("Validation of connection " + conn + " using validation query " + query + " failed more than 100 times.");
            }
            try {
                stmt = conn.createStatement();
                rset = stmt.executeQuery(query);
                if (rset.next()) {
                    this.failedValidationQuery = 0;
                    boolean bl = true;
                    return bl;
                }
                ++this.failedValidationQuery;
                ConnectionFactoryPooledImpl.this.log.warn("Validation query '" + query + "' result set does not match, discard connection");
                boolean bl = false;
                return bl;
            }
            catch (SQLException e) {
                ++this.failedValidationQuery;
                ConnectionFactoryPooledImpl.this.log.warn("Validation query for connection failed, discard connection. Query was " + query + ", Message was " + e.getMessage());
                if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                    ConnectionFactoryPooledImpl.this.log.debug(e);
                }
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    rset.close();
                }
                catch (Exception t) {}
                try {
                    stmt.close();
                }
                catch (Exception t) {}
            }
        }

        public Object makeObject() throws Exception {
            if (ConnectionFactoryPooledImpl.this.log.isDebugEnabled()) {
                ConnectionFactoryPooledImpl.this.log.debug("makeObject called");
            }
            return this.cf.newConnectionFromDriverManager(this.jcd);
        }

        public void destroyObject(Object obj) throws Exception {
            ConnectionFactoryPooledImpl.this.log.info("Destroy object was called, try to close connection: " + obj);
            try {
                ((Connection)obj).close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

