/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.dbcp.AbandonedConfig;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.pool.KeyedObjectPoolFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericKeyedObjectPoolFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.ojb.broker.accesslayer.ConnectionFactoryAbstractImpl;
import org.apache.ojb.broker.accesslayer.LookupException;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class ConnectionFactoryDBCPImpl
extends ConnectionFactoryAbstractImpl {
    private Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl == null ? (class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl = ConnectionFactoryDBCPImpl.class$("org.apache.ojb.broker.accesslayer.ConnectionFactoryDBCPImpl")) : class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl);
    private Map poolMap = new HashMap();
    static /* synthetic */ Class class$org$apache$ojb$broker$accesslayer$ConnectionFactoryDBCPImpl;

    public Connection getConnectionFromPool(JdbcConnectionDescriptor jcd) throws LookupException {
        DataSource ds = (DataSource)this.poolMap.get(jcd.getPBKey());
        if (ds == null) {
            try {
                ds = this.setupPool(jcd);
                this.poolMap.put(jcd.getPBKey(), ds);
            }
            catch (Exception e) {
                this.log.error("Could not setup DataSource for " + jcd, e);
                throw new LookupException(e);
            }
        }
        try {
            Connection con = ds.getConnection();
            return con;
        }
        catch (SQLException e) {
            throw new LookupException("Can't get connection from DBCP-DataSource", e);
        }
    }

    public void returnConnectionToPool(JdbcConnectionDescriptor jcd, Connection con) throws LookupException {
        try {
            con.close();
        }
        catch (SQLException e) {
            this.log.warn("Connection close failed", e);
        }
    }

    protected DataSource setupPool(JdbcConnectionDescriptor jcd) throws Exception {
        this.log.info("Create new DBCP connection pool:" + jcd);
        try {
            ClassHelper.newInstance(jcd.getDriver());
        }
        catch (Exception e) {
            this.log.error("Could not instantiate jdbc driver", e);
        }
        GenericObjectPool.Config conf = jcd.getConnectionPoolDescriptor().getObjectPoolConfig();
        ObjectPool connectionPool = this.createObjectPool(conf);
        ConnectionFactory connectionFactory = this.createConnectionFactory(jcd);
        KeyedObjectPoolFactory statementPoolFactory = this.createStatementPoolFactory(null);
        String validationQuery = jcd.getConnectionPoolDescriptor().getValidationQuery();
        boolean defaultReadOnly = false;
        boolean defaultAutoCommit = jcd.getUseAutoCommit() != 2;
        AbandonedConfig ac = jcd.getConnectionPoolDescriptor().getAbandonedConfig();
        PoolableConnectionFactory poolableConnectionFactory = new PoolableConnectionFactory(connectionFactory, connectionPool, statementPoolFactory, validationQuery, defaultReadOnly, defaultAutoCommit, ac);
        PoolingDataSource dataSource = this.createPoolingDataSource(poolableConnectionFactory.getPool());
        return dataSource;
    }

    protected ObjectPool createObjectPool(GenericObjectPool.Config config) {
        return new GenericObjectPool(null, config);
    }

    protected ConnectionFactory createConnectionFactory(JdbcConnectionDescriptor jcd) {
        return new DriverManagerConnectionFactory(this.getDbURL(jcd), jcd.getUserName(), jcd.getPassWord());
    }

    protected KeyedObjectPoolFactory createStatementPoolFactory(Object obj) {
        return new GenericKeyedObjectPoolFactory(null);
    }

    protected PoolingDataSource createPoolingDataSource(ObjectPool pool) {
        return new PoolingDataSource(pool);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

