/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.accesslayer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBFactoryException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.accesslayer.CollectionProxyListener;
import org.apache.ojb.broker.core.PersistenceBrokerThreadMapping;
import org.apache.ojb.broker.query.Query;

public class CollectionProxy
implements Collection,
ManageableCollection {
    private transient PersistenceBroker m_broker;
    private PBKey m_brokerKey;
    private Query m_query;
    private Collection m_data;
    private Class m_collectionClass;
    private int m_size = -1;
    private boolean needsClose;
    private transient ArrayList m_listeners;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$collections$RemovalAwareCollection;

    public CollectionProxy(PBKey aKey, Query aQuery) {
        this(aKey, class$org$apache$ojb$broker$util$collections$RemovalAwareCollection == null ? (class$org$apache$ojb$broker$util$collections$RemovalAwareCollection = CollectionProxy.class$("org.apache.ojb.broker.util.collections.RemovalAwareCollection")) : class$org$apache$ojb$broker$util$collections$RemovalAwareCollection, aQuery);
    }

    public CollectionProxy(PBKey aKey, Class aCollClass, Query aQuery) {
        this.setBrokerKey(aKey);
        this.setCollectionClass(aCollClass);
        this.setQuery(aQuery);
    }

    public boolean isLoaded() {
        return this.m_data != null;
    }

    protected synchronized void loadSize() throws PersistenceBrokerException {
        try {
            this.m_size = this.getBroker().getCount(this.getQuery());
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected Collection loadData() throws PersistenceBrokerException {
        try {
            Collection result = this.m_data != null ? this.m_data : (this.m_size != 0 ? (Collection)((Object)this.getBroker().getCollectionByQuery(this.getCollectionClass(), this.getQuery())) : (Collection)this.getCollectionClass().newInstance());
            Collection collection = result;
            return collection;
        }
        catch (Exception ex) {
            throw new PersistenceBrokerException(ex);
        }
        finally {
            this.releaseBroker();
        }
    }

    protected void beforeLoading() {
        if (this.m_listeners != null) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener l = (CollectionProxyListener)this.m_listeners.get(i);
                l.beforeLoading(this);
            }
        }
    }

    protected void afterLoading() {
        if (this.m_listeners != null) {
            for (int i = this.m_listeners.size() - 1; i >= 0; --i) {
                CollectionProxyListener l = (CollectionProxyListener)this.m_listeners.get(i);
                l.afterLoading(this);
            }
        }
    }

    public int size() {
        if (this.isLoaded()) {
            return this.getData().size();
        }
        if (this.m_size < 0) {
            this.loadSize();
        }
        return this.m_size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean contains(Object o) {
        return this.getData().contains(o);
    }

    public Iterator iterator() {
        return this.getData().iterator();
    }

    public Object[] toArray() {
        return this.getData().toArray();
    }

    public Object[] toArray(Object[] a) {
        return this.getData().toArray(a);
    }

    public boolean add(Object o) {
        return this.getData().add(o);
    }

    public boolean remove(Object o) {
        return this.getData().remove(o);
    }

    public boolean containsAll(Collection c) {
        return this.getData().containsAll(c);
    }

    public boolean addAll(Collection c) {
        return this.getData().addAll(c);
    }

    public boolean removeAll(Collection c) {
        return this.getData().removeAll(c);
    }

    public boolean retainAll(Collection c) {
        return this.getData().retainAll(c);
    }

    public void clear() {
        ArrayList coll;
        try {
            coll = (ArrayList)this.getCollectionClass().newInstance();
        }
        catch (Exception e) {
            coll = new ArrayList();
        }
        this.setData(coll);
        this.m_size = 0;
    }

    protected Query getQuery() {
        return this.m_query;
    }

    protected void setQuery(Query query) {
        this.m_query = query;
    }

    protected synchronized void releaseBroker() {
        if (this.m_broker != null && this.needsClose) {
            this.needsClose = false;
            this.m_broker.close();
            this.m_broker = null;
        }
    }

    protected synchronized PersistenceBroker getBroker() throws PBFactoryException {
        if (this.getBrokerKey() == null) {
            throw new OJBRuntimeException("Can't find associated PBKey. Need PBKey to obtain a validPersistenceBroker instance from intern resources.");
        }
        PersistenceBroker broker = PersistenceBrokerThreadMapping.currentPersistenceBroker(this.getBrokerKey());
        if (broker == null && this.m_broker == null) {
            this.m_broker = PersistenceBrokerFactory.createPersistenceBroker(this.getBrokerKey());
            this.needsClose = true;
            broker = this.m_broker;
        }
        return broker;
    }

    public synchronized Collection getData() {
        if (!this.isLoaded()) {
            this.beforeLoading();
            this.setData(this.loadData());
            this.afterLoading();
        }
        return this.m_data;
    }

    protected void setData(Collection data) {
        this.m_data = data;
    }

    protected Class getCollectionClass() {
        return this.m_collectionClass;
    }

    protected void setCollectionClass(Class collectionClass) {
        this.m_collectionClass = collectionClass;
    }

    public void ojbAdd(Object anObject) {
        this.add(anObject);
    }

    public void ojbAddAll(ManageableCollection otherCollection) {
        this.addAll((Collection)((CollectionProxy)otherCollection));
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void afterStore(PersistenceBroker broker) throws PersistenceBrokerException {
        Collection c = this.getData();
        if (c instanceof ManageableCollection) {
            ((ManageableCollection)((Object)c)).afterStore(broker);
        }
    }

    protected PBKey getBrokerKey() {
        return this.m_brokerKey;
    }

    protected void setBrokerKey(PBKey brokerKey) {
        this.m_brokerKey = brokerKey;
    }

    public synchronized void addListener(CollectionProxyListener l) {
        if (this.m_listeners == null) {
            this.m_listeners = new ArrayList();
        }
        this.m_listeners.add(l);
    }

    public synchronized void removeListener(CollectionProxyListener l) {
        if (this.m_listeners != null) {
            this.m_listeners.remove(l);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

