/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker;

import java.util.Collection;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.CollectionDescriptor;
import org.apache.ojb.broker.util.ProxyHelper;

public class MtoNImplementor {
    private Object _left;
    private Object _right;
    private CollectionDescriptor _collectionDesc;
    private PersistenceBroker _pb;

    public MtoNImplementor(PersistenceBroker pb, CollectionDescriptor cod, Object left, Object right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("both objects must exist");
        }
        this._pb = pb;
        this._collectionDesc = cod;
        this._left = left;
        this._right = right;
    }

    public MtoNImplementor(PersistenceBroker pb, String collectionName, Object left, Object right) {
        if (left == null || right == null) {
            throw new IllegalArgumentException("both objects must exist");
        }
        this._pb = pb;
        this._left = left;
        this._right = right;
        this._collectionDesc = pb.getClassDescriptor(ProxyHelper.getRealObject(this._left).getClass()).getCollectionDescriptorByName(collectionName);
    }

    public Object getLeftObject() {
        return this._left;
    }

    public Object getRightObject() {
        return this._right;
    }

    public CollectionDescriptor getCollectionDescriptor() {
        return this._collectionDesc;
    }

    public String getInsertStmt(Collection mnKeys) {
        this._left = ProxyHelper.getRealObject(this._left);
        String[] leftPkColumns = this._collectionDesc.getFksToThisClass();
        String[] rightPkColumns = this._collectionDesc.getFksToItemClass();
        String table = this._collectionDesc.getIndirectionTable();
        Key key = new Key(this.getRightPkValues());
        if (mnKeys.contains(key)) {
            return null;
        }
        return this._pb.serviceSqlGenerator().getInsertMNStatement(table, leftPkColumns, rightPkColumns);
    }

    public Object[] getLeftPkValues() {
        ClassDescriptor leftCld = this._pb.getDescriptorRepository().getDescriptorFor(this._left.getClass());
        return this._pb.serviceBrokerHelper().getKeyValues(leftCld, this._left);
    }

    public Object[] getRightPkValues() {
        ClassDescriptor rightCld = this._pb.getDescriptorRepository().getDescriptorFor(this._right.getClass());
        return this._pb.serviceBrokerHelper().getKeyValues(rightCld, this._right);
    }

    private static final class Key {
        final Object[] m_key;

        Key(Object[] aKey) {
            this.m_key = new Object[aKey.length];
            for (int i = 0; i < aKey.length; ++i) {
                this.m_key[i] = aKey[i] instanceof Number ? new Long(((Number)aKey[i]).longValue()) : aKey[i];
            }
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (!(other instanceof Key)) {
                return false;
            }
            Key otherKey = (Key)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.m_key, otherKey.m_key);
            return eb.isEquals();
        }

        public int hashCode() {
            HashCodeBuilder hb = new HashCodeBuilder();
            hb.append(this.m_key);
            return hb.toHashCode();
        }
    }
}

