/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.lock.isolation;

import java.util.Collection;
import org.apache.ojb.otm.core.Transaction;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.lock.ObjectLock;
import org.apache.ojb.otm.lock.isolation.AbstractIsolation;

public class SerializableIsolation
extends AbstractIsolation {
    public void readLock(Transaction transaction, ObjectLock objectLock) throws LockingException {
        Collection collection = objectLock.getReaders();
        if (collection.isEmpty()) {
            objectLock.readLock(transaction);
            collection = objectLock.getReaders();
            if (collection.size() > 1) {
                objectLock.releaseLock(transaction);
                this.readLock(transaction, objectLock);
            }
        } else {
            Transaction transaction2 = (Transaction)collection.iterator().next();
            if (transaction2 != transaction) {
                objectLock.waitForTx(transaction2);
            }
        }
    }

    public void writeLock(Transaction transaction, ObjectLock objectLock) throws LockingException {
        Collection collection = objectLock.getReaders();
        if (collection.isEmpty()) {
            this.readLock(transaction, objectLock);
            this.writeLock(transaction, objectLock);
        } else {
            Transaction transaction2 = (Transaction)collection.iterator().next();
            if (transaction2 == transaction) {
                objectLock.writeLock(transaction);
            } else {
                objectLock.waitForTx(transaction2);
                this.writeLock(transaction, objectLock);
            }
        }
    }
}

