/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.otm.copy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.util.IdentityMapFactory;
import org.apache.ojb.otm.copy.ObjectCopyException;
import org.apache.ojb.otm.copy.ObjectCopyStrategy;
import org.apache.ojb.otm.copy.SerializeObjectCopyStrategy;

public final class ReflectiveObjectCopyStrategy
implements ObjectCopyStrategy {
    private static final Set FINAL_IMMUTABLE_CLASSES;
    private static final Object[] EMPTY_OBJECT_ARRAY;
    private static final Class[] EMPTY_CLASS_ARRAY;
    private static final SerializeObjectCopyStrategy _serialize;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Object;

    public final Object copy(Object object, PersistenceBroker persistenceBroker) {
        return ReflectiveObjectCopyStrategy.clone(object, IdentityMapFactory.getIdentityMap(), new HashMap());
    }

    private static Object clone(Object object, Map map, Map map2) {
        Object object2;
        if (map.containsKey(object)) {
            return map.get(object);
        }
        Class<?> clazz = object.getClass();
        if (clazz.isArray()) {
            object2 = ReflectiveObjectCopyStrategy.handleArray(object, map, clazz, map2);
        } else if (FINAL_IMMUTABLE_CLASSES.contains(clazz)) {
            map.put(object, object);
            object2 = object;
        } else {
            object2 = ReflectiveObjectCopyStrategy.handleObjectWithNoArgsConstructor(map2, clazz, map, object);
        }
        return object2;
    }

    private static Object handleObjectWithNoArgsConstructor(Map map, Class clazz, Map map2, Object object) {
        Object object2 = null;
        ClassMetadata classMetadata = (ClassMetadata)map.get(clazz);
        if (classMetadata == null) {
            classMetadata = new ClassMetadata();
            map.put(clazz, classMetadata);
        }
        Constructor constructor = classMetadata.m_noArgConstructor;
        if (classMetadata.m_hasNoArgConstructor && constructor == null) {
            try {
                classMetadata.m_noArgConstructor = constructor = clazz.getDeclaredConstructor(EMPTY_CLASS_ARRAY);
            }
            catch (Exception exception) {
                classMetadata.m_hasNoArgConstructor = false;
            }
        }
        if (classMetadata.m_hasNoArgConstructor) {
            if (!classMetadata.m_noArgConstructorAccessible && (1 & constructor.getModifiers()) == 0) {
                try {
                    constructor.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new ObjectCopyException("cannot access noArg constructor [" + constructor + "] of class [" + clazz.getName() + "]: " + securityException.toString(), securityException);
                }
                classMetadata.m_noArgConstructorAccessible = true;
            }
            try {
                object2 = constructor.newInstance(EMPTY_OBJECT_ARRAY);
                map2.put(object, object2);
            }
            catch (Exception exception) {
                throw new ObjectCopyException("cannot instantiate class [" + clazz.getName() + "] using noArg constructor: " + exception.toString(), exception);
            }
            for (Class clazz2 = clazz; clazz2 != (class$java$lang$Object == null ? ReflectiveObjectCopyStrategy.class$("java.lang.Object") : class$java$lang$Object); clazz2 = clazz2.getSuperclass()) {
                ReflectiveObjectCopyStrategy.copyClass(map, clazz2, object, object2, map2);
            }
        } else {
            object2 = _serialize.copy(object, null);
        }
        return object2;
    }

    private static void copyClass(Map map, Class clazz, Object object, Object object2, Map map2) {
        Field[] fieldArray;
        ClassMetadata classMetadata = (ClassMetadata)map.get(clazz);
        if (classMetadata == null) {
            classMetadata = new ClassMetadata();
            map.put(clazz, classMetadata);
        }
        if ((fieldArray = classMetadata.m_declaredFields) == null) {
            fieldArray = clazz.getDeclaredFields();
            classMetadata.m_declaredFields = fieldArray;
        }
        ReflectiveObjectCopyStrategy.setFields(object, object2, fieldArray, classMetadata.m_fieldsAccessible, map2, map);
        classMetadata.m_fieldsAccessible = true;
    }

    private static Object handleArray(Object object, Map map, Class clazz, Map map2) {
        Object object2;
        int n = Array.getLength(object);
        if (n == 0) {
            map.put(object, object);
            object2 = object;
        } else {
            Class<?> clazz2 = clazz.getComponentType();
            object2 = Array.newInstance(clazz2, n);
            map.put(object, object2);
            if (clazz2.isPrimitive() || FINAL_IMMUTABLE_CLASSES.contains(clazz2)) {
                System.arraycopy(object, 0, object2, 0, n);
            } else {
                for (int i = 0; i < n; ++i) {
                    Object object3 = Array.get(object, i);
                    if (object3 == null) continue;
                    Object object4 = ReflectiveObjectCopyStrategy.clone(object3, map, map2);
                    Array.set(object2, i, object4);
                }
            }
        }
        return object2;
    }

    private static void setFields(Object object, Object object2, Field[] fieldArray, boolean bl, Map map, Map map2) {
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Field field = fieldArray[i];
            int n2 = field.getModifiers();
            if ((8 & n2) != 0) continue;
            if ((0x10 & n2) != 0) {
                throw new ObjectCopyException("cannot set final field [" + field.getName() + "] of class [" + object.getClass().getName() + "]");
            }
            if (!bl && (1 & n2) == 0) {
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException securityException) {
                    throw new ObjectCopyException("cannot access field [" + field.getName() + "] of class [" + object.getClass().getName() + "]: " + securityException.toString(), securityException);
                }
            }
            try {
                ReflectiveObjectCopyStrategy.cloneAndSetFieldValue(field, object, object2, map, map2);
                continue;
            }
            catch (Exception exception) {
                throw new ObjectCopyException("cannot set field [" + field.getName() + "] of class [" + object.getClass().getName() + "]: " + exception.toString(), exception);
            }
        }
    }

    private static void cloneAndSetFieldValue(Field field, Object object, Object object2, Map map, Map map2) throws IllegalAccessException {
        Object object3 = field.get(object);
        if (object3 == null) {
            field.set(object2, null);
        } else {
            Class<?> clazz = object3.getClass();
            if (!clazz.isPrimitive() && !FINAL_IMMUTABLE_CLASSES.contains(clazz)) {
                object3 = ReflectiveObjectCopyStrategy.clone(object3, map, map2);
            }
            field.set(object2, object3);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        EMPTY_OBJECT_ARRAY = new Object[0];
        EMPTY_CLASS_ARRAY = new Class[0];
        _serialize = new SerializeObjectCopyStrategy();
        FINAL_IMMUTABLE_CLASSES = new HashSet(17);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$String == null ? (class$java$lang$String = ReflectiveObjectCopyStrategy.class$("java.lang.String")) : class$java$lang$String);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Byte == null ? (class$java$lang$Byte = ReflectiveObjectCopyStrategy.class$("java.lang.Byte")) : class$java$lang$Byte);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Short == null ? (class$java$lang$Short = ReflectiveObjectCopyStrategy.class$("java.lang.Short")) : class$java$lang$Short);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Integer == null ? (class$java$lang$Integer = ReflectiveObjectCopyStrategy.class$("java.lang.Integer")) : class$java$lang$Integer);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Long == null ? (class$java$lang$Long = ReflectiveObjectCopyStrategy.class$("java.lang.Long")) : class$java$lang$Long);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Float == null ? (class$java$lang$Float = ReflectiveObjectCopyStrategy.class$("java.lang.Float")) : class$java$lang$Float);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Double == null ? (class$java$lang$Double = ReflectiveObjectCopyStrategy.class$("java.lang.Double")) : class$java$lang$Double);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Character == null ? (class$java$lang$Character = ReflectiveObjectCopyStrategy.class$("java.lang.Character")) : class$java$lang$Character);
        FINAL_IMMUTABLE_CLASSES.add(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReflectiveObjectCopyStrategy.class$("java.lang.Boolean")) : class$java$lang$Boolean);
    }

    private static final class ClassMetadata {
        Constructor m_noArgConstructor;
        Field[] m_declaredFields;
        boolean m_noArgConstructorAccessible;
        boolean m_fieldsAccessible;
        boolean m_hasNoArgConstructor = true;

        private ClassMetadata() {
        }
    }
}

