/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DSetEntry;
import org.apache.ojb.odmg.collections.DSetIterator;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.DSet;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DSetImpl
extends AbstractSet
implements DSet,
Serializable,
PersistenceBrokerAware,
ManageableCollection {
    private static final long serialVersionUID = -4459673364598652639L;
    private transient Logger log;
    private Integer id;
    private List elements = new ArrayList();
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DSetImpl;

    public DSetImpl() {
        this.getPBKey();
    }

    public DSetImpl(PBKey pBKey) {
        this();
        this.pbKey = pBKey;
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl);
        }
        return this.log;
    }

    private DSetEntry prepareEntry(Object object) {
        return new DSetEntry(this, object);
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    protected boolean checkForOpenTransaction(TransactionImpl transactionImpl) {
        boolean bl = false;
        if (transactionImpl != null && transactionImpl.isOpen()) {
            bl = true;
        }
        return bl;
    }

    public PBKey getPBKey() {
        TransactionImpl transactionImpl;
        if (this.pbKey == null && (transactionImpl = this.getTransaction()) != null && transactionImpl.isOpen()) {
            this.pbKey = transactionImpl.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    public void setPBKey(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    public boolean remove(Object object) {
        return super.remove(object);
    }

    public boolean removeAll(Collection collection) {
        return super.removeAll(collection);
    }

    public boolean add(Object object) {
        if (!this.contains(object)) {
            DSetEntry dSetEntry = this.prepareEntry(object);
            this.elements.add(dSetEntry);
            TransactionImpl transactionImpl = this.getTransaction();
            if (transactionImpl != null && transactionImpl.isOpen()) {
                ArrayList arrayList = transactionImpl.getRegistrationList();
                RuntimeObject runtimeObject = new RuntimeObject(this, transactionImpl);
                transactionImpl.lockAndRegister(runtimeObject, 4, false, arrayList);
                runtimeObject = new RuntimeObject(object, transactionImpl);
                transactionImpl.lockAndRegister(runtimeObject, 1, arrayList);
                runtimeObject = new RuntimeObject(dSetEntry, transactionImpl, true);
                transactionImpl.lockAndRegister(runtimeObject, 4, false, arrayList);
            }
            return true;
        }
        return false;
    }

    public DSet difference(DSet dSet) {
        DSetImpl dSetImpl = new DSetImpl(this.getPBKey());
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (dSet.contains(e)) continue;
            dSetImpl.add(e);
        }
        return dSetImpl;
    }

    public boolean existsElement(String string) throws QueryInvalidException {
        DList dList = (DList)this.query(string);
        return dList != null && dList.size() != 0;
    }

    public List getElements() {
        return this.elements;
    }

    public void setElements(List list) {
        this.elements = list;
    }

    public Integer getId() {
        return this.id;
    }

    public DSet intersection(DSet dSet) {
        DSet dSet2 = this.union(dSet);
        DSetImpl dSetImpl = new DSetImpl(this.getPBKey());
        Iterator iterator = dSet2.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!this.contains(e) || !dSet.contains(e)) continue;
            dSetImpl.add(e);
        }
        return dSetImpl;
    }

    public Iterator iterator() {
        return new DSetIterator(this);
    }

    public boolean properSubsetOf(DSet dSet) {
        return this.size() > 0 && this.size() < dSet.size() && this.subsetOf(dSet);
    }

    public boolean properSupersetOf(DSet dSet) {
        return dSet.size() > 0 && dSet.size() < this.size() && this.supersetOf(dSet);
    }

    public DCollection query(String string) throws QueryInvalidException {
        String string2 = "select all from java.lang.Object where " + string;
        TransactionImpl transactionImpl = this.getTransaction();
        EnhancedOQLQuery enhancedOQLQuery = transactionImpl.getImplementation().newOQLQuery();
        PBCapsule pBCapsule = new PBCapsule(transactionImpl.getImplementation().getCurrentPBKey(), transactionImpl);
        PersistenceBroker persistenceBroker = pBCapsule.getBroker();
        try {
            enhancedOQLQuery.create(string2);
            Query query = ((OQLQueryImpl)enhancedOQLQuery).getQuery();
            Criteria criteria = query.getCriteria();
            Criteria criteria2 = this.getPkCriteriaForAllElements(persistenceBroker);
            criteria.addAndCriteria(criteria2);
            Class clazz = this.getElementsExtentClass(persistenceBroker);
            QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, criteria);
            if (this.log.isDebugEnabled()) {
                this.log.debug(((Object)queryByCriteria).toString());
            }
            DSetImpl dSetImpl = (DSetImpl)persistenceBroker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DSetImpl == null ? (class$org$apache$ojb$odmg$collections$DSetImpl = DSetImpl.class$("org.apache.ojb.odmg.collections.DSetImpl")) : class$org$apache$ojb$odmg$collections$DSetImpl, queryByCriteria);
            return dSetImpl;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            throw new ODMGRuntimeException(persistenceBrokerException.getMessage());
        }
        finally {
            pBCapsule.destroy();
        }
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker persistenceBroker) {
        try {
            Criteria criteria = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry dListEntry = (DListEntry)this.elements.get(i);
                Object object = dListEntry.getRealSubject();
                ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
                FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
                ValueContainer[] valueContainerArray = persistenceBroker.serviceBrokerHelper().getKeyValues(classDescriptor, object);
                Criteria criteria2 = new Criteria();
                for (int j = 0; j < fieldDescriptorArray.length; ++j) {
                    FieldDescriptor fieldDescriptor = fieldDescriptorArray[j];
                    criteria2.addEqualTo(fieldDescriptor.getPersistentField().getName(), valueContainerArray[j].getValue());
                }
                if (criteria == null) {
                    criteria = criteria2;
                    continue;
                }
                criteria.addOrCriteria(criteria2);
            }
            return criteria;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            this.log.error((Object)persistenceBrokerException);
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        DListEntry dListEntry = (DListEntry)this.elements.get(0);
        Class<?> clazz = dListEntry.getRealSubject().getClass();
        Class clazz2 = persistenceBroker.getTopLevelClass(clazz);
        return clazz2;
    }

    public Iterator select(String string) throws QueryInvalidException {
        return this.query(string).iterator();
    }

    public Object selectElement(String string) throws QueryInvalidException {
        return ((DList)this.query(string)).get(0);
    }

    public void setElements(Vector vector) {
        this.elements = vector;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public int size() {
        return this.elements.size();
    }

    public boolean subsetOf(DSet dSet) {
        return dSet.containsAll(this);
    }

    public boolean supersetOf(DSet dSet) {
        return this.containsAll(dSet);
    }

    public DSet union(DSet dSet) {
        DSetImpl dSetImpl = new DSetImpl(this.getPBKey());
        dSetImpl.addAll(this);
        dSetImpl.addAll(dSet);
        return dSetImpl;
    }

    public void ojbAdd(Object object) {
        DSetEntry dSetEntry = this.prepareEntry(object);
        dSetEntry.setPosition(this.elements.size());
        this.elements.add(dSetEntry);
    }

    public void ojbAddAll(ManageableCollection manageableCollection) {
        Iterator iterator = manageableCollection.ojbIterator();
        while (iterator.hasNext()) {
            this.ojbAdd(iterator.next());
        }
    }

    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void beforeInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void beforeUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

