/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.odmg.collections;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.ManageableCollection;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerAware;
import org.apache.ojb.broker.PersistenceBrokerException;
import org.apache.ojb.broker.core.ValueContainer;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.odmg.PBCapsule;
import org.apache.ojb.odmg.RuntimeObject;
import org.apache.ojb.odmg.TransactionImpl;
import org.apache.ojb.odmg.TxManagerFactory;
import org.apache.ojb.odmg.collections.DListEntry;
import org.apache.ojb.odmg.collections.DListIterator;
import org.apache.ojb.odmg.oql.EnhancedOQLQuery;
import org.apache.ojb.odmg.oql.OQLQueryImpl;
import org.odmg.DArray;
import org.odmg.DCollection;
import org.odmg.DList;
import org.odmg.ODMGRuntimeException;
import org.odmg.QueryInvalidException;

public class DListImpl
extends AbstractList
implements DList,
DArray,
ManageableCollection,
PersistenceBrokerAware {
    private static final long serialVersionUID = -9219943066614026526L;
    private transient Logger log;
    private Integer id;
    private List elements = new ArrayList();
    private PBKey pbKey;
    static /* synthetic */ Class class$org$apache$ojb$odmg$collections$DListImpl;

    public DListImpl() {
        this.getPBKey();
    }

    public DListImpl(PBKey pBKey) {
        this();
        this.pbKey = pBKey;
    }

    protected Logger getLog() {
        if (this.log == null) {
            this.log = LoggerFactory.getLogger(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl);
        }
        return this.log;
    }

    private DListEntry prepareEntry(Object object) {
        return new DListEntry(this, object);
    }

    protected TransactionImpl getTransaction() {
        return TxManagerFactory.instance().getTransaction();
    }

    protected boolean checkForOpenTransaction(TransactionImpl transactionImpl) {
        boolean bl = false;
        if (transactionImpl != null && transactionImpl.isOpen()) {
            bl = true;
        }
        return bl;
    }

    public PBKey getPBKey() {
        TransactionImpl transactionImpl;
        if (this.pbKey == null && (transactionImpl = this.getTransaction()) != null && transactionImpl.isOpen()) {
            this.pbKey = transactionImpl.getBroker().getPBKey();
        }
        return this.pbKey;
    }

    public void setPBKey(PBKey pBKey) {
        this.pbKey = pBKey;
    }

    public void add(int n, Object object) {
        DListEntry dListEntry = this.prepareEntry(object);
        this.elements.add(n, dListEntry);
        TransactionImpl transactionImpl = this.getTransaction();
        if (this.checkForOpenTransaction(transactionImpl)) {
            RuntimeObject runtimeObject = new RuntimeObject(this, transactionImpl);
            ArrayList arrayList = transactionImpl.getRegistrationList();
            transactionImpl.lockAndRegister(runtimeObject, 4, false, arrayList);
            runtimeObject = new RuntimeObject(object, transactionImpl);
            transactionImpl.lockAndRegister(runtimeObject, 1, arrayList);
            runtimeObject = new RuntimeObject(dListEntry, transactionImpl, true);
            transactionImpl.lockAndRegister(runtimeObject, 4, false, arrayList);
        }
        int n2 = 0;
        try {
            n2 = ((DListEntry)this.elements.get(n - 1)).getPosition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = n2; i < this.elements.size(); ++i) {
            dListEntry = (DListEntry)this.elements.get(i);
            dListEntry.setPosition(i);
        }
    }

    public Object remove(int n) {
        DListEntry dListEntry = (DListEntry)this.elements.get(n);
        TransactionImpl transactionImpl = this.getTransaction();
        if (this.checkForOpenTransaction(transactionImpl)) {
            transactionImpl.deletePersistent(new RuntimeObject(dListEntry, transactionImpl));
        }
        this.elements.remove(n);
        int n2 = 0;
        try {
            n2 = ((DListEntry)this.elements.get(n)).getPosition();
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (int i = n2; i < this.elements.size(); ++i) {
            dListEntry = (DListEntry)this.elements.get(i);
            dListEntry.setPosition(i);
        }
        return dListEntry.getRealSubject();
    }

    public DList concat(DList dList) {
        DListImpl dListImpl = new DListImpl(this.pbKey);
        dListImpl.addAll(this);
        dListImpl.addAll(dList);
        return dListImpl;
    }

    public boolean existsElement(String string) throws QueryInvalidException {
        DList dList = (DList)this.query(string);
        return dList != null && dList.size() != 0;
    }

    public Object get(int n) {
        DListEntry dListEntry = (DListEntry)this.elements.get(n);
        return dListEntry.getRealSubject();
    }

    public List getElements() {
        return this.elements;
    }

    public Integer getId() {
        return this.id;
    }

    public Iterator iterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator() {
        return new DListIterator(this);
    }

    public ListIterator listIterator(int n) {
        return new DListIterator(this, n);
    }

    private Criteria getPkCriteriaForAllElements(PersistenceBroker persistenceBroker) {
        try {
            Criteria criteria = null;
            for (int i = 0; i < this.elements.size(); ++i) {
                DListEntry dListEntry = (DListEntry)this.elements.get(i);
                Object object = dListEntry.getRealSubject();
                ClassDescriptor classDescriptor = persistenceBroker.getClassDescriptor(object.getClass());
                FieldDescriptor[] fieldDescriptorArray = classDescriptor.getPkFields();
                ValueContainer[] valueContainerArray = persistenceBroker.serviceBrokerHelper().getKeyValues(classDescriptor, object);
                Criteria criteria2 = new Criteria();
                for (int j = 0; j < fieldDescriptorArray.length; ++j) {
                    FieldDescriptor fieldDescriptor = fieldDescriptorArray[j];
                    criteria2.addEqualTo(fieldDescriptor.getPersistentField().getName(), valueContainerArray[j].getValue());
                }
                if (criteria == null) {
                    criteria = criteria2;
                    continue;
                }
                criteria.addOrCriteria(criteria2);
            }
            return criteria;
        }
        catch (PersistenceBrokerException persistenceBrokerException) {
            return null;
        }
    }

    private Class getElementsExtentClass(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
        DListEntry dListEntry = (DListEntry)this.elements.get(0);
        Class<?> clazz = dListEntry.getRealSubject().getClass();
        Class clazz2 = persistenceBroker.getTopLevelClass(clazz);
        return clazz2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DCollection query(String string) throws QueryInvalidException {
        DList dList;
        String string2 = "select all from java.lang.Object where " + string;
        TransactionImpl transactionImpl = this.getTransaction();
        if (transactionImpl == null) {
            throw new QueryInvalidException("Need running transaction to do query");
        }
        EnhancedOQLQuery enhancedOQLQuery = transactionImpl.getImplementation().newOQLQuery();
        enhancedOQLQuery.create(string2);
        Query query = ((OQLQueryImpl)enhancedOQLQuery).getQuery();
        Criteria criteria = query.getCriteria();
        PBCapsule pBCapsule = new PBCapsule(this.pbKey, transactionImpl);
        try {
            PersistenceBroker persistenceBroker = pBCapsule.getBroker();
            Criteria criteria2 = this.getPkCriteriaForAllElements(persistenceBroker);
            criteria2.addAndCriteria(criteria);
            Class clazz = null;
            try {
                clazz = this.getElementsExtentClass(persistenceBroker);
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                this.getLog().error((Object)persistenceBrokerException);
                throw new ODMGRuntimeException(persistenceBrokerException.getMessage());
            }
            QueryByCriteria queryByCriteria = new QueryByCriteria(clazz, criteria2);
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug(((Object)queryByCriteria).toString());
            }
            dList = null;
            try {
                dList = (DList)((Object)persistenceBroker.getCollectionByQuery(class$org$apache$ojb$odmg$collections$DListImpl == null ? (class$org$apache$ojb$odmg$collections$DListImpl = DListImpl.class$("org.apache.ojb.odmg.collections.DListImpl")) : class$org$apache$ojb$odmg$collections$DListImpl, queryByCriteria));
            }
            catch (PersistenceBrokerException persistenceBrokerException) {
                this.getLog().error("Query failed", (Throwable)((Object)persistenceBrokerException));
                throw new OJBRuntimeException((Throwable)((Object)persistenceBrokerException));
            }
        }
        finally {
            if (pBCapsule != null) {
                pBCapsule.destroy();
            }
        }
        return dList;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            n = 31 * n + (e == null ? 0 : e.hashCode());
        }
        return n;
    }

    public String toString() {
        ToStringBuilder toStringBuilder = new ToStringBuilder((Object)this);
        toStringBuilder.append("id", (Object)this.id);
        toStringBuilder.append("pbKey", (Object)this.pbKey);
        toStringBuilder.append((Object)"[containing elements: ");
        Iterator iterator = this.elements.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            toStringBuilder.append((Object)(e != null ? e.toString() : null));
        }
        toStringBuilder.append((Object)"]");
        return toStringBuilder.toString();
    }

    public Iterator select(String string) throws QueryInvalidException {
        return this.query(string).iterator();
    }

    public Object selectElement(String string) throws QueryInvalidException {
        return ((DList)this.query(string)).get(0);
    }

    public int size() {
        return this.elements.size();
    }

    public void ojbAdd(Object object) {
        DListEntry dListEntry = this.prepareEntry(object);
        dListEntry.setPosition(this.elements.size());
        this.elements.add(dListEntry);
    }

    public void ojbAddAll(ManageableCollection manageableCollection) {
        Iterator iterator = manageableCollection.ojbIterator();
        while (iterator.hasNext()) {
            this.ojbAdd(iterator.next());
        }
    }

    public void afterStore(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public Iterator ojbIterator() {
        return this.iterator();
    }

    public void resize(int n) {
    }

    public void setElements(List list) {
        this.elements = list;
    }

    public void setId(Integer n) {
        this.id = n;
    }

    public void beforeInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void beforeUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void beforeDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterUpdate(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterInsert(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterDelete(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    public void afterLookup(PersistenceBroker persistenceBroker) throws PersistenceBrokerException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

