/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo.jdoql;

import org.apache.ojb.jdo.jdoql.Expression;
import org.apache.ojb.jdo.jdoql.Visitor;

public class BinaryExpression
extends Expression {
    public static final int OPERATOR_MULTIPLY = 0;
    public static final int OPERATOR_DIVIDE = 1;
    public static final int OPERATOR_PLUS = 2;
    public static final int OPERATOR_MINUS = 3;
    public static final int OPERATOR_LOWER = 4;
    public static final int OPERATOR_GREATER = 5;
    public static final int OPERATOR_LOWER_OR_EQUAL = 6;
    public static final int OPERATOR_GREATER_OR_EQUAL = 7;
    public static final int OPERATOR_EQUAL = 8;
    public static final int OPERATOR_NOT_EQUAL = 9;
    public static final int OPERATOR_BITWISE_AND = 10;
    public static final int OPERATOR_BITWISE_XOR = 11;
    public static final int OPERATOR_BITWISE_OR = 12;
    public static final int OPERATOR_AND = 13;
    public static final int OPERATOR_OR = 14;
    private Expression _left;
    private int _operator;
    private Expression _right;
    private Class _type;

    public BinaryExpression(Expression expression, int n, Expression expression2) {
        this._left = expression;
        this._operator = n;
        this._right = expression2;
    }

    public Expression getLeftSide() {
        return this._left;
    }

    public int getOperator() {
        return this._operator;
    }

    public Expression getRightSide() {
        return this._right;
    }

    public void replaceChild(Expression expression, Expression expression2) {
        if (expression == this._left) {
            this._left.setParent(null);
            this._left = expression2;
            this._left.setParent(this);
        } else if (expression == this._right) {
            this._right.setParent(null);
            this._right = expression2;
            this._right.setParent(this);
        }
    }

    public void accept(Visitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("(");
        stringBuffer.append(this._left.toString());
        stringBuffer.append(" ");
        switch (this._operator) {
            case 0: {
                stringBuffer.append("* ");
                break;
            }
            case 1: {
                stringBuffer.append("/ ");
                break;
            }
            case 2: {
                stringBuffer.append("+ ");
                break;
            }
            case 3: {
                stringBuffer.append("- ");
                break;
            }
            case 4: {
                stringBuffer.append("< ");
                break;
            }
            case 5: {
                stringBuffer.append("> ");
                break;
            }
            case 6: {
                stringBuffer.append("<= ");
                break;
            }
            case 7: {
                stringBuffer.append(">= ");
                break;
            }
            case 8: {
                stringBuffer.append("== ");
                break;
            }
            case 9: {
                stringBuffer.append("!= ");
                break;
            }
            case 10: {
                stringBuffer.append("& ");
                break;
            }
            case 11: {
                stringBuffer.append("^ ");
                break;
            }
            case 12: {
                stringBuffer.append("| ");
                break;
            }
            case 13: {
                stringBuffer.append("&& ");
                break;
            }
            case 14: {
                stringBuffer.append("|| ");
            }
        }
        stringBuffer.append(this._right.toString());
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    public void setType(Class clazz) {
        this._type = clazz;
    }

    public Class getType() {
        return this._type;
    }
}

