/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.jdo;

import java.util.Collection;
import java.util.Iterator;
import javax.jdo.Extent;
import javax.jdo.InstanceCallbacks;
import javax.jdo.JDOFatalUserException;
import javax.jdo.PersistenceManager;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.Query;
import javax.jdo.Transaction;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.core.proxy.CollectionProxyDefaultImpl;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.jdo.ExtentImpl;
import org.apache.ojb.jdo.QueryImpl;
import org.apache.ojb.jdo.TransactionImpl;
import org.apache.ojb.otm.EditingContext;
import org.apache.ojb.otm.OTMConnection;
import org.apache.ojb.otm.OTMKit;
import org.apache.ojb.otm.kit.SimpleKit;
import org.apache.ojb.otm.lock.LockingException;
import org.apache.ojb.otm.states.State;

public class PersistenceManagerImpl
implements PersistenceManager {
    private OTMConnection m_conn;
    private OTMKit m_kit;
    private boolean m_multiThreaded = false;
    private boolean m_ignoreCache = false;
    private PersistenceManagerFactory m_factory;
    private String m_userID;
    private String m_password;
    private String m_alias;
    private Object m_usersObject;
    private TransactionImpl m_tx;
    static /* synthetic */ Class class$org$apache$ojb$broker$Identity;

    public PersistenceManagerImpl(PersistenceManagerFactory persistenceManagerFactory, String string, String string2, String string3) {
        this.m_factory = persistenceManagerFactory;
        this.m_userID = string2;
        this.m_password = string3;
        this.m_alias = string;
        this.m_kit = SimpleKit.getInstance();
        if (null == this.m_alias) {
            this.m_conn = this.m_kit.acquireConnection(PersistenceBrokerFactory.getDefaultKey());
        } else {
            PBKey pBKey = new PBKey(this.m_alias, this.m_userID, this.m_password);
            this.m_conn = this.m_kit.acquireConnection(pBKey);
        }
        this.m_tx = new TransactionImpl(this, this.m_kit, this.m_conn);
    }

    OTMConnection getConnection() {
        return this.m_conn;
    }

    OTMKit getKit() {
        return this.m_kit;
    }

    public boolean isClosed() {
        return this.m_conn.isClosed();
    }

    public void close() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("close()"));
        }
        if (this.m_tx.isActive()) {
            this.m_tx.rollback();
        }
        this.m_conn.close();
    }

    public Transaction currentTransaction() {
        return this.m_tx;
    }

    public void evict(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evict(Object)"));
        }
        if (null != object) {
            try {
                Identity identity = this.m_conn.getIdentity(object);
                State state = this.m_conn.getEditingContext().lookupState(identity);
                if (State.PERSISTENT_CLEAN == state) {
                    if (object instanceof InstanceCallbacks) {
                        ((InstanceCallbacks)object).jdoPreClear();
                    }
                    this.m_conn.invalidate(this.m_conn.getIdentity(object));
                }
                if (null == state) {
                    this.m_conn.serviceObjectCache().remove(this.m_conn.getIdentity(object));
                }
            }
            catch (LockingException lockingException) {
                // empty catch block
            }
        }
    }

    public void evictAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("evictAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.evict(objectArray[i]);
        }
    }

    public void evictAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("evictAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.evict(iterator.next());
        }
    }

    public void evictAll() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("evictAll()"));
        }
        EditingContext editingContext = this.m_conn.getEditingContext();
        if (editingContext != null) {
            Iterator iterator = editingContext.getAllObjectsInContext().iterator();
            while (iterator.hasNext()) {
                this.evict(iterator.next());
            }
        }
        this.m_conn.serviceObjectCache().clear();
    }

    public void refresh(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refresh(Object)"));
        }
        this.m_conn.refresh(object);
        if (object instanceof InstanceCallbacks) {
            ((InstanceCallbacks)object).jdoPostLoad();
        }
    }

    public void refreshAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("refreshAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.refresh(objectArray[i]);
        }
    }

    public void refreshAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("refreshAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.refresh(iterator.next());
        }
    }

    public void refreshAll() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("refreshAll()"));
        }
        if (this.currentTransaction().isActive()) {
            Collection collection = this.m_conn.getEditingContext().getAllObjectsInContext();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                this.refresh(iterator.next());
            }
        }
    }

    public Query newQuery() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery()"));
        }
        return new QueryImpl(this);
    }

    public Query newQuery(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Object)"));
        }
        try {
            return ((QueryImpl)object).ojbClone();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("newQuery(Object) must be passed a Query instance");
        }
    }

    public Query newQuery(String string, Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(String, Object)"));
        }
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Query newQuery(Class clazz) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class)"));
        }
        QueryImpl queryImpl = new QueryImpl(this);
        queryImpl.setClass(clazz);
        return queryImpl;
    }

    public Query newQuery(Extent extent) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Extent)"));
        }
        QueryImpl queryImpl = new QueryImpl(this);
        queryImpl.setCandidates(extent);
        return queryImpl;
    }

    public Query newQuery(Class clazz, Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, Collection)"));
        }
        QueryImpl queryImpl = new QueryImpl(this);
        queryImpl.setCandidates(collection);
        queryImpl.setClass(clazz);
        return queryImpl;
    }

    public Query newQuery(Class clazz, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, String)"));
        }
        QueryImpl queryImpl = new QueryImpl(this);
        queryImpl.setClass(clazz);
        queryImpl.setFilter(string);
        return queryImpl;
    }

    public Query newQuery(Class clazz, Collection collection, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Class, Collection, String)"));
        }
        QueryImpl queryImpl = new QueryImpl(this);
        queryImpl.setCandidates(collection);
        queryImpl.setClass(clazz);
        queryImpl.setFilter(string);
        return queryImpl;
    }

    public Query newQuery(Extent extent, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newQuery(Extent, String)"));
        }
        QueryImpl queryImpl = new QueryImpl(this);
        queryImpl.setCandidates(extent);
        queryImpl.setFilter(string);
        return queryImpl;
    }

    public Extent getExtent(Class clazz, boolean bl) {
        if (!bl) {
            throw new UnsupportedOperationException("Not yet implemented!");
        }
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getExtent(Class, boolean)"));
        }
        return new ExtentImpl(clazz, this.m_conn, this, bl);
    }

    public Object getObjectById(Object object, boolean bl) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectById(Object, boolean)"));
        }
        Object object2 = null;
        try {
            object2 = this.m_conn.getObjectByIdentity((Identity)object);
        }
        catch (LockingException lockingException) {
            lockingException.printStackTrace();
        }
        catch (ClassCastException classCastException) {
            throw new IllegalArgumentException("Object passed as id is not an id: " + object);
        }
        return object2;
    }

    public Object getObjectId(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectId(Object)"));
        }
        return this.m_conn.getIdentity(object);
    }

    public Object getTransactionalObjectId(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getTransactionalObjectId(Object)"));
        }
        return this.m_conn.getIdentity(object);
    }

    public Object newObjectIdInstance(Class clazz, String string) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("newObjectIdInstance(Class, String)"));
        }
        return null;
    }

    public void makePersistent(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistent(Object)"));
        }
        try {
            this.m_conn.makePersistent(object);
        }
        catch (LockingException lockingException) {
            // empty catch block
        }
    }

    public void makePersistentAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistentAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makePersistentAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.makePersistent(objectArray[i]);
        }
    }

    public void makePersistentAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makePersistentAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makePersistentAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.makePersistent(iterator.next());
        }
    }

    public void deletePersistent(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistent(Object)"));
        }
        try {
            this.m_conn.deletePersistent(object);
        }
        catch (LockingException lockingException) {
            this.handleLockingException(lockingException);
        }
    }

    public void deletePersistentAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistentAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("deletePersistentAll(Object[]) was passed a null Array.");
        }
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            this.deletePersistent(objectArray[i]);
        }
    }

    public void deletePersistentAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("deletePersistentAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("deletePersistentAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.deletePersistent(iterator.next());
        }
    }

    public void makeTransient(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransient(Object)"));
        }
        this.m_conn.getEditingContext().remove(this.m_conn.getIdentity(object));
        this.m_conn.serviceObjectCache().remove(this.m_conn.getIdentity(object));
    }

    public void makeTransientAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransientAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makeTransientAll(Object[]) was passed a null Array.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.makeTransient(objectArray[i]);
        }
    }

    public void makeTransientAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransientAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeTransientAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.makeTransient(iterator.next());
        }
    }

    public void makeTransactional(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactional(Object)"));
        }
        try {
            this.m_conn.getEditingContext().insert(this.m_conn.getIdentity(object), object, 1);
        }
        catch (LockingException lockingException) {
            this.handleLockingException(lockingException);
        }
    }

    public void makeTransactionalAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactionalAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makeTransactionalAll(Object[]) was passed a null Array.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.makeTransactional(objectArray[i]);
        }
    }

    public void makeTransactionalAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeTransactionalAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeTransactionalAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.makeTransactional(iterator.next());
        }
    }

    public void makeNontransactional(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactional(Object)"));
        }
        this.makeTransient(object);
    }

    public void makeNontransactionalAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactionalAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("makeNontransactionalAll(Object[]) was passed a null Array.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.makeNontransactional(objectArray[i]);
        }
    }

    public void makeNontransactionalAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("makeNontransactionalAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("makeNontransactionalAll(Collection) was passed a null Collection.");
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.makeNontransactional(iterator.next());
        }
    }

    public void retrieve(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieve(Object)"));
        }
        ProxyHelper.getRealObject(object);
    }

    public void retrieveAll(Collection collection) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieveAll(Collection)"));
        }
        if (null == collection) {
            throw new NullPointerException("retrieveAll(Collection) was passed a null Collection.");
        }
        if (collection instanceof CollectionProxyDefaultImpl) {
            CollectionProxyDefaultImpl collectionProxyDefaultImpl = (CollectionProxyDefaultImpl)collection;
            collectionProxyDefaultImpl.getData();
        }
    }

    public void retrieveAll(Object[] objectArray) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("retrieveAll(Object[])"));
        }
        if (null == objectArray) {
            throw new NullPointerException("retrieveAll(Object[]) was passed a null Array.");
        }
    }

    public void setUserObject(Object object) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setUserObject(Object)"));
        }
        this.m_usersObject = object;
    }

    public Object getUserObject() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getUserObject()"));
        }
        return this.m_usersObject;
    }

    public PersistenceManagerFactory getPersistenceManagerFactory() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getPersistenceManagerFactory()"));
        }
        return this.m_factory;
    }

    public Class getObjectIdClass(Class clazz) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getObjectIdClass(Class)"));
        }
        return class$org$apache$ojb$broker$Identity == null ? (class$org$apache$ojb$broker$Identity = PersistenceManagerImpl.class$("org.apache.ojb.broker.Identity")) : class$org$apache$ojb$broker$Identity;
    }

    public void setMultithreaded(boolean bl) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setMultithreaded(boolean)"));
        }
        this.m_multiThreaded = bl;
    }

    public boolean getMultithreaded() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getMultithreaded()"));
        }
        return this.m_multiThreaded;
    }

    public void setIgnoreCache(boolean bl) {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("setIgnoreCache(boolean)"));
        }
        this.m_ignoreCache = bl;
    }

    public boolean getIgnoreCache() {
        if (this.isClosed()) {
            throw new JDOFatalUserException(PersistenceManagerImpl.generateIsClosedErrorMessage("getIgnoreCache()"));
        }
        return this.m_ignoreCache;
    }

    private static final String generateIsClosedErrorMessage(String string) {
        return "PersistenceManager already closed, cannot call '" + string + "'. Obtain a new PersistenceBroker and retry.";
    }

    private void handleLockingException(LockingException lockingException) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    private static final String generateNullParameterErrorMessage(String string, String string2) {
        return string + " was passed a null " + string2 + ".";
    }

    public void retrieveAll(Collection collection, boolean bl) {
    }

    public void retrieveAll(Object[] objectArray, boolean bl) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

