/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.sequence;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.Identity;
import org.apache.ojb.broker.OptimisticLockException;
import org.apache.ojb.broker.PersistenceBroker;
import org.apache.ojb.broker.PersistenceBrokerFactory;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.util.ObjectModification;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.AbstractSequenceManager;
import org.apache.ojb.broker.util.sequence.HighLowSequence;
import org.apache.ojb.broker.util.sequence.SequenceManagerException;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class SequenceManagerHighLowImpl
extends AbstractSequenceManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl);
    private static final String GLOBAL_SEQUENCE_NAME = "global - default sequence name";
    public static final String PROPERTY_GRAB_SIZE = "grabSize";
    public static final String PROPERTY_GLOBAL_SEQUENCE_ID = "globalSequenceId";
    public static final String PROPERTY_GLOBAL_SEQUENCE_START = "globalSequenceStart";
    protected static Map sequencesDBMap = new HashMap();
    protected boolean useGlobalSequenceIdentities;
    protected int grabSize;
    protected long sequenceStart;
    protected int attempts;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
    static /* synthetic */ Class class$org$apache$ojb$broker$util$sequence$HighLowSequence;

    public SequenceManagerHighLowImpl(PersistenceBroker persistenceBroker) {
        super(persistenceBroker);
        Long l = SequenceManagerHelper.getSeqStart(this.getConfigurationProperties());
        this.sequenceStart = l != null ? l : 1L;
        this.grabSize = Integer.parseInt(this.getConfigurationProperty(PROPERTY_GRAB_SIZE, "20"));
        this.useGlobalSequenceIdentities = Boolean.getBoolean(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_ID, "false"));
        long l2 = Long.parseLong(this.getConfigurationProperty(PROPERTY_GLOBAL_SEQUENCE_START, "1"));
        if (this.useGlobalSequenceIdentities && l2 > this.sequenceStart) {
            this.sequenceStart = l2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getUniqueLong(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = this.buildSequenceName(fieldDescriptor);
        Class clazz = class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
        synchronized (clazz) {
            long l;
            HighLowSequence highLowSequence = this.getSequence(string);
            if (highLowSequence == null) {
                highLowSequence = this.getSequence(this.getBrokerForClass(), fieldDescriptor, string);
                this.addSequence(string, highLowSequence);
            }
            if ((l = highLowSequence.getNextId()) == 0L) {
                highLowSequence = this.getSequence(this.getBrokerForClass(), fieldDescriptor, string);
                this.addSequence(string, highLowSequence);
                l = highLowSequence.getNextId();
                if (l == 0L) {
                    this.removeSequence(string);
                    throw new SequenceManagerException("Sequence generation failed: " + SystemUtils.LINE_SEPARATOR + "Sequence: " + highLowSequence + ". Unable to build new ID, id was always 0." + SystemUtils.LINE_SEPARATOR + "Thread: " + Thread.currentThread() + SystemUtils.LINE_SEPARATOR + "PB: " + this.getBrokerForClass());
                }
            }
            return l;
        }
    }

    private HighLowSequence getSequence(String string) {
        HighLowSequence highLowSequence = null;
        Map map = (Map)sequencesDBMap.get(this.getBrokerForClass().serviceConnectionManager().getConnectionDescriptor().getJcdAlias());
        if (map != null) {
            highLowSequence = (HighLowSequence)map.get(string);
        }
        return highLowSequence;
    }

    private void addSequence(String string, HighLowSequence highLowSequence) {
        String string2 = this.getBrokerForClass().serviceConnectionManager().getConnectionDescriptor().getJcdAlias();
        HashMap<String, HighLowSequence> hashMap = (HashMap<String, HighLowSequence>)sequencesDBMap.get(string2);
        if (hashMap == null) {
            hashMap = new HashMap<String, HighLowSequence>();
        }
        hashMap.put(string, highLowSequence);
        sequencesDBMap.put(string2, hashMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSequence(String string) {
        Map map = (Map)sequencesDBMap.get(this.getBrokerForClass().serviceConnectionManager().getConnectionDescriptor().getJcdAlias());
        if (map != null) {
            Class clazz = class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl == null ? (class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.SequenceManagerHighLowImpl")) : class$org$apache$ojb$broker$util$sequence$SequenceManagerHighLowImpl;
            synchronized (clazz) {
                map.remove(string);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected HighLowSequence getSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor, String string) throws SequenceManagerException {
        HighLowSequence highLowSequence = null;
        PersistenceBroker persistenceBroker2 = null;
        try {
            try {
                persistenceBroker2 = PersistenceBrokerFactory.createPersistenceBroker(persistenceBroker.getPBKey());
                persistenceBroker2.beginTransaction();
                highLowSequence = this.lookupStoreSequence(persistenceBroker2, fieldDescriptor, string);
                persistenceBroker2.commitTransaction();
                if (log.isDebugEnabled()) {
                    log.debug("new sequence was " + highLowSequence);
                }
            }
            catch (Exception exception) {
                log.error("Can't lookup new HighLowSequence for field " + (fieldDescriptor != null ? fieldDescriptor.getAttributeName() : null) + " using sequence name " + string, exception);
                if (persistenceBroker2 == null) throw new SequenceManagerException("Can't build new sequence", exception);
                if (!persistenceBroker2.isInTransaction()) throw new SequenceManagerException("Can't build new sequence", exception);
                persistenceBroker2.abortTransaction();
                throw new SequenceManagerException("Can't build new sequence", exception);
            }
            Object var8_6 = null;
            this.attempts = 0;
            if (persistenceBroker2 == null) return highLowSequence;
            persistenceBroker2.close();
            return highLowSequence;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            this.attempts = 0;
            if (persistenceBroker2 == null) throw throwable;
            persistenceBroker2.close();
            throw throwable;
        }
    }

    protected HighLowSequence lookupStoreSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor, String string) {
        boolean bl = false;
        Identity identity = persistenceBroker.serviceIdentity().buildIdentity(class$org$apache$ojb$broker$util$sequence$HighLowSequence == null ? (class$org$apache$ojb$broker$util$sequence$HighLowSequence = SequenceManagerHighLowImpl.class$("org.apache.ojb.broker.util.sequence.HighLowSequence")) : class$org$apache$ojb$broker$util$sequence$HighLowSequence, (Object)string);
        HighLowSequence highLowSequence = (HighLowSequence)persistenceBroker.getObjectByIdentity(identity);
        if (highLowSequence == null) {
            if (log.isDebugEnabled()) {
                log.debug("sequence for field " + fieldDescriptor + " not found in db, store new HighLowSequence");
            }
            long l = this.getMaxKeyForSequence(this.getBrokerForClass(), fieldDescriptor);
            highLowSequence = this.newSequenceObject(string, fieldDescriptor);
            highLowSequence.setMaxKey(l);
            bl = true;
        }
        if (highLowSequence.getMaxKey() < this.sequenceStart) {
            highLowSequence.setMaxKey(this.sequenceStart);
        }
        highLowSequence.setGrabSize(this.grabSize);
        highLowSequence.grabNextKeySet();
        try {
            if (bl) {
                persistenceBroker.store(highLowSequence, ObjectModification.INSERT);
            } else {
                persistenceBroker.store(highLowSequence, ObjectModification.UPDATE);
            }
        }
        catch (OptimisticLockException optimisticLockException) {
            if (this.attempts < 5) {
                log.info("OptimisticLockException was thrown, will try again to store sequence. Sequence was " + highLowSequence);
                ++this.attempts;
                highLowSequence = this.lookupStoreSequence(persistenceBroker, fieldDescriptor, string);
            }
            throw optimisticLockException;
        }
        return highLowSequence;
    }

    protected HighLowSequence newSequenceObject(String string, FieldDescriptor fieldDescriptor) {
        HighLowSequence highLowSequence = new HighLowSequence();
        highLowSequence.setName(string);
        highLowSequence.setGrabSize(this.grabSize);
        return highLowSequence;
    }

    protected long getMaxKeyForSequence(PersistenceBroker persistenceBroker, FieldDescriptor fieldDescriptor) {
        long l;
        l = this.useGlobalSequenceIdentities ? this.sequenceStart : (this.sequenceStart > (l = SequenceManagerHelper.getMaxForExtent(persistenceBroker, fieldDescriptor)) ? this.sequenceStart : l);
        return l;
    }

    private String buildSequenceName(FieldDescriptor fieldDescriptor) throws SequenceManagerException {
        String string = this.useGlobalSequenceIdentities ? GLOBAL_SEQUENCE_NAME : this.calculateSequenceName(fieldDescriptor);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

