/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.util.logging;

import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggingConfiguration;

public class PoorMansLoggerImpl
implements Logger {
    protected static final String STR_DEBUG = "DEBUG";
    protected static final String STR_INFO = "INFO";
    protected static final String STR_WARN = "WARN";
    protected static final String STR_ERROR = "ERROR";
    protected static final String STR_FATAL = "FATAL";
    protected static final String STR_DEBUG_MSG = "DEBUG: ";
    protected static final String STR_INFO_MSG = "INFO: ";
    protected static final String STR_WARN_MSG = "WARN: ";
    protected static final String STR_ERROR_MSG = "ERROR: ";
    protected static final String STR_FATAL_MSG = "FATAL: ";
    protected static final String BRAKE_OPEN = "[";
    protected static final String BRAKE_CLOSE = "] ";
    private String name;
    private int level = 0;

    public PoorMansLoggerImpl(String string) {
        this.name = string;
    }

    protected int getLevel() {
        return this.level;
    }

    void setLevel(int n) {
        this.level = n;
    }

    public String getName() {
        return this.name;
    }

    public void debug(Object object) {
        this.debug(object, null);
    }

    public void debug(Object object, Throwable throwable) {
        if (1 >= this.getLevel()) {
            this.log(STR_DEBUG_MSG, object, throwable);
        }
    }

    public void safeDebug(String string, Object object) {
        this.safeDebug(string, object, null);
    }

    public void safeDebug(String string, Object object, Throwable throwable) {
        if (1 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log(STR_DEBUG_MSG, string + " : " + string2, throwable);
        }
    }

    public void info(Object object) {
        this.info(object, null);
    }

    public void info(Object object, Throwable throwable) {
        if (2 >= this.getLevel()) {
            this.log(STR_INFO_MSG, object, throwable);
        }
    }

    public void safeInfo(String string, Object object) {
        this.safeInfo(string, object, null);
    }

    public void safeInfo(String string, Object object, Throwable throwable) {
        if (2 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log(STR_INFO_MSG, string + " : " + string2, throwable);
        }
    }

    public void warn(Object object) {
        this.warn(object, null);
    }

    public void warn(Object object, Throwable throwable) {
        if (3 >= this.getLevel()) {
            this.log(STR_WARN_MSG, object, throwable);
        }
    }

    public void safeWarn(String string, Object object) {
        this.safeWarn(string, object, null);
    }

    public void safeWarn(String string, Object object, Throwable throwable) {
        if (3 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log(STR_WARN_MSG, string + " : " + string2, throwable);
        }
    }

    public void error(Object object) {
        this.error(object, null);
    }

    public void error(Object object, Throwable throwable) {
        if (4 >= this.getLevel()) {
            this.log(STR_ERROR_MSG, object, throwable);
        }
    }

    public void safeError(String string, Object object) {
        this.safeError(string, object, null);
    }

    public void safeError(String string, Object object, Throwable throwable) {
        if (4 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log(STR_ERROR_MSG, string + " : " + string2, throwable);
        }
    }

    public void fatal(Object object) {
        this.fatal(object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        if (5 >= this.getLevel()) {
            this.log(STR_FATAL_MSG, object, throwable);
        }
    }

    public void safeFatal(String string, Object object) {
        this.safeFatal(string, object, null);
    }

    public void safeFatal(String string, Object object, Throwable throwable) {
        if (5 >= this.getLevel()) {
            String string2 = null;
            if (object != null) {
                try {
                    string2 = object.toString();
                }
                catch (Throwable throwable2) {
                    string2 = "BAD toString() impl for " + object.getClass().getName();
                }
            }
            this.log(STR_FATAL_MSG, string + " : " + string2, throwable);
        }
    }

    public boolean isDebugEnabled() {
        return this.isEnabledFor(1);
    }

    public boolean isEnabledFor(int n) {
        return n >= this.getLevel();
    }

    protected void log(String string, Object object, Throwable throwable) {
        System.out.print(BRAKE_OPEN + this.name + BRAKE_CLOSE + string);
        if (object != null && object instanceof Throwable) {
            try {
                System.out.println(((Throwable)object).getMessage());
                ((Throwable)object).printStackTrace();
            }
            catch (Throwable throwable2) {}
        } else {
            System.out.println(object);
        }
        if (throwable != null) {
            try {
                System.out.println(throwable.getMessage());
                throwable.printStackTrace();
            }
            catch (Throwable throwable3) {
                // empty catch block
            }
        }
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        LoggingConfiguration loggingConfiguration = (LoggingConfiguration)configuration;
        String string = loggingConfiguration.getLogLevel(this.name);
        this.setLevel(string);
    }

    public void setLevel(String string) {
        this.level = string.equalsIgnoreCase(STR_DEBUG) ? 1 : (string.equalsIgnoreCase(STR_INFO) ? 2 : (string.equalsIgnoreCase(STR_WARN) ? 3 : (string.equalsIgnoreCase(STR_ERROR) ? 4 : (string.equalsIgnoreCase(STR_FATAL) ? 5 : 3))));
    }
}

