/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.query;

import java.util.Collection;
import java.util.HashSet;
import java.util.Vector;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.MetadataManager;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryByIdentity;
import org.apache.ojb.broker.query.QueryByMtoNCriteria;
import org.apache.ojb.broker.query.QueryBySQL;
import org.apache.ojb.broker.query.ReportQueryByCriteria;

public final class QueryFactory {
    private static DescriptorRepository getRepository() {
        return MetadataManager.getInstance().getRepository();
    }

    public static ReportQueryByCriteria newReportQuery(Class clazz, String[] stringArray, Criteria criteria, boolean bl) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(clazz), criteria);
        return new ReportQueryByCriteria(clazz, stringArray, criteria, bl);
    }

    public static ReportQueryByCriteria newReportQuery(Class clazz, Criteria criteria, boolean bl) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(clazz), criteria);
        return QueryFactory.newReportQuery(clazz, null, criteria, bl);
    }

    public static ReportQueryByCriteria newReportQuery(Class clazz, Criteria criteria) {
        return QueryFactory.newReportQuery(clazz, criteria, false);
    }

    public static QueryByCriteria newQuery(Class clazz, Criteria criteria, boolean bl) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(clazz), criteria);
        return new QueryByCriteria(clazz, criteria, bl);
    }

    public static QueryByCriteria newQuery(Class clazz, Criteria criteria) {
        return QueryFactory.newQuery(clazz, criteria, false);
    }

    public static QueryByIdentity newQuery(Object object) {
        return QueryFactory.newQueryByIdentity(object);
    }

    public static QueryByIdentity newQueryByIdentity(Object object) {
        return new QueryByIdentity(object);
    }

    public static QueryByCriteria newQueryByExample(Object object) {
        return new QueryByCriteria(object);
    }

    public static QueryByMtoNCriteria newQuery(Class clazz, String string, Criteria criteria, boolean bl) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(clazz), criteria);
        return new QueryByMtoNCriteria(clazz, string, criteria, bl);
    }

    public static QueryByCriteria newQuery(Class clazz, String string, Criteria criteria) {
        criteria = QueryFactory.addCriteriaForOjbConcreteClasses(QueryFactory.getRepository().getDescriptorFor(clazz), criteria);
        return new QueryByMtoNCriteria(clazz, string, criteria);
    }

    public static QueryBySQL newQuery(Class clazz, String string) {
        return new QueryBySQL(clazz, string);
    }

    private static Collection getExtentClasses(ClassDescriptor classDescriptor) {
        FieldDescriptor fieldDescriptor = classDescriptor.getFieldDescriptorByName("ojbConcreteClass");
        HashSet<String> hashSet = new HashSet<String>();
        if (fieldDescriptor != null) {
            hashSet.add(classDescriptor.getClassOfObject().getName());
        }
        if (classDescriptor.isExtent()) {
            Vector vector = classDescriptor.getExtentClasses();
            for (int i = 0; i < vector.size(); ++i) {
                Class clazz = (Class)vector.get(i);
                ClassDescriptor classDescriptor2 = classDescriptor.getRepository().getDescriptorFor(clazz);
                hashSet.addAll(QueryFactory.getExtentClasses(classDescriptor2));
            }
        }
        return hashSet;
    }

    private static Criteria addCriteriaForOjbConcreteClasses(ClassDescriptor classDescriptor, Criteria criteria) {
        Criteria criteria2 = null;
        Collection collection = QueryFactory.getExtentClasses(classDescriptor);
        if (!collection.isEmpty()) {
            criteria2 = new Criteria();
            if (collection.size() > 1) {
                criteria2 = new Criteria();
                criteria2.addIn("ojbConcreteClass", collection);
            } else {
                criteria2.addEqualTo("ojbConcreteClass", collection.toArray()[0]);
            }
        }
        if (criteria2 != null) {
            if (criteria == null) {
                criteria = new Criteria();
            }
            criteria.addAndCriteria(criteria2);
        }
        return criteria;
    }
}

