/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.platforms.PlatformException;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class PlatformOracleImpl
extends PlatformDefaultImpl {
    protected static final String THIN_URL_PREFIX = "jdbc:oracle:thin";
    protected static final int THIN_BLOB_MAX_SIZE = 2000;
    protected static final int THIN_CLOB_MAX_SIZE = 4000;
    protected static int ORACLE_JDBC_TYPE_CURSOR = -10;
    private Logger logger = LoggerFactory.getLogger(class$org$apache$ojb$broker$platforms$PlatformOracleImpl == null ? (class$org$apache$ojb$broker$platforms$PlatformOracleImpl = PlatformOracleImpl.class$("org.apache.ojb.broker.platforms.PlatformOracleImpl")) : class$org$apache$ojb$broker$platforms$PlatformOracleImpl);
    static /* synthetic */ Class class$org$apache$ojb$broker$platforms$PlatformOracleImpl;

    public PlatformOracleImpl() {
        this.initOracleReflectedVars();
    }

    public CallableStatement prepareNextValProcedureStatement(Connection connection, String string, String string2) throws PlatformException {
        try {
            String string3 = "{?= call " + string + " (?)}";
            CallableStatement callableStatement = connection.prepareCall(string3);
            callableStatement.registerOutParameter(1, 4);
            callableStatement.setString(2, string2);
            return callableStatement;
        }
        catch (SQLException sQLException) {
            throw new PlatformException(sQLException);
        }
    }

    public void afterStatementCreate(Statement statement) throws PlatformException {
        try {
            statement.setEscapeProcessing(true);
        }
        catch (SQLException sQLException) {
            throw new PlatformException("Could not set escape processing", sQLException);
        }
    }

    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        if ((n2 == -3 || n2 == -4 || n2 == 2004) && object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            int n3 = byArray.length;
            if (PlatformOracleImpl.isUsingOracleThinDriver(preparedStatement.getConnection()) && n3 > 2000) {
                throw new SQLException("Oracle thin driver cannot update BLOB values with length>2000. (Consider using Oracle9i as OJB platform.)");
            }
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            this.changePreparedStatementResultSetType(preparedStatement);
            preparedStatement.setBinaryStream(n, (InputStream)byteArrayInputStream, n3);
        } else if (object instanceof Double) {
            preparedStatement.setDouble(n, (Double)object);
        } else if (n2 == -5 && object instanceof Integer) {
            preparedStatement.setLong(n, ((Integer)object).intValue());
        } else if (n2 == 4 && object instanceof Long) {
            preparedStatement.setLong(n, (Long)object);
        } else if (n2 == 91 && object instanceof String) {
            preparedStatement.setString(n, (String)object);
        } else if (n2 == 2005 && (object instanceof String || object instanceof byte[])) {
            Reader reader;
            int n4;
            if (object instanceof String) {
                String string = (String)object;
                n4 = string.length();
                reader = new StringReader(string);
            } else {
                byte[] byArray = (byte[])object;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                reader = new InputStreamReader(byteArrayInputStream);
                n4 = byArray.length;
            }
            if (PlatformOracleImpl.isUsingOracleThinDriver(preparedStatement.getConnection()) && n4 > 4000) {
                throw new SQLException("Oracle thin driver cannot insert CLOB values with length>4000. (Consider using Oracle9i as OJB platform.)");
            }
            preparedStatement.setCharacterStream(n, reader, n4);
        } else if ((n2 == 1 || n2 == 12) && (object instanceof String || object instanceof Character)) {
            if (object instanceof String) {
                preparedStatement.setString(n, (String)object);
            } else {
                preparedStatement.setString(n, object.toString());
            }
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }

    protected void changePreparedStatementResultSetType(PreparedStatement preparedStatement) {
        try {
            final Field field = preparedStatement.getClass().getSuperclass().getDeclaredField("m_userRsetType");
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    field.setAccessible(true);
                    return null;
                }
            });
            field.setInt(preparedStatement, 1);
            field.setAccessible(false);
        }
        catch (Exception exception) {
            this.logger.info("Not using classes12.zip.");
        }
    }

    public byte getJoinSyntaxType() {
        return 2;
    }

    public String createSequenceQuery(String string) {
        return "CREATE SEQUENCE " + string;
    }

    public String createSequenceQuery(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(this.createSequenceQuery(string));
        if (properties != null) {
            Boolean bl;
            Long l = SequenceManagerHelper.getSeqIncrementBy(properties);
            if (l != null) {
                stringBuffer.append(" INCREMENT BY ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqStart(properties)) != null) {
                stringBuffer.append(" START WITH ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMaxValue(properties)) != null) {
                stringBuffer.append(" MAXVALUE ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMinValue(properties)) != null) {
                stringBuffer.append(" MINVALUE ").append(l);
            }
            if ((bl = SequenceManagerHelper.getSeqCycleValue(properties)) != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(" CYCLE");
                } else {
                    stringBuffer.append(" NOCYCLE");
                }
            }
            if ((l = SequenceManagerHelper.getSeqCacheValue(properties)) != null) {
                stringBuffer.append(" CACHE ").append(l);
            }
            if ((bl = SequenceManagerHelper.getSeqOrderValue(properties)) != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(" ORDER");
                } else {
                    stringBuffer.append(" NOORDER");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String nextSequenceQuery(String string) {
        return "select " + string + ".nextval from dual";
    }

    public String dropSequenceQuery(String string) {
        return "drop sequence " + string;
    }

    public void registerOutResultSet(CallableStatement callableStatement, int n) throws SQLException {
        callableStatement.registerOutParameter(n, ORACLE_JDBC_TYPE_CURSOR);
    }

    protected static boolean isUsingOracleThinDriver(Connection connection) {
        if (connection == null) {
            return false;
        }
        try {
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String string = databaseMetaData.getURL();
            if (string != null && string.startsWith(THIN_URL_PREFIX)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected void initOracleReflectedVars() {
        try {
            Class clazz = ClassHelper.getClass("oracle.jdbc.OracleTypes", false);
            Field field = clazz.getField("CURSOR");
            ORACLE_JDBC_TYPE_CURSOR = field.getInt(null);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.log.warn("PlatformOracleImpl could not find Oracle JDBC classes");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            this.log.warn("PlatformOracleImpl could not find Oracle JDBC type fields");
        }
        catch (IllegalAccessException illegalAccessException) {
            this.log.warn("PlatformOracleImpl could not get Oracle JDBC type values");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

