/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.platforms;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.ojb.broker.platforms.PlatformDefaultImpl;
import org.apache.ojb.broker.util.sequence.SequenceManagerHelper;

public class PlatformDb2Impl
extends PlatformDefaultImpl {
    public void setObjectForStatement(PreparedStatement preparedStatement, int n, Object object, int n2) throws SQLException {
        if (n2 == -6) {
            preparedStatement.setByte(n, (Byte)object);
        } else {
            super.setObjectForStatement(preparedStatement, n, object, n2);
        }
    }

    public String createSequenceQuery(String string) {
        return "create sequence " + string;
    }

    public String createSequenceQuery(String string, Properties properties) {
        StringBuffer stringBuffer = new StringBuffer(this.createSequenceQuery(string));
        if (properties != null) {
            Boolean bl;
            Long l;
            String string2 = SequenceManagerHelper.getSeqAsValue(properties);
            if (string2 != null) {
                stringBuffer.append(" AS ").append(string2);
            }
            if ((l = SequenceManagerHelper.getSeqStart(properties)) != null) {
                stringBuffer.append(" START WITH ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqIncrementBy(properties)) != null) {
                stringBuffer.append(" INCREMENT BY ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMinValue(properties)) != null) {
                stringBuffer.append(" MINVALUE ").append(l);
            }
            if ((l = SequenceManagerHelper.getSeqMaxValue(properties)) != null) {
                stringBuffer.append(" MAXVALUE ").append(l);
            }
            if ((bl = SequenceManagerHelper.getSeqCycleValue(properties)) != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(" CYCLE");
                } else {
                    stringBuffer.append(" NO CYCLE");
                }
            }
            if ((l = SequenceManagerHelper.getSeqCacheValue(properties)) != null) {
                stringBuffer.append(" CACHE ").append(l);
            }
            if ((bl = SequenceManagerHelper.getSeqOrderValue(properties)) != null) {
                if (bl.booleanValue()) {
                    stringBuffer.append(" ORDER");
                } else {
                    stringBuffer.append(" NO ORDER");
                }
            }
        }
        return stringBuffer.toString();
    }

    public String nextSequenceQuery(String string) {
        return "values nextval for " + string;
    }

    public String dropSequenceQuery(String string) {
        return "drop sequence " + string;
    }

    public String getLastInsertIdentityQuery(String string) {
        return "values IDENTITY_VAL_LOCAL()";
    }
}

