/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.torque;

import java.util.Iterator;
import java.util.Vector;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.FieldDescriptor;
import org.apache.ojb.broker.metadata.torque.TableDescriptor;
import org.apache.ojb.broker.metadata.torque.TorqueFieldGenerator;
import org.apache.ojb.broker.metadata.torque.TorqueForeignKeyGenerator;
import org.apache.ojb.broker.metadata.torque.TorqueIndexGenerator;

public class TorqueTableGenerator {
    private TorqueFieldGenerator fieldGenerator;
    private TorqueForeignKeyGenerator foreignKeyPreprocessor;
    private TorqueIndexGenerator indexGenerator;

    public TorqueTableGenerator(DescriptorRepository descriptorRepository, boolean bl) {
        this.fieldGenerator = new TorqueFieldGenerator(bl);
        this.foreignKeyPreprocessor = new TorqueForeignKeyGenerator(descriptorRepository);
        this.foreignKeyPreprocessor.buildConstraintsMap();
        this.indexGenerator = new TorqueIndexGenerator();
    }

    public void generateMappingTables(StringBuffer stringBuffer, String string) {
        Iterator iterator = this.foreignKeyPreprocessor.getMappingTables().values().iterator();
        while (iterator.hasNext()) {
            TableDescriptor tableDescriptor = (TableDescriptor)iterator.next();
            FieldDescriptor[] fieldDescriptorArray = tableDescriptor.getColumns().toArray(new FieldDescriptor[0]);
            if (fieldDescriptorArray == null || fieldDescriptorArray.length <= 0) continue;
            this.generateTableHeader(stringBuffer, tableDescriptor, string);
            this.fieldGenerator.generateMappingFieldDescriptors(fieldDescriptorArray, stringBuffer);
            this.generateForeignKeys(tableDescriptor, stringBuffer);
            stringBuffer.append("    </table>\n");
        }
    }

    public void generateStandardTable(TableDescriptor tableDescriptor, StringBuffer stringBuffer, String string) {
        this.generateTableHeader(stringBuffer, tableDescriptor, string);
        this.fieldGenerator.generateFieldDescriptors(tableDescriptor.getColumns().toArray(new FieldDescriptor[0]), stringBuffer);
        this.indexGenerator.generateIndices(tableDescriptor.getIndices(), stringBuffer);
        this.generateForeignKeys(tableDescriptor, stringBuffer);
        stringBuffer.append("    </table>\n\n");
    }

    private void generateTableHeader(StringBuffer stringBuffer, TableDescriptor tableDescriptor, String string) {
        stringBuffer.append("    <table name=\"");
        stringBuffer.append(tableDescriptor.getName());
        stringBuffer.append("\" indexTablespace=\"");
        stringBuffer.append(string);
        stringBuffer.append("\">\n");
    }

    private void generateForeignKeys(TableDescriptor tableDescriptor, StringBuffer stringBuffer) {
        Vector vector = this.foreignKeyPreprocessor.getForeignKeysForTable(tableDescriptor.getName());
        if (vector != null) {
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(iterator.next());
            }
        }
    }
}

