/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata.fieldaccess;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.ojb.broker.core.proxy.ProxyHelper;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.fieldaccess.PersistentFieldBase;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.logging.Logger;

public class PersistentFieldIntrospectorImpl
extends PersistentFieldBase {
    private static final long serialVersionUID = 8805309492150404444L;
    private Class type;
    private transient List propertyGraph;

    public PersistentFieldIntrospectorImpl() {
    }

    public PersistentFieldIntrospectorImpl(Class clazz, String string) {
        super(clazz, string);
    }

    public Class getType() {
        if (this.type == null) {
            this.type = this.getPropertyDescriptor().getPropertyType();
        }
        return this.type;
    }

    public void set(Object object, Object object2) throws MetadataException {
        PropertyDescriptor propertyDescriptor;
        if (object == null) {
            return;
        }
        List list = this.getPropertyGraph();
        int n = list.size() - 1;
        for (int i = 0; i < n; ++i) {
            propertyDescriptor = (PropertyDescriptor)list.get(i);
            Object object3 = this.getValueFrom(propertyDescriptor, object);
            if (object3 != null || object2 != null) {
                if (object3 == null) {
                    try {
                        object3 = ClassHelper.newInstance(propertyDescriptor.getPropertyType());
                    }
                    catch (Exception exception) {
                        throw new MetadataException("Can't instantiate nested object of type '" + propertyDescriptor.getPropertyType() + "' for field '" + propertyDescriptor.getName() + "'", exception);
                    }
                }
            } else {
                return;
            }
            this.setValueFor(propertyDescriptor, object, object3);
            object = object3;
        }
        propertyDescriptor = (PropertyDescriptor)list.get(n);
        this.setValueFor(propertyDescriptor, object, object2);
    }

    public Object get(Object object) throws MetadataException {
        PropertyDescriptor propertyDescriptor;
        List list = this.getPropertyGraph();
        for (int i = 0; i < list.size() && (object = this.getValueFrom(propertyDescriptor = (PropertyDescriptor)list.get(i), object)) != null; ++i) {
        }
        return object;
    }

    private Object getValueFrom(PropertyDescriptor propertyDescriptor, Object object) {
        if (object == null) {
            return null;
        }
        Method method = propertyDescriptor.getReadMethod();
        if (method != null) {
            try {
                return method.invoke(ProxyHelper.getRealObject(object), null);
            }
            catch (Throwable throwable) {
                this.logProblem(propertyDescriptor, object, null, "Can't read value from given object");
                throw new MetadataException("Error invoking method:" + method.getName() + " in object " + object.getClass().getName(), throwable);
            }
        }
        throw new MetadataException("Can't get ReadMethod for property:" + propertyDescriptor.getName() + " in object " + object.getClass().getName());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setValueFor(PropertyDescriptor propertyDescriptor, Object object, Object object2) {
        Method method = propertyDescriptor.getWriteMethod();
        Object[] objectArray = new Object[]{object2};
        if (method == null) throw new MetadataException("Can't get WriteMethod for property:" + propertyDescriptor.getName() + " in object:" + object.getClass().getName());
        try {
            if (object2 == null && method.getParameterTypes()[0].isPrimitive()) return;
            method.invoke(ProxyHelper.getRealObject(object), objectArray);
            return;
        }
        catch (Throwable throwable) {
            this.logProblem(propertyDescriptor, object, object2, "Can't set value on given object.");
            throw new MetadataException("Error invoking method:" + method.getName() + " in object:" + object.getClass().getName(), throwable);
        }
    }

    private List getPropertyGraph() {
        if (this.propertyGraph == null) {
            this.propertyGraph = this.buildPropertyGraph();
        }
        return this.propertyGraph;
    }

    private List buildPropertyGraph() {
        ArrayList<PropertyDescriptor> arrayList = new ArrayList<PropertyDescriptor>();
        String[] stringArray = StringUtils.split((String)this.getName(), (String)"::");
        PropertyDescriptor propertyDescriptor = null;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            propertyDescriptor = propertyDescriptor == null ? PersistentFieldIntrospectorImpl.findPropertyDescriptor(this.getDeclaringClass(), string) : PersistentFieldIntrospectorImpl.findPropertyDescriptor(propertyDescriptor.getPropertyType(), string);
            arrayList.add(propertyDescriptor);
        }
        return arrayList;
    }

    protected static PropertyDescriptor findPropertyDescriptor(Class clazz, String string) {
        PropertyDescriptor propertyDescriptor = null;
        try {
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
            for (int i = 0; i < propertyDescriptorArray.length; ++i) {
                if (!propertyDescriptorArray[i].getName().equals(string)) continue;
                propertyDescriptor = propertyDescriptorArray[i];
                break;
            }
            if (propertyDescriptor == null) {
                throw new MetadataException("Can't find property " + string + " in " + clazz.getName());
            }
            return propertyDescriptor;
        }
        catch (IntrospectionException introspectionException) {
            throw new MetadataException("Can't find property " + string + " in " + clazz.getName(), introspectionException);
        }
    }

    protected PropertyDescriptor getPropertyDescriptor() {
        return (PropertyDescriptor)this.getPropertyGraph().get(this.getPropertyGraph().size() - 1);
    }

    public boolean makeAccessible() {
        return false;
    }

    public boolean usesAccessorsAndMutators() {
        return true;
    }

    protected void logProblem(PropertyDescriptor propertyDescriptor, Object object, Object object2, String string) {
        Logger logger = this.getLog();
        logger.error("Error in [PersistentFieldPropertyImpl], " + string);
        logger.error("Declaring class [" + this.getDeclaringClass().getName() + "]");
        logger.error("Property Name [" + this.getName() + "]");
        logger.error("Property Type [" + propertyDescriptor.getPropertyType().getName() + "]");
        if (object != null) {
            logger.error("anObject was class [" + object.getClass().getName() + "]");
        } else {
            logger.error("anObject was null");
        }
        if (object2 != null) {
            logger.error("aValue was class [" + object2.getClass().getName() + "]");
        } else {
            logger.error("aValue was null");
        }
    }
}

