/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.ojb.broker.metadata.ConnectionDescriptorXmlHandler;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.MetadataConfiguration;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryTags;
import org.apache.ojb.broker.metadata.RepositoryXmlHandler;
import org.apache.ojb.broker.util.ClassHelper;
import org.apache.ojb.broker.util.configuration.Configurable;
import org.apache.ojb.broker.util.configuration.Configuration;
import org.apache.ojb.broker.util.configuration.ConfigurationException;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class RepositoryPersistor
implements Configurable {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$RepositoryPersistor == null ? (class$org$apache$ojb$broker$metadata$RepositoryPersistor = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.RepositoryPersistor")) : class$org$apache$ojb$broker$metadata$RepositoryPersistor);
    private static final String SER_FILE_SUFFIX = "serialized";
    private static final String SERIALIZED_REPOSITORY_PATH = "serializedRepositoryPath";
    private boolean useSerializedRepository = false;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$RepositoryPersistor;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$DescriptorRepository;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$ConnectionRepository;

    public RepositoryPersistor() {
        OjbConfigurator.getInstance().configure(this);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.useSerializedRepository = ((MetadataConfiguration)((Object)configuration)).useSerializedRepository();
    }

    public void writeToFile(DescriptorRepository descriptorRepository, ConnectionRepository connectionRepository, OutputStream outputStream) {
        RepositoryTags repositoryTags = RepositoryTags.getInstance();
        try {
            if (log.isDebugEnabled()) {
                log.debug("## Write repository file ##" + descriptorRepository.toXML() + "## End of repository file ##");
            }
            String string = SystemUtils.LINE_SEPARATOR;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + string);
            stringBuffer.append("<!DOCTYPE descriptor-repository SYSTEM \"repository.dtd\" >" + string + string);
            stringBuffer.append("<!-- OJB RepositoryPersistor generated this file on " + new Date().toString() + " -->" + string);
            stringBuffer.append(repositoryTags.getOpeningTagNonClosingById(0) + string);
            stringBuffer.append("  " + repositoryTags.getAttribute(67, DescriptorRepository.getVersion()) + string);
            stringBuffer.append("  " + repositoryTags.getAttribute(34, descriptorRepository.getIsolationLevelAsString()) + string);
            stringBuffer.append(">" + string);
            if (connectionRepository != null) {
                stringBuffer.append(string + string + connectionRepository.toXML() + string + string);
            }
            if (descriptorRepository != null) {
                stringBuffer.append(descriptorRepository.toXML());
            }
            stringBuffer.append(repositoryTags.getClosingTagById(0));
            PrintWriter printWriter = new PrintWriter(outputStream);
            printWriter.print(stringBuffer.toString());
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            log.error("Could not write to output stream" + outputStream, exception);
        }
    }

    public DescriptorRepository readDescriptorRepository(String string) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        DescriptorRepository descriptorRepository;
        if (this.useSerializedRepository) {
            Configuration configuration = OjbConfigurator.getInstance().getConfigurationFor(null);
            String string2 = configuration.getString(SERIALIZED_REPOSITORY_PATH, ".");
            File file = new File(string2 + File.separator + string + "." + SER_FILE_SUFFIX);
            if (file.exists() && file.length() > 0L) {
                try {
                    long l = System.currentTimeMillis();
                    descriptorRepository = this.deserialize(file);
                    log.info("Read serialized repository in " + (System.currentTimeMillis() - l) + " ms");
                }
                catch (Exception exception) {
                    log.error("error in loading serialized repository. Will try to use XML version.", exception);
                    descriptorRepository = (DescriptorRepository)this.buildRepository(string, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
                }
            } else {
                long l = System.currentTimeMillis();
                descriptorRepository = (DescriptorRepository)this.buildRepository(string, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
                log.info("Read repository from file took " + (System.currentTimeMillis() - l) + " ms");
                this.serialize(descriptorRepository, file);
            }
        } else {
            long l = System.currentTimeMillis();
            descriptorRepository = (DescriptorRepository)this.buildRepository(string, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
            log.info("Read class descriptors took " + (System.currentTimeMillis() - l) + " ms");
        }
        return descriptorRepository;
    }

    public DescriptorRepository readDescriptorRepository(InputStream inputStream) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        long l = System.currentTimeMillis();
        InputSource inputSource = new InputSource(inputStream);
        DescriptorRepository descriptorRepository = (DescriptorRepository)this.readMetadataFromXML(inputSource, class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository);
        log.info("Read class descriptors took " + (System.currentTimeMillis() - l) + " ms");
        return descriptorRepository;
    }

    public ConnectionRepository readConnectionRepository(String string) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        long l = System.currentTimeMillis();
        ConnectionRepository connectionRepository = (ConnectionRepository)this.buildRepository(string, class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository);
        log.info("Read connection repository took " + (System.currentTimeMillis() - l) + " ms");
        return connectionRepository;
    }

    public ConnectionRepository readConnectionRepository(InputStream inputStream) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        long l = System.currentTimeMillis();
        InputSource inputSource = new InputSource(inputStream);
        ConnectionRepository connectionRepository = (ConnectionRepository)this.readMetadataFromXML(inputSource, class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository);
        log.info("Read connection repository took " + (System.currentTimeMillis() - l) + " ms");
        return connectionRepository;
    }

    protected DescriptorRepository deserialize(File file) {
        DescriptorRepository descriptorRepository = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            descriptorRepository = (DescriptorRepository)SerializationUtils.deserialize((InputStream)fileInputStream);
        }
        catch (Exception exception) {
            log.error("Deserialisation failed, using input path: " + file.getAbsolutePath(), exception);
        }
        return descriptorRepository;
    }

    protected void serialize(DescriptorRepository descriptorRepository, File file) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            SerializationUtils.serialize((Serializable)descriptorRepository, (OutputStream)fileOutputStream);
        }
        catch (Exception exception) {
            log.error("Serialization failed, using output path: " + file.getAbsolutePath(), exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object buildRepository(String string, Class clazz) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        Object object;
        URL uRL = this.buildURL(string);
        String string2 = uRL.toExternalForm();
        log.info("Building repository from :" + string2);
        InputSource inputSource = new InputSource(string2);
        URLConnection uRLConnection = uRL.openConnection();
        uRLConnection.setUseCaches(false);
        uRLConnection.connect();
        InputStream inputStream = uRLConnection.getInputStream();
        inputSource.setByteStream(inputStream);
        try {
            object = this.readMetadataFromXML(inputSource, clazz);
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                log.warn("unable to close repository input stream [" + iOException.getMessage() + "]", iOException);
            }
            throw throwable;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            log.warn("unable to close repository input stream [" + iOException.getMessage() + "]", iOException);
        }
        return object;
    }

    private Object readMetadataFromXML(InputSource inputSource, Class clazz) throws MalformedURLException, ParserConfigurationException, SAXException, IOException {
        Serializable serializable;
        boolean bl = false;
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        log.info("RepositoryPersistor using SAXParserFactory : " + sAXParserFactory.getClass().getName());
        if (bl) {
            sAXParserFactory.setValidating(true);
        }
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        XMLReader xMLReader = sAXParser.getXMLReader();
        if (bl) {
            xMLReader.setErrorHandler(new OJBErrorHandler());
        }
        if ((class$org$apache$ojb$broker$metadata$DescriptorRepository == null ? (class$org$apache$ojb$broker$metadata$DescriptorRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.DescriptorRepository")) : class$org$apache$ojb$broker$metadata$DescriptorRepository).equals(clazz)) {
            DescriptorRepository descriptorRepository = new DescriptorRepository();
            RepositoryXmlHandler repositoryXmlHandler = new RepositoryXmlHandler(descriptorRepository);
            xMLReader.setContentHandler(repositoryXmlHandler);
            xMLReader.parse(inputSource);
            serializable = descriptorRepository;
        } else if ((class$org$apache$ojb$broker$metadata$ConnectionRepository == null ? (class$org$apache$ojb$broker$metadata$ConnectionRepository = RepositoryPersistor.class$("org.apache.ojb.broker.metadata.ConnectionRepository")) : class$org$apache$ojb$broker$metadata$ConnectionRepository).equals(clazz)) {
            ConnectionRepository connectionRepository = new ConnectionRepository();
            ConnectionDescriptorXmlHandler connectionDescriptorXmlHandler = new ConnectionDescriptorXmlHandler(connectionRepository);
            xMLReader.setContentHandler(connectionDescriptorXmlHandler);
            xMLReader.parse(inputSource);
            serializable = connectionRepository;
        } else {
            throw new MetadataException("Could not build a repository instance for '" + clazz + "', using source " + inputSource);
        }
        return serializable;
    }

    private URL buildURL(String string) throws MalformedURLException {
        URL uRL = ClassHelper.getResource(string);
        if (uRL == null) {
            try {
                uRL = new File(string).toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL == null) {
            throw new MalformedURLException("did not find resource " + string);
        }
        log.info("OJB Descriptor Repository: " + uRL);
        return uRL;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class OJBErrorHandler
    implements ErrorHandler {
        OJBErrorHandler() {
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            this.logMessage(sAXParseException, false);
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            this.logMessage(sAXParseException, false);
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            this.logMessage(sAXParseException, true);
        }

        void logMessage(SAXParseException sAXParseException, boolean bl) {
            String string = sAXParseException.getMessage();
            if (bl) {
                log.error("## " + sAXParseException.getSystemId() + " - line " + sAXParseException.getLineNumber() + ": " + string + " ##");
            } else {
                log.warn(sAXParseException.getSystemId() + " - line " + sAXParseException.getLineNumber() + ": " + string);
            }
        }
    }
}

