/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.ojb.broker.metadata.ArgumentDescriptor;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.DescriptorBase;
import org.apache.ojb.broker.metadata.FieldDescriptor;

public abstract class ProcedureDescriptor
extends DescriptorBase
implements Serializable {
    private static final long serialVersionUID = -8228331122289787173L;
    private String name;
    private FieldDescriptor returnValueFieldRef;
    private ClassDescriptor classDescriptor;
    private ArrayList arguments = new ArrayList();

    public ProcedureDescriptor(ClassDescriptor classDescriptor, String string) {
        this.classDescriptor = classDescriptor;
        this.name = string;
    }

    public final String getName() {
        return this.name;
    }

    public final void setReturnValueFieldRef(String string) {
        this.returnValueFieldRef = this.getClassDescriptor().getFieldDescriptorByName(string);
    }

    public final void setReturnValueFieldRef(FieldDescriptor fieldDescriptor) {
        this.returnValueFieldRef = fieldDescriptor;
    }

    public final FieldDescriptor getReturnValueFieldRef() {
        return this.returnValueFieldRef;
    }

    public final boolean hasReturnValue() {
        return this.returnValueFieldRef != null;
    }

    public final boolean hasReturnValues() {
        if (this.hasReturnValue()) {
            return true;
        }
        Iterator iterator = this.getArguments().iterator();
        while (iterator.hasNext()) {
            ArgumentDescriptor argumentDescriptor = (ArgumentDescriptor)iterator.next();
            if (!argumentDescriptor.getIsReturnedByProcedure()) continue;
            return true;
        }
        return false;
    }

    public final String getReturnValueFieldRefName() {
        if (this.returnValueFieldRef == null) {
            return null;
        }
        return this.returnValueFieldRef.getAttributeName();
    }

    public final ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public abstract String toXML();

    protected void addArgument(ArgumentDescriptor argumentDescriptor) {
        this.arguments.add(argumentDescriptor);
    }

    protected void addArguments(FieldDescriptor[] fieldDescriptorArray) {
        for (int i = 0; i < fieldDescriptorArray.length; ++i) {
            ArgumentDescriptor argumentDescriptor = new ArgumentDescriptor(this);
            argumentDescriptor.setValue(fieldDescriptorArray[i].getAttributeName(), false);
            this.addArgument(argumentDescriptor);
        }
    }

    public final Collection getArguments() {
        return this.arguments;
    }

    public final int getArgumentCount() {
        return this.arguments.size();
    }
}

