/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.SerializationUtils;
import org.apache.ojb.broker.PBKey;
import org.apache.ojb.broker.core.PersistenceBrokerConfiguration;
import org.apache.ojb.broker.metadata.ClassDescriptor;
import org.apache.ojb.broker.metadata.ConnectionRepository;
import org.apache.ojb.broker.metadata.DescriptorRepository;
import org.apache.ojb.broker.metadata.JdbcConnectionDescriptor;
import org.apache.ojb.broker.metadata.MetadataException;
import org.apache.ojb.broker.metadata.RepositoryPersistor;
import org.apache.ojb.broker.util.configuration.impl.OjbConfigurator;
import org.apache.ojb.broker.util.logging.Logger;
import org.apache.ojb.broker.util.logging.LoggerFactory;

public class MetadataManager {
    private static Logger log = LoggerFactory.getLogger(class$org$apache$ojb$broker$metadata$MetadataManager == null ? (class$org$apache$ojb$broker$metadata$MetadataManager = MetadataManager.class$("org.apache.ojb.broker.metadata.MetadataManager")) : class$org$apache$ojb$broker$metadata$MetadataManager);
    private static final String MSG_STR = "* Can't find DescriptorRepository for current thread, use default one *";
    private static ThreadLocal threadedRepository = new ThreadLocal();
    private static ThreadLocal currentProfileKey = new ThreadLocal();
    private static MetadataManager singleton;
    private Hashtable metadataProfiles;
    private DescriptorRepository globalRepository;
    private ConnectionRepository connectionRepository;
    private boolean enablePerThreadChanges;
    private PBKey defaultPBKey;
    static /* synthetic */ Class class$org$apache$ojb$broker$metadata$MetadataManager;

    private MetadataManager() {
        this.init();
    }

    private void init() {
        this.metadataProfiles = new Hashtable();
        String string = ((PersistenceBrokerConfiguration)((Object)OjbConfigurator.getInstance().getConfigurationFor(null))).getRepositoryFilename();
        try {
            this.globalRepository = new RepositoryPersistor().readDescriptorRepository(string);
            this.connectionRepository = new RepositoryPersistor().readConnectionRepository(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.warn("Could not access '" + string + "' or a DOCTYPE/DTD-dependency. " + "(Check letter case for file names and HTTP-access if using DOCTYPE PUBLIC)" + " Starting with empty metadata and connection configurations.", fileNotFoundException);
            this.globalRepository = new DescriptorRepository();
            this.connectionRepository = new ConnectionRepository();
        }
        catch (Exception exception) {
            throw new MetadataException("Can't read repository file '" + string + "'", exception);
        }
    }

    public void shutdown() {
        threadedRepository = null;
        currentProfileKey = null;
        this.globalRepository = null;
        this.metadataProfiles = null;
        singleton = null;
    }

    public static synchronized MetadataManager getInstance() {
        if (singleton == null) {
            singleton = new MetadataManager();
        }
        return singleton;
    }

    public DescriptorRepository getRepository() {
        if (this.enablePerThreadChanges) {
            DescriptorRepository descriptorRepository = (DescriptorRepository)threadedRepository.get();
            if (descriptorRepository == null) {
                descriptorRepository = this.getGlobalRepository();
                log.info(MSG_STR);
            }
            return descriptorRepository;
        }
        return this.globalRepository;
    }

    public DescriptorRepository getGlobalRepository() {
        return this.globalRepository;
    }

    public ConnectionRepository connectionRepository() {
        return this.connectionRepository;
    }

    public void mergeConnectionRepository(ConnectionRepository connectionRepository) {
        this.mergeConnectionRepository(this.connectionRepository(), connectionRepository, false);
    }

    public void mergeConnectionRepository(ConnectionRepository connectionRepository, ConnectionRepository connectionRepository2, boolean bl) {
        List list = connectionRepository2.getAllDescriptor();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)iterator.next();
            if (bl) {
                jdbcConnectionDescriptor = (JdbcConnectionDescriptor)SerializationUtils.clone((Serializable)jdbcConnectionDescriptor);
            }
            connectionRepository.addDescriptor(jdbcConnectionDescriptor);
        }
    }

    public void mergeDescriptorRepository(DescriptorRepository descriptorRepository) {
        this.mergeDescriptorRepository(this.getRepository(), descriptorRepository, false);
    }

    public void mergeDescriptorRepository(DescriptorRepository descriptorRepository, DescriptorRepository descriptorRepository2, boolean bl) {
        Iterator iterator = descriptorRepository2.iterator();
        while (iterator.hasNext()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)iterator.next();
            if (bl) {
                classDescriptor = (ClassDescriptor)SerializationUtils.clone((Serializable)classDescriptor);
            }
            descriptorRepository.put(classDescriptor.getClassOfObject(), classDescriptor);
            classDescriptor.setRepository(descriptorRepository);
        }
    }

    public DescriptorRepository readDescriptorRepository(String string) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readDescriptorRepository(string);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository " + string, exception);
        }
    }

    public DescriptorRepository readDescriptorRepository(InputStream inputStream) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readDescriptorRepository(inputStream);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository " + inputStream, exception);
        }
    }

    public ConnectionRepository readConnectionRepository(String string) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readConnectionRepository(string);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository " + string, exception);
        }
    }

    public ConnectionRepository readConnectionRepository(InputStream inputStream) {
        try {
            RepositoryPersistor repositoryPersistor = new RepositoryPersistor();
            return repositoryPersistor.readConnectionRepository(inputStream);
        }
        catch (Exception exception) {
            throw new MetadataException("Can not read repository from " + inputStream, exception);
        }
    }

    public void setDescriptor(DescriptorRepository descriptorRepository, boolean bl) {
        if (bl) {
            if (log.isDebugEnabled()) {
                log.debug("Set new global repository: " + descriptorRepository);
            }
            this.globalRepository = descriptorRepository;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Set new threaded repository: " + descriptorRepository);
            }
            threadedRepository.set(descriptorRepository);
        }
    }

    public void setDescriptor(DescriptorRepository descriptorRepository) {
        this.setDescriptor(descriptorRepository, false);
    }

    public void setPerThreadDescriptor(DescriptorRepository descriptorRepository) {
        this.setDescriptor(descriptorRepository, false);
    }

    public DescriptorRepository copyOfGlobalRepository() {
        return (DescriptorRepository)SerializationUtils.clone((Serializable)this.globalRepository);
    }

    public boolean isEnablePerThreadChanges() {
        return this.enablePerThreadChanges;
    }

    public void setEnablePerThreadChanges(boolean bl) {
        this.enablePerThreadChanges = bl;
    }

    public void addProfile(Object object, DescriptorRepository descriptorRepository) {
        if (this.metadataProfiles.contains(object)) {
            throw new MetadataException("Duplicate profile key. Key '" + object + "' already exists.");
        }
        this.metadataProfiles.put(object, descriptorRepository);
    }

    public void loadProfile(Object object) {
        if (!this.isEnablePerThreadChanges()) {
            throw new MetadataException("Can not load profile with disabled per thread mode");
        }
        DescriptorRepository descriptorRepository = (DescriptorRepository)this.metadataProfiles.get(object);
        if (descriptorRepository == null) {
            throw new MetadataException("Can not find profile for key '" + object + "'");
        }
        currentProfileKey.set(object);
        this.setDescriptor(descriptorRepository);
    }

    public Object getCurrentProfileKey() throws MetadataException {
        if (!this.isEnablePerThreadChanges()) {
            throw new MetadataException("Call to this method is undefined, since per-thread mode is disabled.");
        }
        return currentProfileKey.get();
    }

    public DescriptorRepository removeProfile(Object object) {
        return (DescriptorRepository)this.metadataProfiles.remove(object);
    }

    public void clearProfiles() {
        this.metadataProfiles.clear();
        currentProfileKey.set(null);
    }

    public void removeAllProfiles() {
        this.metadataProfiles.clear();
        currentProfileKey.set(null);
    }

    public PBKey getDefaultPBKey() {
        if (this.defaultPBKey == null) {
            this.defaultPBKey = this.buildDefaultKey();
        }
        return this.defaultPBKey;
    }

    public void setDefaultPBKey(PBKey pBKey) {
        if (this.defaultPBKey != null) {
            log.warn("The used default PBKey change. Current key is " + this.defaultPBKey + ", new key will be " + pBKey);
        }
        this.defaultPBKey = pBKey;
        log.info("Set default PBKey for convenience broker creation: " + pBKey);
    }

    private PBKey buildDefaultKey() {
        List list = this.connectionRepository().getAllDescriptor();
        PBKey pBKey = null;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            JdbcConnectionDescriptor jdbcConnectionDescriptor = (JdbcConnectionDescriptor)iterator.next();
            if (!jdbcConnectionDescriptor.isDefaultConnection()) continue;
            if (pBKey != null) {
                log.error("Found additional connection descriptor with enabled 'default-connection' " + jdbcConnectionDescriptor.getPBKey() + ". This is NOT allowed. Will use the first found descriptor " + pBKey + " as default connection");
                continue;
            }
            pBKey = jdbcConnectionDescriptor.getPBKey();
        }
        if (pBKey == null) {
            log.info("No 'default-connection' attribute set in jdbc-connection-descriptors, thus it's currently not possible to use 'defaultPersistenceBroker()'  convenience method to lookup PersistenceBroker instances. But it's possible to enable this at runtime using 'setDefaultKey' method.");
        }
        return pBKey;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

