/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ojb.broker.metadata;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.SerializationUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.ojb.broker.OJBRuntimeException;
import org.apache.ojb.broker.metadata.FieldType;
import org.apache.ojb.broker.metadata.JdbcType;
import org.apache.ojb.broker.metadata.JdbcTypesHelper;

class FieldTypeClasses {
    private FieldTypeClasses() {
    }

    static FieldType newFieldType(JdbcType jdbcType) {
        BaseFieldType baseFieldType = null;
        switch (jdbcType.getType()) {
            case 2003: {
                baseFieldType = new ArrayFieldType();
                break;
            }
            case -5: {
                baseFieldType = new LongFieldType();
                break;
            }
            case -2: {
                baseFieldType = new ByteArrayFieldType();
                break;
            }
            case -7: {
                baseFieldType = new BooleanFieldType();
                break;
            }
            case 2004: {
                baseFieldType = new BlobFieldType();
                break;
            }
            case 1: {
                baseFieldType = new StringFieldType();
                break;
            }
            case 2005: {
                baseFieldType = new ClobFieldType();
                break;
            }
            case 91: {
                baseFieldType = new DateFieldType();
                break;
            }
            case 3: {
                baseFieldType = new BigDecimalFieldType();
                break;
            }
            case 8: {
                baseFieldType = new DoubleFieldType();
                break;
            }
            case 6: {
                baseFieldType = new FloatFieldType();
                break;
            }
            case 4: {
                baseFieldType = new IntegerFieldType();
                break;
            }
            case 2000: {
                baseFieldType = new JavaObjectFieldType();
                break;
            }
            case -4: {
                baseFieldType = new ByteArrayFieldType();
                break;
            }
            case -1: {
                baseFieldType = new StringFieldType();
                break;
            }
            case 2: {
                baseFieldType = new BigDecimalFieldType();
                break;
            }
            case 7: {
                baseFieldType = new FloatFieldType();
                break;
            }
            case 2006: {
                baseFieldType = new RefFieldType();
                break;
            }
            case 5: {
                baseFieldType = new ShortFieldType();
                break;
            }
            case 2002: {
                baseFieldType = new StructFieldType();
                break;
            }
            case 92: {
                baseFieldType = new TimeFieldType();
                break;
            }
            case 93: {
                baseFieldType = new TimestampFieldType();
                break;
            }
            case -6: {
                baseFieldType = new ByteFieldType();
                break;
            }
            case -3: {
                baseFieldType = new ByteArrayFieldType();
                break;
            }
            case 12: {
                baseFieldType = new StringFieldType();
                break;
            }
            case 1111: {
                baseFieldType = new JavaObjectFieldType();
                break;
            }
            case 16: {
                baseFieldType = new BooleanFieldType();
                break;
            }
            case 70: {
                baseFieldType = new URLFieldType();
                break;
            }
            default: {
                throw new OJBRuntimeException("Unkown or not supported field type specified, specified jdbc type was '" + jdbcType + "', as string: " + JdbcTypesHelper.getSqlTypeAsString(jdbcType.getType()));
            }
        }
        baseFieldType.setSqlType(jdbcType);
        return baseFieldType;
    }

    public static class URLFieldType
    extends ImmutableFieldType {
    }

    public static class DoubleFieldType
    extends ImmutableFieldType {
    }

    public static class FloatFieldType
    extends ImmutableFieldType {
    }

    public static class LongFieldType
    extends ImmutableFieldType {
    }

    public static class IntegerFieldType
    extends ImmutableFieldType {
    }

    public static class ShortFieldType
    extends ImmutableFieldType {
    }

    public static class ByteFieldType
    extends ImmutableFieldType {
    }

    public static class BooleanFieldType
    extends ImmutableFieldType {
    }

    public static class BigDecimalFieldType
    extends ImmutableFieldType {
    }

    public static class StringFieldType
    extends ImmutableFieldType {
    }

    public static class TimestampFieldType
    extends MutableFieldType {
        public Object copy(Object object) {
            Timestamp timestamp = null;
            if (object != null) {
                Timestamp timestamp2 = (Timestamp)object;
                timestamp = (Timestamp)timestamp2.clone();
            }
            return timestamp;
        }
    }

    public static class TimeFieldType
    extends MutableFieldType {
        public Object copy(Object object) {
            Time time = (Time)object;
            return time != null ? new Time(time.getTime()) : null;
        }
    }

    public static class DateFieldType
    extends MutableFieldType {
        public Object copy(Object object) {
            Date date = (Date)object;
            return date != null ? new Date(date.getTime()) : null;
        }
    }

    public static class ByteArrayFieldType
    extends MutableFieldType {
        public Object copy(Object object) {
            byte[] byArray = null;
            if (object != null) {
                byte[] byArray2 = (byte[])object;
                int n = byArray2.length;
                byArray = new byte[n];
                System.arraycopy(object, 0, byArray, 0, n);
            }
            return byArray;
        }

        public boolean equals(Object object, Object object2) {
            return Arrays.equals((byte[])object, (byte[])object2);
        }
    }

    public static class JavaObjectFieldType
    extends MutableFieldType {
        public Object copy(Object object) {
            if (object == null) {
                return null;
            }
            Object object2 = this.copyIfCloneable(object);
            if (object2 == null) {
                object2 = this.copyIfSerializeable(object);
            }
            return object2 == null ? object : object2;
        }
    }

    public static class StructFieldType
    extends MutableFieldType {
        public Object copy(Object object) {
            if (object == null) {
                return null;
            }
            Object object2 = this.copyIfCloneable(object);
            if (object2 == null) {
                object2 = this.copyIfSerializeable(object);
            }
            return object2 == null ? object : object2;
        }
    }

    public static class RefFieldType
    extends ImmutableFieldType {
    }

    public static class ArrayFieldType
    extends ImmutableFieldType {
    }

    public static class BlobFieldType
    extends ImmutableFieldType {
    }

    public static class ClobFieldType
    extends ImmutableFieldType {
    }

    static abstract class MutableFieldType
    extends BaseFieldType {
        MutableFieldType() {
        }

        public boolean isMutable() {
            return true;
        }

        public boolean equals(Object object, Object object2) {
            return ObjectUtils.equals((Object)object, (Object)object2);
        }
    }

    static abstract class ImmutableFieldType
    extends BaseFieldType {
        ImmutableFieldType() {
        }

        public boolean isMutable() {
            return false;
        }

        public Object copy(Object object) {
            return object;
        }

        public boolean equals(Object object, Object object2) {
            return ObjectUtils.equals((Object)object, (Object)object2);
        }
    }

    static abstract class BaseFieldType
    implements FieldType {
        int sqlType;

        BaseFieldType() {
        }

        public void setSqlType(JdbcType jdbcType) {
            this.sqlType = jdbcType.getType();
        }

        public int getSqlType() {
            return this.sqlType;
        }

        Object copyIfCloneable(Object object) {
            Object object2 = null;
            if (object instanceof Cloneable) {
                try {
                    Method method = object.getClass().getMethod("clone", ArrayUtils.EMPTY_CLASS_ARRAY);
                    object2 = method.invoke(object, null);
                }
                catch (Exception exception) {
                    throw new OJBRuntimeException("Can't invoke method 'clone' on object: " + object, exception);
                }
            }
            return object2;
        }

        Object copyIfSerializeable(Object object) {
            Object object2 = null;
            if (object instanceof Serializable) {
                object2 = SerializationUtils.clone((Serializable)((Serializable)object));
            }
            return object2;
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("sqlType", this.sqlType).append("sqlTypeAsString", (Object)JdbcTypesHelper.getSqlTypeAsString(this.sqlType)).append("isMutable", this.isMutable()).toString();
        }
    }
}

